/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Mixin;
import org.apache.tapestry5.internal.InternalComponentResources;
import org.apache.tapestry5.internal.transform.ReadOnlyComponentFieldConduit;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.FieldConduit;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class MixinWorker
implements ComponentClassTransformWorker2 {
    private final ComponentClassResolver resolver;

    public MixinWorker(ComponentClassResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        for (PlasticField field : plasticClass.getFieldsWithAnnotation(Mixin.class)) {
            this.replaceFieldWithMixin(model, field);
        }
    }

    private void replaceFieldWithMixin(MutableComponentModel model, PlasticField field) {
        Mixin annotation = (Mixin)field.getAnnotation(Mixin.class);
        field.claim((Object)annotation);
        String mixinType = annotation.value();
        String[] order = annotation.order();
        String fieldType = field.getTypeName();
        String mixinClassName = InternalUtils.isBlank((String)mixinType) ? fieldType : this.resolver.resolveMixinTypeToClassName(mixinType);
        model.addMixinClassName(mixinClassName, order);
        this.replaceFieldAccessWithMixin(field, mixinClassName);
    }

    private void replaceFieldAccessWithMixin(PlasticField field, String mixinClassName) {
        ComputedValue<FieldConduit<Object>> provider = this.createMixinFieldProvider(field.getName(), mixinClassName);
        field.setComputedConduit(provider);
    }

    private ComputedValue<FieldConduit<Object>> createMixinFieldProvider(final String fieldName, final String mixinClassName) {
        return new ComputedValue<FieldConduit<Object>>(){

            public FieldConduit get(InstanceContext context) {
                ComponentResources resources = (ComponentResources)context.get(ComponentResources.class);
                final InternalComponentResources icr = (InternalComponentResources)resources;
                return new ReadOnlyComponentFieldConduit(resources, fieldName){

                    public Object get(Object instance, InstanceContext context) {
                        return icr.getMixinByClassName(mixinClassName);
                    }
                };
            }
        };
    }
}

