/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.services.javascript.InitializationPriority;

public class ModuleInitsManager {
    private final Set<String> pureInits = CollectionFactory.newSet();
    private final Map<InitializationPriority, List<Object>> inits = CollectionFactory.newMap();
    private int initCount;

    public void addInitialization(InitializationPriority priority, String moduleName, String functionName, JSONArray arguments) {
        String name;
        assert (priority != null);
        assert (InternalUtils.isNonBlank((String)moduleName));
        String string = name = functionName == null ? moduleName : moduleName + ":" + functionName;
        if (arguments == null || arguments.length() == 0) {
            if (this.pureInits.contains(name)) {
                return;
            }
            this.pureInits.add(name);
            InternalUtils.addToMapList(this.inits, (Object)((Object)priority), (Object)name);
        } else {
            JSONArray init = new JSONArray();
            init.put((Object)name);
            init.putAll((Iterable)arguments);
            InternalUtils.addToMapList(this.inits, (Object)((Object)priority), (Object)init);
        }
        ++this.initCount;
    }

    public List<?> getSortedInits() {
        ArrayList<Object> result = new ArrayList<Object>(this.initCount);
        for (InitializationPriority p : InitializationPriority.values()) {
            List<Object> initsForPriority = this.inits.get((Object)p);
            if (initsForPriority == null) continue;
            result.addAll(initsForPriority);
        }
        return result;
    }
}

