/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.kaptcha.components;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.kaptcha.services.KaptchaProducer;
import org.apache.tapestry5.services.HttpError;
import org.apache.tapestry5.services.Response;

@SupportsInformalParameters
public class KaptchaImage {
    @Persist
    private String captchaText;
    @Inject
    private KaptchaProducer producer;
    @Inject
    private ComponentResources resources;
    @Inject
    private Response response;

    public String getCaptchaText() {
        return this.captchaText;
    }

    void setupRender() {
        this.captchaText = this.producer.createText();
    }

    boolean beginRender(MarkupWriter writer) {
        Link link = this.resources.createEventLink("image", new Object[0]);
        writer.element("img", new Object[]{"src", link.toURI(), "width", this.producer.getWidth(), "height", this.producer.getHeight()});
        this.resources.renderInformalParameters(writer);
        writer.end();
        return false;
    }

    Object onImage() throws IOException {
        if (this.captchaText == null) {
            return new HttpError(404, "Session expired.");
        }
        return new StreamResponse(){

            public String getContentType() {
                return "image/jpeg";
            }

            public InputStream getStream() throws IOException {
                BufferedImage image = KaptchaImage.this.producer.createImage(KaptchaImage.this.captchaText);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)image, "jpg", baos);
                return new ByteArrayInputStream(baos.toByteArray());
            }

            public void prepareResponse(Response response) {
                response.setDateHeader("Expires", 0L);
                response.addHeader("Cache-Control", "no-store, no-cache, must-revalidate");
                response.addHeader("Cache-Control", "post-check=0, pre-check=0");
                response.setHeader("Pragma", "no-cache");
            }
        };
    }
}

