/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import java.io.Serializable;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MetaData;
import org.apache.sysds.runtime.privacy.CheckedConstraintsLog;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;

public abstract class Data
implements Serializable {
    private static final long serialVersionUID = 9176228330268046168L;
    protected final Types.DataType dataType;
    protected final Types.ValueType valueType;
    protected PrivacyConstraint _privacyConstraint = null;

    protected Data(Types.DataType dt, Types.ValueType vt) {
        this.dataType = dt;
        this.valueType = vt;
    }

    public abstract String getDebugName();

    public Types.DataType getDataType() {
        return this.dataType;
    }

    public Types.ValueType getValueType() {
        return this.valueType;
    }

    public void setPrivacyConstraints(PrivacyConstraint pc) {
        this._privacyConstraint = pc;
        if (DMLScript.CHECK_PRIVACY && pc != null) {
            CheckedConstraintsLog.addLoadedConstraint(pc.getPrivacyLevel());
        }
    }

    public PrivacyConstraint getPrivacyConstraint() {
        return this._privacyConstraint;
    }

    public void setMetaData(MetaData md) {
        throw new DMLRuntimeException("This method in the base class should never be invoked.");
    }

    public MetaData getMetaData() {
        throw new DMLRuntimeException("This method in the base class should never be invoked.");
    }

    public void removeMetaData() {
        throw new DMLRuntimeException("This method in the base class should never be invoked.");
    }

    public void updateDataCharacteristics(DataCharacteristics mc) {
        throw new DMLRuntimeException("This method in the base class should never be invoked.");
    }
}

