/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor;

import java.util.LinkedList;
import java.util.List;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.parfor.LocalTaskQueue;
import org.apache.sysds.runtime.controlprogram.parfor.Task;
import org.apache.sysds.runtime.controlprogram.parfor.TaskPartitioner;
import org.apache.sysds.runtime.instructions.cp.IntObject;

public class TaskPartitionerFactoring
extends TaskPartitioner {
    private int _numThreads = -1;

    public TaskPartitionerFactoring(long taskSize, int numThreads, String iterVarName, IntObject fromVal, IntObject toVal, IntObject incrVal) {
        super(taskSize, iterVarName, fromVal, toVal, incrVal);
        this._numThreads = numThreads;
    }

    @Override
    public List<Task> createTasks() {
        long N;
        LinkedList<Task> tasks = new LinkedList<Task>();
        long lFrom = this._fromVal.getLongValue();
        long lTo = this._toVal.getLongValue();
        long lIncr = this._incrVal.getLongValue();
        int P = this._numThreads;
        long R = N = this._numIter;
        long K = -1L;
        Task.TaskType type = null;
        long i = lFrom;
        while (i <= lTo) {
            K = this.determineNextBatchSize(R, P);
            R -= K * (long)P;
            type = K > 3L ? Task.TaskType.RANGE : Task.TaskType.SET;
            for (int j = 0; j < P && i <= lTo; ++j) {
                Task lTask = new Task(this._iterVarName, type);
                tasks.addLast(lTask);
                if (type == Task.TaskType.SET) {
                    for (long k = 0L; k < K && i <= lTo; ++k, i += lIncr) {
                        lTask.addIteration(new IntObject(i));
                    }
                    continue;
                }
                long to = Math.min(i + (K - 1L) * lIncr, lTo);
                lTask.addIteration(new IntObject(i));
                lTask.addIteration(new IntObject(to));
                lTask.addIteration(new IntObject(lIncr));
                i = to + lIncr;
            }
        }
        return tasks;
    }

    @Override
    public long createTasks(LocalTaskQueue<Task> queue) {
        long N;
        long numCreatedTasks = 0L;
        long lFrom = this._fromVal.getLongValue();
        long lTo = this._toVal.getLongValue();
        long lIncr = this._incrVal.getLongValue();
        int P = this._numThreads;
        long R = N = this._numIter;
        long K = -1L;
        Task.TaskType type = null;
        try {
            long i = lFrom;
            while (i <= lTo) {
                K = this.determineNextBatchSize(R, P);
                R -= K * (long)P;
                type = K > 3L ? Task.TaskType.RANGE : Task.TaskType.SET;
                for (int j = 0; j < P && i <= lTo; ++j) {
                    Task lTask = new Task(this._iterVarName, type);
                    if (type == Task.TaskType.SET) {
                        for (long k = 0L; k < K && i <= lTo; ++k, i += lIncr) {
                            lTask.addIteration(new IntObject(i));
                        }
                    } else {
                        long to = Math.min(i + (K - 1L) * lIncr, lTo);
                        lTask.addIteration(new IntObject(i));
                        lTask.addIteration(new IntObject(to));
                        lTask.addIteration(new IntObject(lIncr));
                        i = to + lIncr;
                    }
                    queue.enqueueTask(lTask);
                    ++numCreatedTasks;
                }
            }
            queue.closeInput();
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return numCreatedTasks;
    }

    protected long determineNextBatchSize(long R, int P) {
        int x = 2;
        long K = (long)Math.ceil((double)R / (double)(x * P));
        if (K < 1L) {
            K = 1L;
        }
        return K;
    }
}

