/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated.monitoring.services;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.DataObjectModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.EventModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.EventStageModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.HeavyHitterModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.RequestModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.StatisticsModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.TrafficModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.WorkerModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.repositories.DerbyRepository;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.repositories.IRepository;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.services.StatisticsService;

public class WorkerService {
    private static final IRepository entityRepository = new DerbyRepository();
    private static final Map<Long, Pair<String, Boolean>> cachedWorkers = new HashMap<Long, Pair<String, Boolean>>();
    private static ScheduledExecutorService executorService;

    public WorkerService() {
        double freq = ConfigurationManager.getDMLConfig().getDoubleValue("sysds.federated.monitorFreq");
        WorkerService.startStatsCollectionProcess(1, freq);
    }

    public Long create(WorkerModel model) {
        long id = entityRepository.createEntity(model);
        model.id = id;
        WorkerService.updateCachedWorkers(List.of(model), false);
        return id;
    }

    public void update(WorkerModel model) {
        entityRepository.updateEntity(model);
        WorkerService.updateCachedWorkers(List.of(model), false);
    }

    public void remove(Long id) {
        entityRepository.removeEntity(id, WorkerModel.class);
        WorkerService.updateCachedWorkers(List.of(new WorkerModel(id)), true);
    }

    public WorkerModel get(Long id) {
        WorkerModel worker = entityRepository.getEntity(id, WorkerModel.class);
        WorkerService.updateCachedWorkers(List.of(worker), false);
        return worker;
    }

    public List<WorkerModel> getAll() {
        List<WorkerModel> workers = entityRepository.getAllEntities(WorkerModel.class);
        WorkerService.updateCachedWorkers(workers, false);
        return workers;
    }

    public Boolean getWorkerOnlineStatus(Long workerId) {
        return (Boolean)cachedWorkers.get(workerId).getRight();
    }

    private static synchronized void updateCachedWorkers(List<WorkerModel> workers, boolean removeList) {
        if (removeList) {
            for (WorkerModel worker : workers) {
                cachedWorkers.remove(worker.id);
            }
        } else {
            for (WorkerModel worker : workers) {
                if (!cachedWorkers.containsKey(worker.id)) {
                    cachedWorkers.put(worker.id, (Pair<String, Boolean>)new MutablePair((Object)worker.address, (Object)false));
                    continue;
                }
                Pair<String, Boolean> oldPair = cachedWorkers.get(worker.id);
                cachedWorkers.replace(worker.id, (Pair<String, Boolean>)new MutablePair((Object)worker.address, (Object)((Boolean)oldPair.getRight())));
            }
        }
    }

    private static synchronized void startStatsCollectionProcess(int threadCount, double frequencySeconds) {
        if (executorService == null) {
            executorService = Executors.newScheduledThreadPool(threadCount);
            executorService.scheduleAtFixedRate(WorkerService.syncWorkerStatisticsRunnable(), 0L, Math.round(frequencySeconds * 1000.0), TimeUnit.MILLISECONDS);
        }
    }

    public static void syncWorkerStatisticsWithDB(StatisticsModel stats, Long id) {
        if (stats != null) {
            cachedWorkers.get(id).setValue((Object)true);
            if (stats.utilization != null) {
                CompletableFuture.runAsync(() -> entityRepository.createEntity(stats.utilization.get(0)));
            }
            if (stats.traffic != null) {
                CompletableFuture.runAsync(() -> {
                    for (TrafficModel trafficEntity : stats.traffic) {
                        if (trafficEntity.coordinatorId <= 0L) continue;
                        entityRepository.createEntity(trafficEntity);
                    }
                });
            }
            if (stats.events != null) {
                for (EventModel eventEntity : stats.events) {
                    if (eventEntity.coordinatorId <= 0L) continue;
                    CompletableFuture.runAsync(() -> {
                        Long eventId = entityRepository.createEntity(eventEntity);
                        for (EventStageModel stageEntity : eventEntity.stages) {
                            stageEntity.eventId = eventId;
                            entityRepository.createEntity(stageEntity);
                        }
                    });
                }
            }
            if (stats.dataObjects != null) {
                CompletableFuture.runAsync(() -> {
                    entityRepository.removeAllEntitiesByField("workerId", id, DataObjectModel.class);
                    for (DataObjectModel dataObjectEntity : stats.dataObjects) {
                        entityRepository.createEntity(dataObjectEntity);
                    }
                });
            }
            if (stats.requests != null) {
                CompletableFuture.runAsync(() -> {
                    entityRepository.removeAllEntitiesByField("workerId", id, RequestModel.class);
                    for (RequestModel requestEntity : stats.requests) {
                        if (requestEntity.coordinatorId <= 0L) continue;
                        entityRepository.createEntity(requestEntity);
                    }
                });
            }
            if (stats.heavyHitters != null) {
                CompletableFuture.runAsync(() -> {
                    if (!stats.heavyHitters.isEmpty()) {
                        entityRepository.removeAllEntitiesByField("workerId", id, HeavyHitterModel.class);
                        for (HeavyHitterModel heavyHitterEntity : stats.heavyHitters) {
                            entityRepository.createEntity(heavyHitterEntity);
                        }
                    }
                });
            }
        } else {
            cachedWorkers.get(id).setValue((Object)false);
        }
    }

    private static Runnable syncWorkerStatisticsRunnable() {
        return () -> {
            for (Map.Entry<Long, Pair<String, Boolean>> entry : cachedWorkers.entrySet()) {
                Long id = entry.getKey();
                String address = (String)entry.getValue().getLeft();
                CompletableFuture.supplyAsync(() -> StatisticsService.getWorkerStatistics(id, address)).thenAcceptAsync(stats -> WorkerService.syncWorkerStatisticsWithDB(stats, id));
            }
        };
    }
}

