/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops.compile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.DMLConfig;
import org.apache.sysds.lops.Data;
import org.apache.sysds.lops.FunctionCallCP;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopsException;
import org.apache.sysds.lops.OutputParameters;
import org.apache.sysds.lops.UnaryCP;
import org.apache.sysds.lops.compile.linearization.ILinearize;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysds.runtime.instructions.CPInstructionParser;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.InstructionParser;
import org.apache.sysds.runtime.instructions.SPInstructionParser;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;

public class Dag<N extends Lop> {
    private static final Log LOG = LogFactory.getLog((String)Dag.class.getName());
    private static IDSequence job_id = null;
    private static IDSequence var_index = null;
    private String scratch = "";
    private String scratchFilePath = null;
    private ArrayList<Lop> nodes = new ArrayList();

    private String getFilePath() {
        if (this.scratchFilePath == null) {
            this.scratchFilePath = this.scratch + "/_p" + DMLScript.getUUID() + "//_t0/";
        }
        return this.scratchFilePath;
    }

    public static String getNextUniqueFilenameSuffix() {
        return "temp" + job_id.getNextID();
    }

    public String getNextUniqueFilename() {
        return this.getFilePath() + Dag.getNextUniqueFilenameSuffix();
    }

    public static String getNextUniqueVarname(Types.DataType dt) {
        return (dt.isMatrix() ? "_mVar" : (dt.isFrame() ? "_fVar" : "_Var")) + var_index.getNextID();
    }

    public boolean addNode(Lop node) {
        if (this.nodes.contains(node)) {
            return false;
        }
        this.nodes.add(node);
        return true;
    }

    public ArrayList<Instruction> getJobs(StatementBlock sb, DMLConfig config) {
        if (config != null) {
            this.scratch = config.getTextValue("sysds.scratch") + "/";
        }
        List<Lop> node_v = ILinearize.linearize(this.nodes);
        this.prefetchFederated(node_v);
        ArrayList<Instruction> inst = this.doPlainInstructionGen(sb, node_v);
        return Dag.cleanupInstructions(inst);
    }

    private boolean inputNeedsPrefetch(Lop input, Lop lop) {
        return input.prefetchActivated() && lop.getExecType() != Types.ExecType.FED && input.getFederatedOutput().isForcedFederated();
    }

    private void addFedPrefetchLop(Lop input, Lop lop) {
        UnaryCP prefetch = new UnaryCP(input, Types.OpOp1.PREFETCH, input.getDataType(), input.getValueType(), Types.ExecType.CP);
        prefetch.addOutput(lop);
        lop.replaceInput(input, prefetch);
        input.removeOutput(lop);
    }

    private void prefetchFederated(List<Lop> lops) {
        for (Lop lop : lops) {
            for (Lop input : lop.getInputs()) {
                if (!this.inputNeedsPrefetch(input, lop)) continue;
                this.addFedPrefetchLop(input, lop);
            }
        }
    }

    private ArrayList<Instruction> doPlainInstructionGen(StatementBlock sb, List<Lop> nodes) {
        ArrayList<Instruction> deleteInst = new ArrayList<Instruction>();
        List<Instruction> writeInst = Dag.deleteUpdatedTransientReadVariables(sb, nodes);
        List<Instruction> endOfBlockInst = Dag.generateRemoveInstructions(sb);
        ArrayList<Instruction> inst = Dag.generateInstructionsForInputVariables(nodes);
        List<Lop> execNodes = nodes.stream().filter(l -> !l.isDataExecLocation() || ((Data)l).getOperationType().isWrite() && !Dag.isTransientWriteRead((Data)l) || ((Data)l).isPersistentRead() && l.getDataType().isScalar()).collect(Collectors.toList());
        this.generateControlProgramJobs(execNodes, inst, writeInst, deleteInst);
        inst.addAll(writeInst);
        inst.addAll(deleteInst);
        inst.addAll(endOfBlockInst);
        return inst;
    }

    private static boolean isTransientWriteRead(Data dnode) {
        Lop input = dnode.getInputs().get(0);
        return dnode.getOperationType().isTransient() && input.isDataExecLocation() && ((Data)input).getOperationType().isTransient() && dnode.getOutputParameters().getLabel().equals(input.getOutputParameters().getLabel());
    }

    private static List<Instruction> deleteUpdatedTransientReadVariables(StatementBlock sb, List<Lop> nodeV) {
        ArrayList<Instruction> insts = new ArrayList<Instruction>();
        if (sb == null) {
            return insts;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"In delete updated variables");
        }
        HashMap<String, Lop> labelNodeMapping = new HashMap<String, Lop>();
        HashSet<String> updatedLabels = new HashSet<String>();
        HashMap<String, Lop> updatedLabelsLineNum = new HashMap<String, Lop>();
        for (Lop node : nodeV) {
            if (!node.isDataExecLocation() || !((Data)node).getOperationType().isTransient() || !((Data)node).getOperationType().isRead() || ((Data)node).getDataType() != Types.DataType.MATRIX) continue;
            boolean hasWriteParent = false;
            for (Lop p : node.getOutputs()) {
                if (!p.isDataExecLocation()) continue;
                hasWriteParent = true;
                break;
            }
            if (hasWriteParent) continue;
            labelNodeMapping.put(node.getOutputParameters().getLabel(), node);
        }
        for (Lop node : nodeV) {
            if (!node.isDataExecLocation() || !((Data)node).getOperationType().isTransient() || !((Data)node).getOperationType().isWrite() || ((Data)node).getDataType() != Types.DataType.MATRIX || !labelNodeMapping.containsKey(node.getOutputParameters().getLabel()) || labelNodeMapping.containsValue(node.getInputs().get(0))) continue;
            updatedLabels.add(node.getOutputParameters().getLabel());
            updatedLabelsLineNum.put(node.getOutputParameters().getLabel(), node);
        }
        Instruction rm_inst = null;
        for (String label : updatedLabels) {
            rm_inst = VariableCPInstruction.prepareRemoveInstruction(label);
            rm_inst.setLocation((Lop)updatedLabelsLineNum.get(label));
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)rm_inst.toString());
            }
            insts.add(rm_inst);
        }
        return insts;
    }

    private static List<Instruction> generateRemoveInstructions(StatementBlock sb) {
        if (sb == null) {
            return Collections.emptyList();
        }
        ArrayList<Instruction> insts = new ArrayList<Instruction>();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"In generateRemoveInstructions()");
        }
        for (String varName : sb.liveIn().getVariableNames()) {
            if (sb.liveOut().containsVariable(varName)) continue;
            Instruction inst = VariableCPInstruction.prepareRemoveInstruction(varName);
            inst.setLocation(sb.getFilename(), sb.getEndLine(), sb.getEndLine(), -1, -1);
            insts.add(inst);
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("  Adding " + inst.toString()));
        }
        return insts;
    }

    private static ArrayList<Instruction> generateInstructionsForInputVariables(List<Lop> nodes_v) {
        ArrayList<Instruction> insts = new ArrayList<Instruction>();
        for (Lop n : nodes_v) {
            if (!n.isDataExecLocation() || ((Data)n).getOperationType().isTransient() || !((Data)n).getOperationType().isRead() || n.getDataType() != Types.DataType.MATRIX && n.getDataType() != Types.DataType.FRAME && n.getDataType() != Types.DataType.LIST || ((Data)n).isLiteral()) continue;
            try {
                String inst_string = n.getInstructions();
                CPInstruction currInstr = CPInstructionParser.parseSingleInstruction(inst_string);
                currInstr.setLocation(n);
                currInstr.setPrivacyConstraint(n);
                insts.add(currInstr);
            }
            catch (DMLRuntimeException e) {
                throw new LopsException(n.printErrorLocation() + "error generating instructions from input variables in Dag -- \n", e);
            }
        }
        return insts;
    }

    private static void excludeRemoveInstruction(String varName, List<Instruction> deleteInst) {
        for (int i = 0; i < deleteInst.size(); ++i) {
            Instruction inst = deleteInst.get(i);
            if (inst.getType() != Instruction.IType.CONTROL_PROGRAM && inst.getType() != Instruction.IType.SPARK || ((CPInstruction)inst).getCPInstructionType() != CPInstruction.CPType.Variable || !((VariableCPInstruction)inst).isRemoveVariable(varName)) continue;
            deleteInst.remove(i);
        }
    }

    private static void processConsumersForInputs(Lop node, List<Instruction> inst, List<Instruction> delteInst) {
        if (node.isAsynchronousOp()) {
            return;
        }
        for (Lop in : node.getInputs()) {
            Dag.processConsumers(in, inst, delteInst, null);
        }
    }

    private static void processConsumers(Lop node, List<Instruction> inst, List<Instruction> deleteInst, Lop locationInfo) {
        if (node.removeConsumer() == 0) {
            if (node.isAsynchronousOp()) {
                Dag.processConsumerIfAsync(node, inst, deleteInst);
            }
            if (node.isDataExecLocation() && ((Data)node).isLiteral()) {
                return;
            }
            String label = node.getOutputParameters().getLabel();
            Instruction currInstr = VariableCPInstruction.prepareRemoveInstruction(label);
            if (locationInfo != null) {
                currInstr.setLocation(locationInfo);
            } else {
                currInstr.setLocation(node);
                currInstr.setPrivacyConstraint(node);
            }
            inst.add(currInstr);
            Dag.excludeRemoveInstruction(label, deleteInst);
        }
    }

    private static void processConsumerIfAsync(Lop node, List<Instruction> inst, List<Instruction> deleteInst) {
        if (!node.isAsynchronousOp()) {
            return;
        }
        node.setAsynchronous(false);
        Dag.processConsumersForInputs(node, inst, deleteInst);
        node.setAsynchronous(true);
    }

    private void generateControlProgramJobs(List<Lop> execNodes, List<Instruction> inst, List<Instruction> writeInst, List<Instruction> deleteInst) {
        ArrayList<Lop> markedNodes = new ArrayList<Lop>();
        ArrayList<String> var_deletions = new ArrayList<String>();
        HashMap<String, Lop> var_deletionsLineNum = new HashMap<String, Lop>();
        boolean doRmVar = false;
        for (int i = 0; i < execNodes.size(); ++i) {
            Lop node = execNodes.get(i);
            doRmVar = false;
            if (node.isDataExecLocation() && ((Data)node).getOperationType().isRead() && ((Data)node).getDataType() == Types.DataType.SCALAR && node.getOutputParameters().getFile_name() == null) {
                markedNodes.add(node);
                continue;
            }
            if (!node.isDataExecLocation()) {
                NodeOutput out;
                if (node.getDataType() == Types.DataType.SCALAR) {
                    out = this.setupNodeOutputs(node, Types.ExecType.CP, false, false);
                    inst.addAll(out.getPreInstructions());
                    deleteInst.addAll(out.getLastInstructions());
                } else {
                    out = this.setupNodeOutputs(node, Types.ExecType.CP, false, false);
                    inst.addAll(out.getPreInstructions());
                    boolean hasTransientWriteParent = false;
                    for (Lop parent : node.getOutputs()) {
                        if (!parent.isDataExecLocation() || !((Data)parent).getOperationType().isWrite() || !((Data)parent).getOperationType().isTransient()) continue;
                        hasTransientWriteParent = true;
                        break;
                    }
                    if (!hasTransientWriteParent) {
                        deleteInst.addAll(out.getLastInstructions());
                    } else {
                        var_deletions.add(node.getOutputParameters().getLabel());
                        var_deletionsLineNum.put(node.getOutputParameters().getLabel(), node);
                    }
                }
                String inst_string = "";
                if (node.getType() == Lop.Type.ParameterizedBuiltin || node.getType() == Lop.Type.GroupedAgg || node.getType() == Lop.Type.DataGen) {
                    inst_string = node.getInstructions(node.getOutputParameters().getLabel());
                } else if (node.getType() == Lop.Type.FunctionCallCP) {
                    String[] inputs = new String[node.getInputs().size()];
                    String[] outputs = new String[node.getOutputs().size()];
                    int count = 0;
                    for (Lop in : node.getInputs()) {
                        inputs[count++] = in.getOutputParameters().getLabel();
                    }
                    count = 0;
                    for (Lop out2 : node.getOutputs()) {
                        outputs[count++] = out2.getOutputParameters().getLabel();
                    }
                    inst_string = node.getInstructions(inputs, outputs);
                } else if (node.getType() == Lop.Type.Nary) {
                    String[] inputs = new String[node.getInputs().size()];
                    int count = 0;
                    for (Lop in : node.getInputs()) {
                        inputs[count++] = in.getOutputParameters().getLabel();
                    }
                    inst_string = node.getInstructions(inputs, node.getOutputParameters().getLabel());
                } else if (node.getInputs().isEmpty()) {
                    inst_string = node.getInstructions(node.getOutputParameters().getLabel());
                } else if (node.getInputs().size() == 1) {
                    inst_string = node.getInstructions(node.getInputs().get(0).getOutputParameters().getLabel(), node.getOutputParameters().getLabel());
                } else if (node.getInputs().size() == 2) {
                    inst_string = node.getInstructions(node.getInputs().get(0).getOutputParameters().getLabel(), node.getInputs().get(1).getOutputParameters().getLabel(), node.getOutputParameters().getLabel());
                } else if (node.getInputs().size() == 3 || node.getType() == Lop.Type.Ctable) {
                    inst_string = node.getInstructions(node.getInputs().get(0).getOutputParameters().getLabel(), node.getInputs().get(1).getOutputParameters().getLabel(), node.getInputs().get(2).getOutputParameters().getLabel(), node.getOutputParameters().getLabel());
                } else if (node.getInputs().size() == 4) {
                    inst_string = node.getInstructions(node.getInputs().get(0).getOutputParameters().getLabel(), node.getInputs().get(1).getOutputParameters().getLabel(), node.getInputs().get(2).getOutputParameters().getLabel(), node.getInputs().get(3).getOutputParameters().getLabel(), node.getOutputParameters().getLabel());
                } else if (node.getInputs().size() == 5) {
                    inst_string = node.getInstructions(node.getInputs().get(0).getOutputParameters().getLabel(), node.getInputs().get(1).getOutputParameters().getLabel(), node.getInputs().get(2).getOutputParameters().getLabel(), node.getInputs().get(3).getOutputParameters().getLabel(), node.getInputs().get(4).getOutputParameters().getLabel(), node.getOutputParameters().getLabel());
                } else if (node.getInputs().size() == 6) {
                    inst_string = node.getInstructions(node.getInputs().get(0).getOutputParameters().getLabel(), node.getInputs().get(1).getOutputParameters().getLabel(), node.getInputs().get(2).getOutputParameters().getLabel(), node.getInputs().get(3).getOutputParameters().getLabel(), node.getInputs().get(4).getOutputParameters().getLabel(), node.getInputs().get(5).getOutputParameters().getLabel(), node.getOutputParameters().getLabel());
                } else if (node.getInputs().size() == 7) {
                    inst_string = node.getInstructions(node.getInputs().get(0).getOutputParameters().getLabel(), node.getInputs().get(1).getOutputParameters().getLabel(), node.getInputs().get(2).getOutputParameters().getLabel(), node.getInputs().get(3).getOutputParameters().getLabel(), node.getInputs().get(4).getOutputParameters().getLabel(), node.getInputs().get(5).getOutputParameters().getLabel(), node.getInputs().get(6).getOutputParameters().getLabel(), node.getOutputParameters().getLabel());
                } else {
                    String[] inputs = new String[node.getInputs().size()];
                    for (int j = 0; j < node.getInputs().size(); ++j) {
                        inputs[j] = node.getInputs().get(j).getOutputParameters().getLabel();
                    }
                    inst_string = node.getInstructions(inputs, node.getOutputParameters().getLabel());
                }
                try {
                    Instruction currInstr;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Generating instruction - " + inst_string));
                    }
                    if ((currInstr = InstructionParser.parseSingleInstruction(inst_string)) == null) {
                        throw new LopsException("Error parsing the instruction:" + inst_string);
                    }
                    if (node._beginLine != 0) {
                        currInstr.setLocation(node);
                        currInstr.setPrivacyConstraint(node);
                    } else if (!node.getOutputs().isEmpty()) {
                        currInstr.setLocation(node.getOutputs().get(0));
                        currInstr.setPrivacyConstraint(node.getOutputs().get(0));
                    } else if (!node.getInputs().isEmpty()) {
                        currInstr.setLocation(node.getInputs().get(0));
                        currInstr.setPrivacyConstraint(node.getInputs().get(0));
                    }
                    inst.add(currInstr);
                }
                catch (Exception e) {
                    throw new LopsException(node.printErrorLocation() + "Problem generating simple inst - " + inst_string, e);
                }
                markedNodes.add(node);
                doRmVar = true;
            } else if (node.isDataExecLocation()) {
                Data dnode = (Data)node;
                Types.OpOpData op = dnode.getOperationType();
                if (op.isWrite()) {
                    NodeOutput out = null;
                    out = this.setupNodeOutputs(node, Types.ExecType.CP, false, false);
                    if (dnode.getDataType() == Types.DataType.SCALAR) {
                        writeInst.addAll(out.getLastInstructions());
                        doRmVar = false;
                    } else if (dnode.getOperationType().isTransient()) {
                        deleteInst.addAll(out.getLastInstructions());
                        doRmVar = false;
                    } else {
                        inst.addAll(out.getLastInstructions());
                        doRmVar = true;
                    }
                    markedNodes.add(node);
                } else {
                    if (node.getDataType() != Types.DataType.SCALAR) {
                        throw new LopsException("Matrix READs are not handled in CP yet!");
                    }
                    node.getOutputParameters().setLabel("_Var" + var_index.getNextID());
                    String io_inst = node.getInstructions(node.getOutputParameters().getLabel(), node.getOutputParameters().getFile_name());
                    CPInstruction currInstr = CPInstructionParser.parseSingleInstruction(io_inst);
                    currInstr.setLocation(node);
                    inst.add(currInstr);
                    Instruction tempInstr = VariableCPInstruction.prepareRemoveInstruction(node.getOutputParameters().getLabel());
                    tempInstr.setLocation(node);
                    deleteInst.add(tempInstr);
                    markedNodes.add(node);
                    doRmVar = true;
                }
            }
            if (doRmVar) {
                Dag.processConsumersForInputs(node, inst, deleteInst);
            }
            doRmVar = false;
        }
        for (String var : var_deletions) {
            Instruction rmInst = VariableCPInstruction.prepareRemoveInstruction(var);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("  Adding var_deletions: " + rmInst.toString()));
            }
            rmInst.setLocation((Lop)var_deletionsLineNum.get(var));
            deleteInst.add(rmInst);
        }
        for (Lop node : markedNodes) {
            execNodes.remove(node);
        }
    }

    private static Types.FileFormat getOutputFileFormat(Lop node, boolean cellModeOverride) {
        if (node.getDataType() == Types.DataType.SCALAR && node.getExecType() == Types.ExecType.CP || node instanceof FunctionCallCP) {
            return null;
        }
        OutputParameters oparams = node.getOutputParameters();
        return oparams.getFormat();
    }

    private static String prepareAssignVarInstruction(Lop input, Lop node) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)Types.ExecType.CP);
        sb.append("\u00b0");
        sb.append("assignvar");
        sb.append("\u00b0");
        sb.append(input.prepScalarInputOperand(Types.ExecType.CP));
        sb.append("\u00b0");
        sb.append(node.prepOutputOperand());
        return sb.toString();
    }

    private NodeOutput setupNodeOutputs(Lop node, Types.ExecType et, boolean cellModeOverride, boolean copyTWrite) {
        OutputParameters oparams = node.getOutputParameters();
        NodeOutput out = new NodeOutput();
        node.setConsumerCount(node.getOutputs().size());
        out.setOutInfo(Dag.getOutputFileFormat(node, cellModeOverride));
        if (!node.isDataExecLocation()) {
            if (node.getDataType() == Types.DataType.SCALAR || node.getDataType() == Types.DataType.LIST) {
                oparams.setLabel("_Var" + var_index.getNextID());
                Instruction currInstr = VariableCPInstruction.prepareRemoveInstruction(oparams.getLabel());
                currInstr.setLocation(node);
                currInstr.setPrivacyConstraint(node);
                out.addLastInstruction(currInstr);
            } else if (!(node instanceof FunctionCallCP)) {
                oparams.setFile_name(this.getNextUniqueFilename());
                oparams.setLabel(Dag.getNextUniqueVarname(node.getDataType()));
                int blen = (int)oparams.getBlocksize();
                Instruction createvarInst = VariableCPInstruction.prepCreatevarInstruction(oparams.getLabel(), oparams.getFile_name(), true, node.getDataType(), Dag.getOutputFileFormat(node, false).toString(), new MatrixCharacteristics(oparams.getNumRows(), oparams.getNumCols(), blen, oparams.getNnz()), oparams.getUpdateType());
                createvarInst.setLocation(node);
                createvarInst.setPrivacyConstraint(node);
                out.addPreInstruction(createvarInst);
                Instruction currInstr = VariableCPInstruction.prepareRemoveInstruction(oparams.getLabel());
                currInstr.setLocation(node);
                currInstr.setPrivacyConstraint(node);
                out.addLastInstruction(currInstr);
            } else {
                FunctionCallCP fcall = (FunctionCallCP)node;
                if (fcall.getFunctionOutputs() != null && fcall.requiresOutputCreateVar()) {
                    for (Lop fnOut : fcall.getFunctionOutputs()) {
                        OutputParameters fnOutParams = fnOut.getOutputParameters();
                        Instruction createvarInst = VariableCPInstruction.prepCreatevarInstruction(fnOutParams.getLabel(), this.getFilePath() + fnOutParams.getLabel(), true, fnOut.getDataType(), Dag.getOutputFileFormat(fnOut, false).toString(), new MatrixCharacteristics(fnOutParams.getNumRows(), fnOutParams.getNumCols(), (int)fnOutParams.getBlocksize(), fnOutParams.getNnz()), oparams.getUpdateType());
                        if (node._beginLine != 0) {
                            createvarInst.setLocation(node);
                            createvarInst.setPrivacyConstraint(node);
                        } else {
                            createvarInst.setLocation(fnOut);
                            createvarInst.setPrivacyConstraint(fnOut);
                        }
                        out.addPreInstruction(createvarInst);
                    }
                }
            }
        } else if (node.getDataType() == Types.DataType.SCALAR) {
            if (!(oparams.getFile_name() != null || node instanceof Data && ((Data)node).isPersistentWrite())) {
                String io_inst = Dag.prepareAssignVarInstruction(node.getInputs().get(0), node);
                CPInstruction currInstr = CPInstructionParser.parseSingleInstruction(io_inst);
                if (node._beginLine != 0) {
                    currInstr.setLocation(node);
                } else if (!node.getInputs().isEmpty()) {
                    currInstr.setLocation(node.getInputs().get(0));
                }
                out.addLastInstruction(currInstr);
            } else {
                Lop fname = ((Data)node).getNamedInputLop("iofilename");
                String io_inst = node.getInstructions(node.getInputs().get(0).getOutputParameters().getLabel(), fname.getOutputParameters().getLabel());
                CPInstruction currInstr = CPInstructionParser.parseSingleInstruction(io_inst);
                if (node._beginLine != 0) {
                    currInstr.setLocation(node);
                } else if (!node.getInputs().isEmpty()) {
                    currInstr.setLocation(node.getInputs().get(0));
                }
                out.addLastInstruction(currInstr);
            }
        } else if (((Data)node).getOperationType().isTransient()) {
            if (et == Types.ExecType.CP) {
                String inputVarName = node.getInputs().get(0).getOutputParameters().getLabel();
                String constVarName = oparams.getLabel();
                Instruction currInstr = VariableCPInstruction.prepareCopyInstruction(inputVarName, constVarName);
                currInstr.setLocation(node);
                out.addLastInstruction(currInstr);
            } else {
                if (copyTWrite) {
                    Instruction currInstr = VariableCPInstruction.prepareCopyInstruction(node.getInputs().get(0).getOutputParameters().getLabel(), oparams.getLabel());
                    currInstr.setLocation(node);
                    out.addLastInstruction(currInstr);
                    return out;
                }
                String tempVarName = oparams.getLabel() + "temp";
                String tempFileName = this.getNextUniqueFilename();
                int blen = (int)oparams.getBlocksize();
                Instruction createvarInst = VariableCPInstruction.prepCreatevarInstruction(tempVarName, tempFileName, true, node.getDataType(), out.getOutInfo().toString(), new MatrixCharacteristics(oparams.getNumRows(), oparams.getNumCols(), blen, oparams.getNnz()), oparams.getUpdateType());
                createvarInst.setLocation(node);
                out.addPreInstruction(createvarInst);
                String constVarName = oparams.getLabel();
                String constFileName = tempFileName + constVarName;
                oparams.setFile_name(this.getFilePath() + constFileName);
                Instruction currInstr = VariableCPInstruction.prepMoveInstruction(tempVarName, constVarName);
                currInstr.setLocation(node);
                out.addLastInstruction(currInstr);
            }
        } else {
            Lop fname = ((Data)node).getNamedInputLop("iofilename");
            String io_inst = node.getInstructions(node.getInputs().get(0).getOutputParameters().getLabel(), fname.getOutputParameters().getLabel());
            Instruction currInstr = node.getExecType() == Types.ExecType.SPARK ? SPInstructionParser.parseSingleInstruction(io_inst) : CPInstructionParser.parseSingleInstruction(io_inst);
            Lop useNode = !node.getInputs().isEmpty() && node.getInputs().get((int)0)._beginLine != 0 ? node.getInputs().get(0) : node;
            currInstr.setLocation(useNode);
            currInstr.setPrivacyConstraint(useNode);
            out.addLastInstruction(currInstr);
        }
        return out;
    }

    private static ArrayList<Instruction> cleanupInstructions(List<Instruction> insts) {
        List<Instruction> tmp1 = Dag.collapseAssignvarAndRmvarInstructions(insts);
        ArrayList<Instruction> tmp2 = Dag.createPackedRmvarInstructions(tmp1);
        return tmp2;
    }

    private static List<Instruction> collapseAssignvarAndRmvarInstructions(List<Instruction> insts) {
        ArrayList<Instruction> ret = new ArrayList<Instruction>();
        Iterator<Instruction> iter = insts.iterator();
        while (iter.hasNext()) {
            Instruction inst = iter.next();
            if (iter.hasNext() && inst instanceof VariableCPInstruction && ((VariableCPInstruction)inst).isAssignOrCopyVariable()) {
                VariableCPInstruction inst1 = (VariableCPInstruction)inst;
                Instruction inst2 = iter.next();
                if (inst2 instanceof VariableCPInstruction && ((VariableCPInstruction)inst2).isRemoveVariableNoFile() && inst1.getInput1().getName().equals(((VariableCPInstruction)inst2).getInput1().getName())) {
                    ret.add(VariableCPInstruction.prepMoveInstruction(inst1.getInput1().getName(), inst1.getInput2().getName()));
                    continue;
                }
                ret.add(inst1);
                ret.add(inst2);
                continue;
            }
            ret.add(inst);
        }
        return ret;
    }

    private static ArrayList<Instruction> createPackedRmvarInstructions(List<Instruction> insts) {
        ArrayList<Instruction> ret = new ArrayList<Instruction>();
        ArrayList<String> currRmVar = new ArrayList<String>();
        for (Instruction inst : insts) {
            if (inst instanceof VariableCPInstruction && ((VariableCPInstruction)inst).isRemoveVariableNoFile()) {
                currRmVar.add(((VariableCPInstruction)inst).getInput1().getName());
                continue;
            }
            if (!currRmVar.isEmpty()) {
                ret.add(VariableCPInstruction.prepareRemoveInstruction(currRmVar.toArray(new String[0])));
                currRmVar.clear();
            }
            ret.add(inst);
        }
        if (!currRmVar.isEmpty()) {
            ret.add(VariableCPInstruction.prepareRemoveInstruction(currRmVar.toArray(new String[0])));
        }
        return ret;
    }

    static {
        job_id = new IDSequence();
        var_index = new IDSequence();
    }

    private static class NodeOutput {
        Types.FileFormat outInfo = null;
        ArrayList<Instruction> preInstructions = new ArrayList();
        ArrayList<Instruction> lastInstructions = new ArrayList();

        NodeOutput() {
        }

        public Types.FileFormat getOutInfo() {
            return this.outInfo;
        }

        public void setOutInfo(Types.FileFormat outInfo) {
            this.outInfo = outInfo;
        }

        public ArrayList<Instruction> getPreInstructions() {
            return this.preInstructions;
        }

        public void addPreInstruction(Instruction inst) {
            this.preInstructions.add(inst);
        }

        public ArrayList<Instruction> getLastInstructions() {
            return this.lastInstructions;
        }

        public void addLastInstruction(Instruction inst) {
            this.lastInstructions.add(inst);
        }
    }
}

