/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.random.Well1024a;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.lops.MMTSJ;
import org.apache.sysds.lops.MapMultChain;
import org.apache.sysds.runtime.DMLCompressionException;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupIO;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupValue;
import org.apache.sysds.runtime.compress.lib.CLALibAppend;
import org.apache.sysds.runtime.compress.lib.CLALibBinaryCellOp;
import org.apache.sysds.runtime.compress.lib.CLALibCompAgg;
import org.apache.sysds.runtime.compress.lib.CLALibLeftMultBy;
import org.apache.sysds.runtime.compress.lib.CLALibReExpand;
import org.apache.sysds.runtime.compress.lib.CLALibRightMultBy;
import org.apache.sysds.runtime.compress.lib.CLALibScalar;
import org.apache.sysds.runtime.compress.lib.CLALibSquash;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.parfor.stat.Timing;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.KahanPlus;
import org.apache.sysds.runtime.functionobjects.KahanPlusSq;
import org.apache.sysds.runtime.functionobjects.Mean;
import org.apache.sysds.runtime.functionobjects.Multiply;
import org.apache.sysds.runtime.functionobjects.SwapIndex;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.spark.data.IndexedMatrixValue;
import org.apache.sysds.runtime.matrix.data.CTableMap;
import org.apache.sysds.runtime.matrix.data.LibMatrixBincell;
import org.apache.sysds.runtime.matrix.data.LibMatrixDatagen;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.data.MatrixValue;
import org.apache.sysds.runtime.matrix.data.RandomMatrixGenerator;
import org.apache.sysds.runtime.matrix.operators.AggregateBinaryOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateTernaryOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.CMOperator;
import org.apache.sysds.runtime.matrix.operators.COVOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.QuaternaryOperator;
import org.apache.sysds.runtime.matrix.operators.ReorgOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.TernaryOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.IndexRange;
import org.apache.sysds.runtime.util.SortUtils;
import org.apache.sysds.utils.DMLCompressionStatistics;

public class CompressedMatrixBlock
extends MatrixBlock {
    private static final Log LOG = LogFactory.getLog((String)CompressedMatrixBlock.class.getName());
    private static final long serialVersionUID = 7319372019143154058L;
    protected List<AColGroup> _colGroups;
    protected Pair<Integer, int[]> v = null;
    protected boolean overlappingColGroups = false;

    public CompressedMatrixBlock() {
    }

    public CompressedMatrixBlock(int rl, int cl) {
        super(rl, cl, true);
        this.sparseBlock = null;
        this.denseBlock = null;
        this.nonZeros = -1L;
    }

    protected CompressedMatrixBlock(MatrixBlock that) {
        super(that.getNumRows(), that.getNumColumns(), true);
        this.sparseBlock = null;
        this.denseBlock = null;
        this.nonZeros = that.getNonZeros();
    }

    public CompressedMatrixBlock(CompressedMatrixBlock that) {
        super(that.getNumRows(), that.getNumColumns(), true);
        this.copyCompressedMatrix(that);
    }

    public boolean isSingleUncompressedGroup() {
        return this._colGroups != null && this._colGroups.size() == 1 && this._colGroups.get(0).getCompType() == AColGroup.CompressionType.UNCOMPRESSED;
    }

    public void allocateColGroup(AColGroup cg) {
        this._colGroups = new ArrayList<AColGroup>(1);
        this._colGroups.add(cg);
    }

    public void allocateColGroupList(List<AColGroup> colGroups) {
        this._colGroups = colGroups;
    }

    public List<AColGroup> getColGroups() {
        return this._colGroups;
    }

    public MatrixBlock decompress() {
        long nnz;
        Timing time = new Timing(true);
        long l = nnz = this.getNonZeros() == -1L ? this.recomputeNonZeros() : this.nonZeros;
        if (this.isEmpty()) {
            return new MatrixBlock(this.rlen, this.clen, true, 0L);
        }
        MatrixBlock ret = this.getUncompressedColGroupAndRemoveFromListOfColGroups();
        if (ret != null && this.getColGroups().size() == 0) {
            return ret;
        }
        if (ret == null) {
            ret = new MatrixBlock(this.rlen, this.clen, false, -1L);
        }
        ret.setNonZeros(nnz);
        ret.allocateDenseBlock();
        this.decompress(ret);
        ret.examSparsity();
        if (DMLScript.STATISTICS || LOG.isDebugEnabled()) {
            double t = time.stop();
            LOG.debug((Object)("decompressed block w/ k=1 in " + t + "ms."));
            DMLCompressionStatistics.addDecompressTime(t, 1);
        }
        return ret;
    }

    private MatrixBlock decompress(MatrixBlock ret) {
        for (AColGroup grp : this._colGroups) {
            grp.decompressToBlockUnSafe(ret, 0, this.rlen, 0);
        }
        if (ret.isInSparseFormat()) {
            ret.sortSparseRows();
        }
        if (this.isOverlapping()) {
            ret.recomputeNonZeros();
            ret.examSparsity();
        }
        return ret;
    }

    public MatrixBlock decompress(int k) {
        if (k <= 1) {
            return this.decompress();
        }
        Timing time = new Timing(true);
        MatrixBlock ret = this.getUncompressedColGroupAndRemoveFromListOfColGroups();
        if (ret != null && this.getColGroups().size() == 0) {
            return ret;
        }
        if (ret == null) {
            ret = new MatrixBlock(this.rlen, this.clen, false, -1L);
        }
        ret.allocateDenseBlock();
        this.decompress(ret, k);
        ret.examSparsity();
        if (DMLScript.STATISTICS || LOG.isDebugEnabled()) {
            double t = time.stop();
            LOG.debug((Object)("decompressed block w/ k=" + k + " in " + time.stop() + "ms."));
            DMLCompressionStatistics.addDecompressTime(t, k);
        }
        return ret;
    }

    public MatrixBlock decompress(MatrixBlock ret, int k) {
        try {
            ExecutorService pool = CommonThreadPool.get(k);
            int rlen = this.getNumRows();
            int blkz = 65535;
            int blklen = (int)Math.max(64.0, Math.ceil(65535.0 / (double)this.getNumColumns()));
            ArrayList<DecompressTask> tasks = new ArrayList<DecompressTask>();
            int i = 0;
            while (i * blklen < this.getNumRows()) {
                tasks.add(new DecompressTask(this._colGroups, ret, i * blklen, Math.min((i + 1) * blklen, rlen), this.overlappingColGroups));
                ++i;
            }
            List rtasks = pool.invokeAll(tasks);
            pool.shutdown();
            for (Future rt : rtasks) {
                rt.get();
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new DMLCompressionException("Parallel decompression failed", ex);
        }
        if (this.isOverlapping()) {
            ret.recomputeNonZeros();
            ret.examSparsity();
        }
        return ret;
    }

    private MatrixBlock getUncompressedColGroupAndRemoveFromListOfColGroups() {
        MatrixBlock ret = null;
        if (this.isOverlapping() || this._colGroups.size() == 1) {
            for (int i = 0; i < this._colGroups.size(); ++i) {
                ColGroupUncompressed guc;
                MatrixBlock gMB;
                AColGroup g = this._colGroups.get(i);
                if (!(g instanceof ColGroupUncompressed) || (gMB = (guc = (ColGroupUncompressed)g).getData()).getNumColumns() != this.getNumColumns() || gMB.getNumRows() != this.getNumRows() || gMB.isEmpty() || gMB.isInSparseFormat()) continue;
                this._colGroups.remove(i);
                return gMB;
            }
        }
        return ret;
    }

    public CompressedMatrixBlock squash(int k) {
        return CLALibSquash.squash(this, k);
    }

    @Override
    public long recomputeNonZeros() {
        if (this.isOverlapping()) {
            this.nonZeros = this.clen * this.rlen;
        } else {
            long nnz = 0L;
            for (AColGroup g : this._colGroups) {
                nnz += g.getNumberNonZeros();
            }
            this.nonZeros = nnz;
        }
        return this.nonZeros;
    }

    public long estimateCompressedSizeInMemory() {
        long total = CompressedMatrixBlock.baseSizeInMemory();
        for (AColGroup grp : this._colGroups) {
            total += grp.estimateInMemorySize();
        }
        return total;
    }

    public static long baseSizeInMemory() {
        long total = 16L;
        total += 40L;
        total += 8L;
        total += 8L;
        return total += 40L;
    }

    @Override
    public double quickGetValue(int r, int c) {
        if (this.isOverlapping()) {
            double v = 0.0;
            for (AColGroup group : this._colGroups) {
                if (Arrays.binarySearch(group.getColIndices(), c) < 0) continue;
                v += group.get(r, c);
            }
            return v;
        }
        for (AColGroup group : this._colGroups) {
            if (Arrays.binarySearch(group.getColIndices(), c) < 0) continue;
            return group.get(r, c);
        }
        return 0.0;
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = 17L;
        return ret += ColGroupIO.getExactSizeOnDisk(this._colGroups);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.rlen = in.readInt();
        this.clen = in.readInt();
        this.nonZeros = in.readLong();
        this.overlappingColGroups = in.readBoolean();
        this._colGroups = ColGroupIO.readGroups(in, this.rlen);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.rlen);
        out.writeInt(this.clen);
        out.writeLong(this.nonZeros);
        out.writeBoolean(this.overlappingColGroups);
        ColGroupIO.writeGroups(out, this._colGroups);
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException {
        this.readFields(is);
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        this.write(os);
    }

    @Override
    public MatrixBlock scalarOperations(ScalarOperator sop, MatrixValue result) {
        return CLALibScalar.scalarOperations(sop, this, result);
    }

    @Override
    public MatrixBlock binaryOperations(BinaryOperator op, MatrixValue thatValue, MatrixValue result) {
        return CLALibBinaryCellOp.binaryOperations(op, this, thatValue, result);
    }

    public MatrixBlock binaryOperationsLeft(BinaryOperator op, MatrixValue thatValue, MatrixValue result) {
        return CLALibBinaryCellOp.binaryOperationsLeft(op, this, thatValue, result);
    }

    @Override
    public MatrixBlock append(MatrixBlock that, MatrixBlock ret) {
        return CLALibAppend.append(this, that);
    }

    @Override
    public MatrixBlock append(MatrixBlock that, MatrixBlock ret, boolean cbind) {
        if (cbind) {
            return this.append(that, ret);
        }
        this.printDecompressWarning("append-rbind", that);
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(that);
        return left.append(right, ret, cbind);
    }

    @Override
    public void append(MatrixValue v2, ArrayList<IndexedMatrixValue> outlist, int blen, boolean cbind, boolean m2IsLast, int nextNCol) {
        this.printDecompressWarning("append", (MatrixBlock)v2);
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(v2);
        left.append(right, outlist, blen, cbind, m2IsLast, nextNCol);
    }

    @Override
    public MatrixBlock chainMatrixMultOperations(MatrixBlock v, MatrixBlock w, MatrixBlock out, MapMultChain.ChainType ctype) {
        return this.chainMatrixMultOperations(v, w, out, ctype, 1);
    }

    @Override
    public MatrixBlock chainMatrixMultOperations(MatrixBlock v, MatrixBlock w, MatrixBlock out, MapMultChain.ChainType ctype, int k) {
        this.checkMMChain(ctype, v, w);
        if (this.isSingleUncompressedGroup()) {
            return ((ColGroupUncompressed)this._colGroups.get(0)).getData().chainMatrixMultOperations(v, w, out, ctype, k);
        }
        if (out != null) {
            out.reset(this.clen, 1, false);
        } else {
            out = new MatrixBlock(this.clen, 1, false);
        }
        if (this.isEmptyBlock(false)) {
            return out;
        }
        BinaryOperator bop = new BinaryOperator(Multiply.getMultiplyFnObject());
        boolean allowOverlap = ConfigurationManager.getDMLConfig().getBooleanValue("sysds.compressed.overlapping");
        MatrixBlock tmp = CLALibRightMultBy.rightMultByMatrix(this, v, null, k, allowOverlap);
        if (ctype == MapMultChain.ChainType.XtwXv) {
            if (tmp instanceof CompressedMatrixBlock) {
                tmp = CLALibBinaryCellOp.binaryOperations(bop, (CompressedMatrixBlock)tmp, w, null);
            } else {
                LibMatrixBincell.bincellOpInPlace(tmp, w, bop);
            }
        }
        if (tmp instanceof CompressedMatrixBlock) {
            CLALibLeftMultBy.leftMultByMatrixTransposed(this, (CompressedMatrixBlock)tmp, out, k);
        } else {
            CLALibLeftMultBy.leftMultByMatrixTransposed(this, tmp, out, k);
        }
        out = LibMatrixReorg.transposeInPlace(out, k);
        out.recomputeNonZeros();
        return out;
    }

    @Override
    public MatrixBlock aggregateBinaryOperations(MatrixBlock m1, MatrixBlock m2, MatrixBlock ret, AggregateBinaryOperator op) {
        return this.aggregateBinaryOperations(m1, m2, ret, op, false, false);
    }

    public MatrixBlock aggregateBinaryOperations(MatrixBlock m1, MatrixBlock m2, MatrixBlock ret, AggregateBinaryOperator op, boolean transposeLeft, boolean transposeRight) {
        MatrixBlock that;
        if (m1 instanceof CompressedMatrixBlock && m2 instanceof CompressedMatrixBlock) {
            return this.doubleCompressedAggregateBinaryOperations((CompressedMatrixBlock)m1, (CompressedMatrixBlock)m2, ret, op, transposeLeft, transposeRight);
        }
        boolean transposeOutput = false;
        if (transposeLeft || transposeRight) {
            ReorgOperator r_op = new ReorgOperator(SwapIndex.getSwapIndexFnObject(), op.getNumThreads());
            if (m1 instanceof CompressedMatrixBlock && transposeLeft || m2 instanceof CompressedMatrixBlock && transposeRight) {
                transposeOutput = true;
                MatrixBlock tmp = m1;
                m1 = m2;
                m2 = tmp;
                boolean tmpLeft = transposeLeft;
                transposeLeft = !transposeRight;
                boolean bl = transposeRight = !tmpLeft;
            }
            if (!(m1 instanceof CompressedMatrixBlock) && transposeLeft) {
                m1 = new MatrixBlock().copyShallow(m1).reorgOperations(r_op, new MatrixBlock(), 0, 0, 0);
                transposeLeft = false;
            } else if (!(m2 instanceof CompressedMatrixBlock) && transposeRight) {
                m2 = new MatrixBlock().copyShallow(m2).reorgOperations(r_op, new MatrixBlock(), 0, 0, 0);
                transposeRight = false;
            }
        }
        boolean right = m1 == this;
        MatrixBlock matrixBlock = that = right ? m2 : m1;
        if (!right && m2 != this) {
            throw new DMLRuntimeException("Invalid inputs for aggregate Binary Operation which expect either m1 or m2 to be equal to the object calling");
        }
        if (right) {
            boolean allowOverlap = ConfigurationManager.getDMLConfig().getBooleanValue("sysds.compressed.overlapping");
            ret = CLALibRightMultBy.rightMultByMatrix(this, that, ret, op.getNumThreads(), allowOverlap);
        } else {
            ret = CLALibLeftMultBy.leftMultByMatrix(this, that, ret, op.getNumThreads());
        }
        if (transposeOutput) {
            ReorgOperator r_op = new ReorgOperator(SwapIndex.getSwapIndexFnObject(), op.getNumThreads());
            return ret.reorgOperations(r_op, new MatrixBlock(), 0, 0, 0);
        }
        return ret;
    }

    private MatrixBlock doubleCompressedAggregateBinaryOperations(CompressedMatrixBlock m1, CompressedMatrixBlock m2, MatrixBlock ret, AggregateBinaryOperator op, boolean transposeLeft, boolean transposeRight) {
        if (!transposeLeft && !transposeRight) {
            LOG.warn((Object)"Matrix decompression from multiplying two compressed matrices.");
            return this.aggregateBinaryOperations(m1, CompressedMatrixBlock.getUncompressed(m2), ret, op, transposeLeft, transposeRight);
        }
        if (transposeLeft && !transposeRight) {
            if (m1.getNumColumns() > m2.getNumColumns()) {
                ret = CLALibLeftMultBy.leftMultByMatrixTransposed(m1, m2, ret, op.getNumThreads());
                ReorgOperator r_op = new ReorgOperator(SwapIndex.getSwapIndexFnObject(), op.getNumThreads());
                return ret.reorgOperations(r_op, new MatrixBlock(), 0, 0, 0);
            }
            return CLALibLeftMultBy.leftMultByMatrixTransposed(m2, m1, ret, op.getNumThreads());
        }
        if (!transposeLeft && transposeRight) {
            throw new DMLCompressionException("Not Implemented compressed Matrix Mult, to produce larger matrix");
        }
        ret = this.aggregateBinaryOperations(m2, m1, ret, op);
        ReorgOperator r_op = new ReorgOperator(SwapIndex.getSwapIndexFnObject(), op.getNumThreads());
        return ret.reorgOperations(r_op, new MatrixBlock(), 0, 0, 0);
    }

    @Override
    public MatrixBlock aggregateUnaryOperations(AggregateUnaryOperator op, MatrixValue result, int blen, MatrixIndexes indexesIn) {
        return this.aggregateUnaryOperations(op, result, blen, indexesIn, false);
    }

    @Override
    public MatrixBlock aggregateUnaryOperations(AggregateUnaryOperator op, MatrixValue result, int blen, MatrixIndexes indexesIn, boolean inCP) {
        if (!(op.aggOp.increOp.fn instanceof KahanPlus || op.aggOp.increOp.fn instanceof KahanPlusSq || op.aggOp.increOp.fn instanceof Mean || op.aggOp.increOp.fn instanceof Builtin && (((Builtin)op.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MIN || ((Builtin)op.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MAX))) {
            throw new NotImplementedException("Unary aggregate " + op.aggOp.increOp.fn + " not supported yet.");
        }
        MatrixValue.CellIndex tempCellIndex = new MatrixValue.CellIndex(-1, -1);
        op.indexFn.computeDimension(this.rlen, this.clen, tempCellIndex);
        if (result == null) {
            result = new MatrixBlock(tempCellIndex.row, tempCellIndex.column, false);
        } else {
            result.reset(tempCellIndex.row, tempCellIndex.column, false);
        }
        MatrixBlock ret = (MatrixBlock)result;
        ret.allocateDenseBlock();
        return CLALibCompAgg.aggregateUnary(this, ret, op, blen, indexesIn, inCP);
    }

    @Override
    public MatrixBlock transposeSelfMatrixMultOperations(MatrixBlock out, MMTSJ.MMTSJType tstype) {
        return this.transposeSelfMatrixMultOperations(out, tstype, 1);
    }

    @Override
    public MatrixBlock transposeSelfMatrixMultOperations(MatrixBlock out, MMTSJ.MMTSJType tstype, int k) {
        if (tstype == MMTSJ.MMTSJType.LEFT) {
            if (this.isEmptyBlock()) {
                return new MatrixBlock(this.clen, this.clen, true);
            }
            if (out == null) {
                out = new MatrixBlock(this.clen, this.clen, false);
            } else {
                out.reset(this.clen, this.clen, false);
            }
            out.allocateDenseBlock();
            CLALibLeftMultBy.leftMultByTransposeSelf(this._colGroups, out, k, this.getNumColumns(), this.getMaxNumValues(), this.isOverlapping());
            return out;
        }
        throw new DMLRuntimeException("Invalid MMTSJ type '" + tstype.toString() + "'.");
    }

    @Override
    public MatrixBlock replaceOperations(MatrixValue result, double pattern, double replacement) {
        if (this.isOverlapping()) {
            this.printDecompressWarning("replaceOperations " + pattern + "  -> " + replacement);
            MatrixBlock tmp = CompressedMatrixBlock.getUncompressed(this);
            return tmp.replaceOperations(result, pattern, replacement);
        }
        CompressedMatrixBlock ret = new CompressedMatrixBlock(this.getNumRows(), this.getNumColumns());
        List<AColGroup> prev = this.getColGroups();
        int colGroupsLength = prev.size();
        ArrayList<AColGroup> retList = new ArrayList<AColGroup>(colGroupsLength);
        for (int i = 0; i < colGroupsLength; ++i) {
            retList.add(prev.get(i).replace(pattern, replacement));
        }
        ret.allocateColGroupList(retList);
        ret.recomputeNonZeros();
        ret.setOverlapping(false);
        return ret;
    }

    @Override
    public MatrixBlock reorgOperations(ReorgOperator op, MatrixValue ret, int startRow, int startColumn, int length) {
        this.printDecompressWarning(op.getClass().getSimpleName() + " -- " + op.fn.getClass().getSimpleName());
        MatrixBlock tmp = this.decompress(op.getNumThreads());
        return tmp.reorgOperations(op, ret, startRow, startColumn, length);
    }

    public ColGroupUncompressed getUncompressedColGroup() {
        for (AColGroup grp : this._colGroups) {
            if (!(grp instanceof ColGroupUncompressed)) continue;
            return (ColGroupUncompressed)grp;
        }
        return null;
    }

    public Pair<Integer, int[]> getMaxNumValues() {
        if (this.v == null) {
            int numVals = 1;
            int[] numValues = new int[this._colGroups.size()];
            for (int i = 0; i < this._colGroups.size(); ++i) {
                if (this._colGroups.get(i) instanceof ColGroupValue) {
                    int nr;
                    numValues[i] = nr = ((ColGroupValue)this._colGroups.get(i)).getNumValues();
                    numVals = Math.max(numVals, nr);
                    continue;
                }
                numValues[i] = -1;
            }
            this.v = new ImmutablePair((Object)numVals, (Object)numValues);
            return this.v;
        }
        return this.v;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompressedMatrixBlock:");
        sb.append("\nCols:" + this.getNumColumns() + " Rows:" + this.getNumRows() + " Overlapping: " + this.isOverlapping() + " nnz: " + this.nonZeros);
        if (this._colGroups != null) {
            for (AColGroup cg : this._colGroups) {
                sb.append("\n" + cg);
            }
        } else {
            sb.append("EmptyColGroups");
        }
        return sb.toString();
    }

    public boolean isOverlapping() {
        return this._colGroups.size() != 1 && this.overlappingColGroups;
    }

    public void setOverlapping(boolean overlapping) {
        this.overlappingColGroups = overlapping;
    }

    @Override
    public MatrixBlock slice(int rl, int ru, int cl, int cu, boolean deep, CacheBlock ret) {
        MatrixBlock tmp;
        this.validateSliceArgument(rl, ru, cl, cu);
        if (rl == ru && cl == cu) {
            MatrixBlock tmp2 = new MatrixBlock(1, 1, 0L);
            tmp2.appendValue(0, 0, this.getValue(rl, cl));
            return tmp2;
        }
        if (rl == 0 && ru == this.getNumRows() - 1) {
            tmp = this.sliceColumns(cl, cu);
        } else {
            if (cl == 0 && cu == this.getNumColumns() - 1) {
                MatrixBlock tmp3 = new MatrixBlock(ru + 1 - rl, this.getNumColumns(), false).allocateDenseBlock();
                for (AColGroup g : this.getColGroups()) {
                    g.decompressToBlockUnSafe(tmp3, rl, ru + 1, 0);
                }
                tmp3.recomputeNonZeros();
                return tmp3;
            }
            tmp = this.sliceColumns(cl, cu);
            tmp = tmp.slice(rl, ru, 0, tmp.getNumColumns() - 1, ret);
        }
        ((MatrixBlock)tmp).recomputeNonZeros();
        ret = tmp;
        return tmp;
    }

    private CompressedMatrixBlock sliceColumns(int cl, int cu) {
        CompressedMatrixBlock ret = new CompressedMatrixBlock(this.getNumRows(), cu + 1 - cl);
        ArrayList<AColGroup> newColGroups = new ArrayList<AColGroup>();
        for (AColGroup grp : this.getColGroups()) {
            AColGroup slice = grp.sliceColumns(cl, cu + 1);
            if (slice == null) continue;
            newColGroups.add(slice);
        }
        ret.allocateColGroupList(newColGroups);
        ret.recomputeNonZeros();
        ret.overlappingColGroups = this.isOverlapping();
        return ret;
    }

    @Override
    public void slice(ArrayList<IndexedMatrixValue> outlist, IndexRange range, int rowCut, int colCut, int blen, int boundaryRlen, int boundaryClen) {
        this.printDecompressWarning("slice for distribution to spark. (Could be implemented such that it does not decompress)");
        MatrixBlock tmp = this.getUncompressed();
        tmp.slice(outlist, range, rowCut, colCut, blen, boundaryRlen, boundaryClen);
    }

    @Override
    public MatrixBlock unaryOperations(UnaryOperator op, MatrixValue result) {
        if (Builtin.isBuiltinCode(op.fn, Builtin.BuiltinCode.ISNAN, Builtin.BuiltinCode.ISNA) && !this.containsValue(op.getPattern())) {
            return new MatrixBlock(this.getNumRows(), this.getNumColumns(), 0L);
        }
        this.printDecompressWarning("unaryOperations " + op.fn.toString());
        MatrixBlock tmp = this.getUncompressed();
        return tmp.unaryOperations(op, result);
    }

    @Override
    public boolean containsValue(double pattern) {
        if (this.isOverlapping()) {
            throw new NotImplementedException("Not implemented contains value for overlapping matrix");
        }
        for (AColGroup g : this._colGroups) {
            if (!g.containsValue(pattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double max() {
        AggregateUnaryOperator op = InstructionUtils.parseBasicAggregateUnaryOperator("uamax", 1);
        return this.aggregateUnaryOperations(op, null, 1000, null).getValue(0, 0);
    }

    @Override
    public double min() {
        AggregateUnaryOperator op = InstructionUtils.parseBasicAggregateUnaryOperator("uamin", 1);
        return this.aggregateUnaryOperations(op, null, 1000, null).getValue(0, 0);
    }

    @Override
    public double sum() {
        AggregateUnaryOperator op = InstructionUtils.parseBasicAggregateUnaryOperator("uak+", 1);
        return this.aggregateUnaryOperations(op, null, 1000, null).getValue(0, 0);
    }

    @Override
    public double sumSq() {
        AggregateUnaryOperator op = InstructionUtils.parseBasicAggregateUnaryOperator("uasqk+", 1);
        return this.aggregateUnaryOperations(op, null, 1000, null).getValue(0, 0);
    }

    @Override
    public MatrixBlock rexpandOperations(MatrixBlock ret, double max, boolean rows, boolean cast, boolean ignore, int k) {
        if (rows) {
            this.printDecompressWarning("rexpandOperations");
            MatrixBlock tmp = this.getUncompressed();
            return tmp.rexpandOperations(ret, max, rows, cast, ignore, k);
        }
        return CLALibReExpand.reExpand(this, ret, max, cast, ignore, k);
    }

    @Override
    public boolean isEmptyBlock(boolean safe) {
        return this._colGroups == null || this.nonZeros == 0L;
    }

    @Override
    public MatrixBlock binaryOperationsInPlace(BinaryOperator op, MatrixValue thatValue) {
        this.printDecompressWarning("binaryOperationsInPlace", (MatrixBlock)thatValue);
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(thatValue);
        left.binaryOperationsInPlace(op, right);
        return this;
    }

    @Override
    public void incrementalAggregate(AggregateOperator aggOp, MatrixValue correction, MatrixValue newWithCorrection, boolean deep) {
        this.printDecompressWarning("IncrementalAggregate not supported");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock correctionMatrixBlock = CompressedMatrixBlock.getUncompressed(correction);
        MatrixBlock newWithCorrectionMatrixBlock = CompressedMatrixBlock.getUncompressed(newWithCorrection);
        left.incrementalAggregate(aggOp, correctionMatrixBlock, newWithCorrectionMatrixBlock, deep);
    }

    @Override
    public void incrementalAggregate(AggregateOperator aggOp, MatrixValue newWithCorrection) {
        this.printDecompressWarning("IncrementalAggregate not supported");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock newWithCorrectionMatrixBlock = CompressedMatrixBlock.getUncompressed(newWithCorrection);
        left.incrementalAggregate(aggOp, newWithCorrectionMatrixBlock);
    }

    @Override
    public void permutationMatrixMultOperations(MatrixValue m2Val, MatrixValue out1Val, MatrixValue out2Val) {
        this.permutationMatrixMultOperations(m2Val, out1Val, out2Val, 1);
    }

    @Override
    public void permutationMatrixMultOperations(MatrixValue m2Val, MatrixValue out1Val, MatrixValue out2Val, int k) {
        this.printDecompressWarning("permutationMatrixMultOperations", (MatrixBlock)m2Val);
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(m2Val);
        left.permutationMatrixMultOperations(right, out1Val, out2Val, k);
    }

    @Override
    public MatrixBlock leftIndexingOperations(MatrixBlock rhsMatrix, int rl, int ru, int cl, int cu, MatrixBlock ret, MatrixObject.UpdateType update) {
        this.printDecompressWarning("leftIndexingOperations");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(rhsMatrix);
        return left.leftIndexingOperations(right, rl, ru, cl, cu, ret, update);
    }

    @Override
    public MatrixBlock leftIndexingOperations(ScalarObject scalar, int rl, int cl, MatrixBlock ret, MatrixObject.UpdateType update) {
        this.printDecompressWarning("leftIndexingOperations");
        MatrixBlock tmp = this.getUncompressed();
        return tmp.leftIndexingOperations(scalar, rl, cl, ret, update);
    }

    @Override
    public MatrixBlock zeroOutOperations(MatrixValue result, IndexRange range, boolean complementary) {
        this.printDecompressWarning("zeroOutOperations");
        MatrixBlock tmp = this.getUncompressed();
        return tmp.zeroOutOperations(result, range, complementary);
    }

    @Override
    public CM_COV_Object cmOperations(CMOperator op) {
        this.printDecompressWarning("cmOperations");
        if (this.isEmptyBlock()) {
            return super.cmOperations(op);
        }
        AColGroup grp = this._colGroups.get(0);
        MatrixBlock vals = grp.getValuesAsBlock();
        if (grp instanceof ColGroupValue) {
            MatrixBlock counts = CompressedMatrixBlock.getCountsAsBlock(((ColGroupValue)grp).getCounts());
            if (counts.isEmpty()) {
                return vals.cmOperations(op);
            }
            return vals.cmOperations(op, counts);
        }
        return vals.cmOperations(op);
    }

    private static MatrixBlock getCountsAsBlock(int[] counts) {
        if (counts != null) {
            MatrixBlock ret = new MatrixBlock(counts.length, 1, false);
            for (int i = 0; i < counts.length; ++i) {
                ret.quickSetValue(i, 0, counts[i]);
            }
            return ret;
        }
        return new MatrixBlock(1, 1, false);
    }

    @Override
    public CM_COV_Object cmOperations(CMOperator op, MatrixBlock weights) {
        this.printDecompressWarning("cmOperations");
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(weights);
        if (this.isEmptyBlock()) {
            return super.cmOperations(op, right);
        }
        AColGroup grp = this._colGroups.get(0);
        if (grp instanceof ColGroupUncompressed) {
            return ((ColGroupUncompressed)grp).getData().cmOperations(op);
        }
        return this.getUncompressed().cmOperations(op, right);
    }

    @Override
    public CM_COV_Object covOperations(COVOperator op, MatrixBlock that) {
        this.printDecompressWarning("covOperations");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(that);
        return left.covOperations(op, right);
    }

    @Override
    public CM_COV_Object covOperations(COVOperator op, MatrixBlock that, MatrixBlock weights) {
        this.printDecompressWarning("covOperations");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right1 = CompressedMatrixBlock.getUncompressed(that);
        MatrixBlock right2 = CompressedMatrixBlock.getUncompressed(weights);
        return left.covOperations(op, right1, right2);
    }

    @Override
    public MatrixBlock sortOperations(MatrixValue weights, MatrixBlock result) {
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(weights);
        if (this._colGroups.size() == 1) {
            AColGroup grp = this._colGroups.get(0);
            if (grp instanceof ColGroupEmpty || grp instanceof ColGroupConst) {
                return this;
            }
            this.printDecompressWarning("sortOperations");
            if (grp instanceof ColGroupUncompressed) {
                return grp.getValuesAsBlock().sortOperations(right, result);
            }
            if (right == null && grp instanceof ColGroupCompressed) {
                MatrixBlock vals = grp.getValuesAsBlock();
                int[] counts = ((ColGroupValue)grp).getCounts();
                double[] data = vals.getDenseBlock() != null ? vals.getDenseBlockValues() : null;
                SortUtils.sortByValue(0, vals.getNumRows(), data, counts);
                MatrixBlock counts2 = CompressedMatrixBlock.getCountsAsBlock(counts);
                if (counts2.isEmpty()) {
                    return vals;
                }
                return vals.sortOperations(counts2, result);
            }
            return this.getUncompressed().sortOperations(right, result);
        }
        this.printDecompressWarning("sortOperations with multiple column groups is not supported");
        return this.getUncompressed().sortOperations(weights, result);
    }

    @Override
    public MatrixBlock aggregateBinaryOperations(MatrixIndexes m1Index, MatrixBlock m1Value, MatrixIndexes m2Index, MatrixBlock m2Value, MatrixBlock result, AggregateBinaryOperator op) {
        this.printDecompressWarning("aggregateBinaryOperations");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(m2Value);
        return left.aggregateBinaryOperations(m1Index, left, m2Index, right, result, op);
    }

    @Override
    public MatrixBlock aggregateTernaryOperations(MatrixBlock m1, MatrixBlock m2, MatrixBlock m3, MatrixBlock ret, AggregateTernaryOperator op, boolean inCP) {
        boolean m1C = m1 instanceof CompressedMatrixBlock;
        boolean m2C = m2 instanceof CompressedMatrixBlock;
        boolean m3C = m3 instanceof CompressedMatrixBlock;
        this.printDecompressWarning("aggregateTernaryOperations " + op.aggOp.getClass().getSimpleName() + " " + op.indexFn.getClass().getSimpleName() + "  " + op.aggOp.increOp.fn.getClass().getSimpleName() + " " + op.binaryFn.getClass().getSimpleName() + "m1,m2,m3" + m1C + " " + m2C + " " + m3C);
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right1 = CompressedMatrixBlock.getUncompressed(m2);
        MatrixBlock right2 = CompressedMatrixBlock.getUncompressed(m3);
        return left.aggregateTernaryOperations(left, right1, right2, ret, op, inCP);
    }

    @Override
    public MatrixBlock uaggouterchainOperations(MatrixBlock mbLeft, MatrixBlock mbRight, MatrixBlock mbOut, BinaryOperator bOp, AggregateUnaryOperator uaggOp) {
        this.printDecompressWarning("uaggouterchainOperations");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(mbRight);
        return left.uaggouterchainOperations(left, right, mbOut, bOp, uaggOp);
    }

    @Override
    public MatrixBlock groupedAggOperations(MatrixValue tgt, MatrixValue wghts, MatrixValue ret, int ngroups, Operator op) {
        return this.groupedAggOperations(tgt, wghts, ret, ngroups, op, 1);
    }

    @Override
    public MatrixBlock groupedAggOperations(MatrixValue tgt, MatrixValue wghts, MatrixValue ret, int ngroups, Operator op, int k) {
        this.printDecompressWarning("groupedAggOperations");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(wghts);
        return left.groupedAggOperations(left, right, ret, ngroups, op, k);
    }

    @Override
    public MatrixBlock removeEmptyOperations(MatrixBlock ret, boolean rows, boolean emptyReturn, MatrixBlock select) {
        this.printDecompressWarning("removeEmptyOperations");
        MatrixBlock tmp = this.getUncompressed();
        return tmp.removeEmptyOperations(ret, rows, emptyReturn, select);
    }

    @Override
    public MatrixBlock removeEmptyOperations(MatrixBlock ret, boolean rows, boolean emptyReturn) {
        this.printDecompressWarning("removeEmptyOperations");
        MatrixBlock tmp = this.getUncompressed();
        return tmp.removeEmptyOperations(ret, rows, emptyReturn);
    }

    @Override
    public void ctableOperations(Operator op, double scalar, MatrixValue that, CTableMap resultMap, MatrixBlock resultBlock) {
        this.printDecompressWarning("ctableOperations Var 1");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(that);
        left.ctableOperations(op, scalar, (MatrixValue)right, resultMap, resultBlock);
    }

    @Override
    public void ctableOperations(Operator op, double scalar, double scalar2, CTableMap resultMap, MatrixBlock resultBlock) {
        this.printDecompressWarning("ctableOperations Var 2");
        MatrixBlock tmp = this.getUncompressed();
        tmp.ctableOperations(op, scalar, scalar2, resultMap, resultBlock);
    }

    @Override
    public void ctableOperations(Operator op, MatrixIndexes ix1, double scalar, boolean left, int brlen, CTableMap resultMap, MatrixBlock resultBlock) {
        this.printDecompressWarning("ctableOperations Var 3");
        MatrixBlock tmp = this.getUncompressed();
        tmp.ctableOperations(op, ix1, scalar, left, brlen, resultMap, resultBlock);
    }

    @Override
    public void ctableOperations(Operator op, MatrixValue that, double scalar, boolean ignoreZeros, CTableMap resultMap, MatrixBlock resultBlock) {
        this.printDecompressWarning("ctableOperations Var 4");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(that);
        left.ctableOperations(op, right, scalar, ignoreZeros, resultMap, resultBlock);
    }

    @Override
    public MatrixBlock ctableSeqOperations(MatrixValue that, double scalar, MatrixBlock resultBlock) {
        this.printDecompressWarning("ctableOperations Var 5");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(that);
        return left.ctableSeqOperations(right, scalar, resultBlock);
    }

    @Override
    public void ctableOperations(Operator op, MatrixValue that, MatrixValue that2, CTableMap resultMap) {
        this.printDecompressWarning("ctableOperations Var 6");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right1 = CompressedMatrixBlock.getUncompressed(that);
        MatrixBlock right2 = CompressedMatrixBlock.getUncompressed(that2);
        left.ctableOperations(op, right1, right2, resultMap);
    }

    @Override
    public void ctableOperations(Operator op, MatrixValue that, MatrixValue that2, CTableMap resultMap, MatrixBlock resultBlock) {
        this.printDecompressWarning("ctableOperations Var 7");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right1 = CompressedMatrixBlock.getUncompressed(that);
        MatrixBlock right2 = CompressedMatrixBlock.getUncompressed(that2);
        left.ctableOperations(op, right1, (MatrixValue)right2, resultMap, resultBlock);
    }

    @Override
    public MatrixBlock ternaryOperations(TernaryOperator op, MatrixBlock m2, MatrixBlock m3, MatrixBlock ret) {
        this.printDecompressWarning("ternaryOperations  " + op.fn);
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right1 = CompressedMatrixBlock.getUncompressed(m2);
        MatrixBlock right2 = CompressedMatrixBlock.getUncompressed(m3);
        return left.ternaryOperations(op, right1, right2, ret);
    }

    @Override
    public MatrixBlock quaternaryOperations(QuaternaryOperator qop, MatrixBlock um, MatrixBlock vm, MatrixBlock wm, MatrixBlock out) {
        return this.quaternaryOperations(qop, um, vm, wm, out, 1);
    }

    @Override
    public MatrixBlock quaternaryOperations(QuaternaryOperator qop, MatrixBlock um, MatrixBlock vm, MatrixBlock wm, MatrixBlock out, int k) {
        this.printDecompressWarning("quaternaryOperations");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right1 = CompressedMatrixBlock.getUncompressed(um);
        MatrixBlock right2 = CompressedMatrixBlock.getUncompressed(vm);
        MatrixBlock right3 = CompressedMatrixBlock.getUncompressed(wm);
        return left.quaternaryOperations(qop, right1, right2, right3, out, k);
    }

    @Override
    public MatrixBlock randOperationsInPlace(RandomMatrixGenerator rgen, Well1024a bigrand, long bSeed) {
        LOG.info((Object)"Inplace rand ops not on CompressedMatrix");
        MatrixBlock ret = new MatrixBlock(this.getNumRows(), this.getNumColumns(), true);
        LibMatrixDatagen.generateRandomMatrix(ret, rgen, bigrand, bSeed);
        return ret;
    }

    @Override
    public MatrixBlock randOperationsInPlace(RandomMatrixGenerator rgen, Well1024a bigrand, long bSeed, int k) {
        LOG.info((Object)"Inplace rand ops not on CompressedMatrix");
        MatrixBlock ret = new MatrixBlock(this.getNumRows(), this.getNumColumns(), true);
        LibMatrixDatagen.generateRandomMatrix(ret, rgen, bigrand, bSeed, k);
        return ret;
    }

    @Override
    public MatrixBlock seqOperationsInPlace(double from, double to, double incr) {
        throw new DMLRuntimeException("CompressedMatrixBlock: seqOperationsInPlace not supported.");
    }

    private static boolean isCompressed(MatrixBlock mb) {
        return mb instanceof CompressedMatrixBlock;
    }

    public static MatrixBlock getUncompressed(MatrixValue mVal) {
        return CompressedMatrixBlock.isCompressed((MatrixBlock)mVal) ? ((CompressedMatrixBlock)mVal).decompress(OptimizerUtils.getConstrainedNumThreads(-1)) : (MatrixBlock)mVal;
    }

    public MatrixBlock getUncompressed() {
        return CompressedMatrixBlock.isCompressed(this) ? this.decompress(OptimizerUtils.getConstrainedNumThreads(-1)) : this;
    }

    protected void printDecompressWarning(String operation) {
        LOG.warn((Object)("Operation '" + operation + "' not supported yet - decompressing for ULA operations."));
    }

    protected void printDecompressWarning(String operation, MatrixBlock m2) {
        if (CompressedMatrixBlock.isCompressed(m2)) {
            LOG.warn((Object)("Operation '" + operation + "' not supported yet - decompressing for ULA operations."));
        } else {
            LOG.warn((Object)("Operation '" + operation + "' not supported yet - decompressing'"));
        }
    }

    @Override
    public boolean isShallowSerialize() {
        return true;
    }

    @Override
    public boolean isShallowSerialize(boolean inclConvert) {
        return true;
    }

    @Override
    public void toShallowSerializeBlock() {
    }

    @Override
    public void copy(MatrixValue thatValue) {
        this.copy(thatValue, false);
    }

    private static CompressedMatrixBlock checkType(MatrixValue thatValue) {
        if (thatValue == null || !(thatValue instanceof CompressedMatrixBlock)) {
            throw new DMLRuntimeException("Invalid call to copy, requre a compressed MatrixBlock to copy to");
        }
        return (CompressedMatrixBlock)thatValue;
    }

    @Override
    public void copy(MatrixValue thatValue, boolean sp) {
        CompressedMatrixBlock that = CompressedMatrixBlock.checkType(thatValue);
        if (this == that) {
            throw new RuntimeException("Copy must not overwrite itself!");
        }
        this.copyCompressedMatrix(that);
    }

    private void copyCompressedMatrix(CompressedMatrixBlock that) {
        this.rlen = that.rlen;
        this.clen = that.clen;
        this.sparseBlock = null;
        this.denseBlock = null;
        this.nonZeros = that.getNonZeros();
        this._colGroups = new ArrayList<AColGroup>();
        for (AColGroup cg : that._colGroups) {
            this._colGroups.add(cg.copy());
        }
        this.overlappingColGroups = that.overlappingColGroups;
    }

    private static class DecompressTask
    implements Callable<Long> {
        private final List<AColGroup> _colGroups;
        private final MatrixBlock _ret;
        private final int _rl;
        private final int _ru;
        private final boolean _overlapping;

        protected DecompressTask(List<AColGroup> colGroups, MatrixBlock ret, int rl, int ru, boolean overlapping) {
            this._colGroups = colGroups;
            this._ret = ret;
            this._rl = rl;
            this._ru = ru;
            this._overlapping = overlapping;
        }

        @Override
        public Long call() {
            if (!this._overlapping && this._ret.isInSparseFormat()) {
                int[] rnnz = new int[this._ru - this._rl];
                for (AColGroup grp : this._colGroups) {
                    grp.countNonZerosPerRow(rnnz, this._rl, this._ru);
                }
                SparseBlock rows = this._ret.getSparseBlock();
                for (int i = this._rl; i < this._ru; ++i) {
                    rows.allocate(i, rnnz[i - this._rl]);
                }
            }
            for (AColGroup grp : this._colGroups) {
                grp.decompressToBlockUnSafe(this._ret, this._rl, this._ru);
            }
            if (this._ret.isInSparseFormat()) {
                this._ret.sortSparseRows(this._rl, this._ru);
            }
            return this._overlapping ? 0L : this._ret.recomputeNonZeros(this._rl, this._ru - 1);
        }
    }
}

