/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.algorithms;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.algorithms.cox.Ensure_trust_bound_output;

public class Cox
extends Script {
    public Cox() {
        String string = "scripts/algorithms/Cox.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Ensure_trust_bound_output ensure_trust_bound(Object object, Object object2, Object object3, Object object4) {
        String string = "source('scripts/algorithms/Cox.dml') as mlcontextns;[x_new, is_violated] = mlcontextns::ensure_trust_bound(x, a, b, c);";
        Script script = new Script(string);
        script.in("x", object).in("a", object2).in("b", object3).in("c", object4).out("x_new").out("is_violated");
        MLResults mLResults = script.execute();
        double d = mLResults.getDouble("x_new");
        boolean bl = mLResults.getBoolean("is_violated");
        Ensure_trust_bound_output ensure_trust_bound_output = new Ensure_trust_bound_output(d, bl);
        return ensure_trust_bound_output;
    }

    public String ensure_trust_bound__docs() {
        String string = "ensure_trust_bound =\n    function (double x, double a, double b, double c)\n    return (double x_new, boolean is_violated)\n{\n    if (a * x^2 + b * x + c > 0)\n    {\n        is_violated = TRUE;\n        rad = sqrt (b ^ 2 - 4 * a * c);\n        if (b >= 0) {\n            x_new = - (2 * c) / (b + rad);\n        } else {\n            x_new = - (b - rad) / (2 * a);\n        }\n    } else {\n        is_violated = FALSE;\n        x_new = x;\n    }\n}\n";
        return string;
    }

    public String ensure_trust_bound__source() {
        String string = "ensure_trust_bound =\n    function (double x, double a, double b, double c)\n    return (double x_new, boolean is_violated)\n{\n    if (a * x^2 + b * x + c > 0)\n    {\n        is_violated = TRUE;\n        rad = sqrt (b ^ 2 - 4 * a * c);\n        if (b >= 0) {\n            x_new = - (2 * c) / (b + rad);\n        } else {\n            x_new = - (b - rad) / (2 * a);\n        }\n    } else {\n        is_violated = FALSE;\n        x_new = x;\n    }\n}\n";
        return string;
    }

    public double update_trust_bound(Object object, Object object2, Object object3, Object object4, Object object5) {
        String string = "source('scripts/algorithms/Cox.dml') as mlcontextns;delta = mlcontextns::update_trust_bound(delta, sb_distance, so_exact, so_linear_approx, so_quadratic_approx);";
        Script script = new Script(string);
        script.in("delta", object).in("sb_distance", object2).in("so_exact", object3).in("so_linear_approx", object4).in("so_quadratic_approx", object5).out("delta");
        MLResults mLResults = script.execute();
        double d = mLResults.getDouble("delta");
        return d;
    }

    public String update_trust_bound__docs() {
        String string = "update_trust_bound =\n    function (double delta,\n              double sb_distance,\n              double so_exact,\n              double so_linear_approx,\n              double so_quadratic_approx)\n    return   (double delta)\n{\n    sigma1 = 0.25;\n    sigma2 = 0.5;\n    sigma3 = 4.0;\n\n    if (so_exact <= so_linear_approx) {\n       alpha = sigma3;\n    } else {\n       alpha = max (sigma1, - 0.5 * so_linear_approx / (so_exact - so_linear_approx));\n    }\n\n    rho = so_exact / so_quadratic_approx;\n    if (rho < 0.0001) {\n        delta = min (max (alpha, sigma1) * sb_distance, sigma2 * delta);\n    } else { if (rho < 0.25) {\n        delta = max (sigma1 * delta, min (alpha * sb_distance, sigma2 * delta));\n    } else { if (rho < 0.75) {\n        delta = max (sigma1 * delta, min (alpha * sb_distance, sigma3 * delta));\n    } else {\n        delta = max (delta, min (alpha * sb_distance, sigma3 * delta));\n    }}} \n}\n";
        return string;
    }

    public String update_trust_bound__source() {
        String string = "update_trust_bound =\n    function (double delta,\n              double sb_distance,\n              double so_exact,\n              double so_linear_approx,\n              double so_quadratic_approx)\n    return   (double delta)\n{\n    sigma1 = 0.25;\n    sigma2 = 0.5;\n    sigma3 = 4.0;\n\n    if (so_exact <= so_linear_approx) {\n       alpha = sigma3;\n    } else {\n       alpha = max (sigma1, - 0.5 * so_linear_approx / (so_exact - so_linear_approx));\n    }\n\n    rho = so_exact / so_quadratic_approx;\n    if (rho < 0.0001) {\n        delta = min (max (alpha, sigma1) * sb_distance, sigma2 * delta);\n    } else { if (rho < 0.25) {\n        delta = max (sigma1 * delta, min (alpha * sb_distance, sigma2 * delta));\n    } else { if (rho < 0.75) {\n        delta = max (sigma1 * delta, min (alpha * sb_distance, sigma3 * delta));\n    } else {\n        delta = max (delta, min (alpha * sb_distance, sigma3 * delta));\n    }}} \n}\n";
        return string;
    }
}

