/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.AbstractTransportListenerEx;
import org.apache.synapse.transport.amqp.AMQPTransportEndpoint;
import org.apache.synapse.transport.amqp.AMQPTransportException;
import org.apache.synapse.transport.amqp.AMQPTransportUtils;
import org.apache.synapse.transport.amqp.connectionfactory.AMQPTransportConnectionFactory;
import org.apache.synapse.transport.amqp.connectionfactory.AMQPTransportConnectionFactoryManager;
import org.apache.synapse.transport.amqp.ha.AMQPTransportReconnectHandler;
import org.apache.synapse.transport.amqp.pollingtask.AMQPTransportPollingTask;

public class AMQPTransportListener
extends AbstractTransportListenerEx<AMQPTransportEndpoint> {
    private ScheduledExecutorService workerPool;
    private AMQPTransportConnectionFactoryManager connectionFactoryManager;
    private ExecutorService connectionFactoryES;
    private AMQPTransportReconnectHandler haHandlerTask;

    protected void doInit() throws AxisFault {
        this.connectionFactoryES = Executors.newFixedThreadPool(AMQPTransportUtils.getIntProperty("connection-factory-pool-size", 20));
        this.connectionFactoryManager = new AMQPTransportConnectionFactoryManager();
        this.connectionFactoryManager.addConnectionFactories((ParameterInclude)this.getTransportInDescription(), this.connectionFactoryES);
        this.workerPool = Executors.newScheduledThreadPool(AMQPTransportUtils.getIntProperty("worker-pool-size", 75));
        int initialReconnectDuration = AMQPTransportUtils.getIntProperty("initial-reconnect-duration", 1000);
        double reconnectionProgressionFactor = AMQPTransportUtils.getDoubleProperty("reconnection-progression-factor", 2.0);
        int maxReconnectionDuration = AMQPTransportUtils.getIntProperty("maximum-reconnection-duration", 600000);
        this.haHandlerTask = new AMQPTransportReconnectHandler(this.connectionFactoryES, maxReconnectionDuration, reconnectionProgressionFactor, initialReconnectDuration, this.connectionFactoryManager);
        new Thread((Runnable)this.haHandlerTask, "AMQP-HA-handler-task").start();
        this.log.info((Object)"AMQP transport listener initializing..");
    }

    protected AMQPTransportEndpoint createEndpoint() {
        return new AMQPTransportEndpoint(this.workerPool, this);
    }

    protected void startEndpoint(AMQPTransportEndpoint endpoint) throws AxisFault {
        AMQPTransportPollingTask ptm = endpoint.getPollingTask();
        try {
            ptm.start();
        }
        catch (AMQPTransportException e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        this.log.info((Object)("AMQP transport polling task started listen for service '" + ptm.getServiceName() + "'"));
    }

    protected void stopEndpoint(AMQPTransportEndpoint endpoint) {
        AMQPTransportPollingTask ptm = endpoint.getPollingTask();
        ptm.stop();
        this.log.info((Object)("AMQP transport polling task stopped listen for service '" + ptm.getServiceName() + "'"));
    }

    public void stop() throws AxisFault {
        super.stop();
        this.workerPool.shutdown();
        try {
            this.connectionFactoryManager.shutDownConnectionFactories();
        }
        catch (AMQPTransportException e) {
            this.log.error((Object)"Error while shutting down connection factories, continue anyway...", (Throwable)e);
        }
        this.connectionFactoryES.shutdown();
    }

    public AMQPTransportConnectionFactory getConnectionFactory(String name) throws AMQPTransportException {
        if (this.connectionFactoryManager.getConnectionFactory(name) != null) {
            return this.connectionFactoryManager.getConnectionFactory(name);
        }
        return this.connectionFactoryManager.getConnectionFactory("default");
    }

    public AMQPTransportReconnectHandler getHaHandler() {
        return this.haHandlerTask;
    }
}

