/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.util.TimeZone;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.javax.xml.xquery.XQDynamicContext;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQItem;
import net.sf.saxon.javax.xml.xquery.XQItemType;
import net.sf.saxon.javax.xml.xquery.XQSequence;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.xqj.SaxonXQDataFactory;
import net.sf.saxon.xqj.SaxonXQForwardSequence;
import net.sf.saxon.xqj.SaxonXQItem;
import net.sf.saxon.xqj.SaxonXQSequence;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class SaxonXQDynamicContext
implements XQDynamicContext {
    protected abstract DynamicQueryContext getDynamicContext();

    protected abstract void checkNotClosed() throws XQException;

    protected abstract SaxonXQDataFactory getDataFactory() throws XQException;

    public void bindAtomicValue(QName qName, String string, XQItemType xQItemType) throws XQException {
        this.checkNotClosed();
        SaxonXQItem saxonXQItem = (SaxonXQItem)this.getDataFactory().createItemFromAtomicValue(string, xQItemType);
        this.bindExternalVariable(qName, (ValueRepresentation)saxonXQItem.getItem());
    }

    public void bindBoolean(QName qName, boolean bl, XQItemType xQItemType) throws XQException {
        this.checkNotClosed();
        this.bindExternalVariable(qName, (ValueRepresentation)BooleanValue.get((boolean)bl));
    }

    public void bindByte(QName qName, byte by, XQItemType xQItemType) throws XQException {
        this.checkNotClosed();
        SaxonXQItem saxonXQItem = (SaxonXQItem)this.getDataFactory().createItemFromByte(by, xQItemType);
        this.bindExternalVariable(qName, (ValueRepresentation)saxonXQItem.getItem());
    }

    public void bindContextItem(XQItem xQItem) throws XQException {
        this.checkNotClosed();
        this.getDynamicContext().setContextItem(((SaxonXQItem)xQItem).getItem());
    }

    public void bindDocument(QName qName, InputSource inputSource) throws XQException {
        this.checkNotClosed();
        try {
            SAXSource sAXSource = new SAXSource(inputSource);
            DocumentInfo documentInfo = this.getDynamicContext().getConfiguration().buildDocument((Source)sAXSource);
            this.getDynamicContext().setParameterValue(this.getClarkName(qName), (ValueRepresentation)documentInfo);
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public void bindDouble(QName qName, double d, XQItemType xQItemType) throws XQException {
        this.checkNotClosed();
        this.getDynamicContext().setParameterValue(this.getClarkName(qName), (ValueRepresentation)new DoubleValue(d));
    }

    public void bindFloat(QName qName, float f, XQItemType xQItemType) throws XQException {
        this.checkNotClosed();
        this.getDynamicContext().setParameterValue(this.getClarkName(qName), (ValueRepresentation)new FloatValue(f));
    }

    public void bindInt(QName qName, int n, XQItemType xQItemType) throws XQException {
        this.checkNotClosed();
        SaxonXQItem saxonXQItem = (SaxonXQItem)this.getDataFactory().createItemFromInt(n, xQItemType);
        this.bindExternalVariable(qName, (ValueRepresentation)saxonXQItem.getItem());
    }

    public void bindItem(QName qName, XQItem xQItem) throws XQException {
        this.checkNotClosed();
        this.bindExternalVariable(qName, (ValueRepresentation)((SaxonXQItem)xQItem).getItem());
    }

    public void bindLong(QName qName, long l, XQItemType xQItemType) throws XQException {
        this.checkNotClosed();
        SaxonXQItem saxonXQItem = (SaxonXQItem)this.getDataFactory().createItemFromLong(l, xQItemType);
        this.bindExternalVariable(qName, (ValueRepresentation)saxonXQItem.getItem());
    }

    public void bindNode(QName qName, Node node, XQItemType xQItemType) throws XQException {
        this.checkNotClosed();
        SaxonXQItem saxonXQItem = (SaxonXQItem)this.getDataFactory().createItemFromNode(node, xQItemType);
        this.bindExternalVariable(qName, (ValueRepresentation)saxonXQItem.getItem());
    }

    public void bindObject(QName qName, Object object, XQItemType xQItemType) throws XQException {
        this.checkNotClosed();
        SaxonXQItem saxonXQItem = (SaxonXQItem)this.getDataFactory().createItemFromObject(object, xQItemType);
        this.bindExternalVariable(qName, (ValueRepresentation)saxonXQItem.getItem());
    }

    public void bindSequence(QName qName, XQSequence xQSequence) throws XQException {
        block4: {
            this.checkNotClosed();
            try {
                if (xQSequence instanceof SaxonXQForwardSequence) {
                    this.getDynamicContext().setParameter(this.getClarkName(qName), (Object)((SaxonXQForwardSequence)xQSequence).getCleanIterator());
                    break block4;
                }
                if (xQSequence instanceof SaxonXQSequence) {
                    this.bindExternalVariable(qName, (ValueRepresentation)((SaxonXQSequence)xQSequence).getValue());
                    break block4;
                }
                throw new XQException("XQSequence value is not a Saxon sequence");
            }
            catch (XPathException xPathException) {
                throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
            }
        }
    }

    public void bindShort(QName qName, short s, XQItemType xQItemType) throws XQException {
        this.checkNotClosed();
        SaxonXQItem saxonXQItem = (SaxonXQItem)this.getDataFactory().createItemFromShort(s, xQItemType);
        this.bindExternalVariable(qName, (ValueRepresentation)saxonXQItem.getItem());
    }

    public TimeZone getImplicitTimeZone() throws XQException {
        this.checkNotClosed();
        return null;
    }

    public void setImplicitTimeZone(TimeZone timeZone) throws XQException {
        this.checkNotClosed();
    }

    private void bindExternalVariable(QName qName, ValueRepresentation valueRepresentation) {
        this.getDynamicContext().setParameterValue(this.getClarkName(qName), valueRepresentation);
    }

    private String getClarkName(QName qName) {
        String string = qName.getNamespaceURI();
        return "{" + (string == null ? "" : string) + "}" + qName.getLocalPart();
    }
}

