/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.eip.aggregator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.eip.EIPUtils;
import org.apache.synapse.mediators.eip.aggregator.Aggregate;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class AggregateMediator
extends AbstractMediator
implements ManagedLifecycle {
    private static final Log log = LogFactory.getLog(AggregateMediator.class);
    private long completionTimeoutMillis;
    private int minMessagesToComplete;
    private int maxMessagesToComplete;
    private SynapseXPath correlateExpression;
    private SynapseXPath aggregationExpression;
    private String onCompleteSequenceRef;
    private SequenceMediator onCompleteSequence;
    private Map<String, Aggregate> activeAggregates;
    private String id;
    private final Object lock;

    public AggregateMediator() {
        block2: {
            this.completionTimeoutMillis = 0L;
            this.minMessagesToComplete = -1;
            this.maxMessagesToComplete = -1;
            this.correlateExpression = null;
            this.aggregationExpression = null;
            this.onCompleteSequenceRef = null;
            this.onCompleteSequence = null;
            this.activeAggregates = Collections.synchronizedMap(new HashMap());
            this.id = null;
            this.lock = new Object();
            try {
                this.aggregationExpression = new SynapseXPath("s11:Body/child::*[position()=1] | s12:Body/child::*[position()=1]");
                this.aggregationExpression.addNamespace("s11", "http://schemas.xmlsoap.org/soap/envelope/");
                this.aggregationExpression.addNamespace("s12", "http://www.w3.org/2003/05/soap-envelope");
            }
            catch (JaxenException e) {
                if (!log.isDebugEnabled()) break block2;
                this.handleException("Unable to set the default aggregationExpression for the aggregation", (Exception)((Object)e), null);
            }
        }
    }

    @Override
    public void init(SynapseEnvironment se) {
        if (this.onCompleteSequence != null) {
            this.onCompleteSequence.init(se);
        }
    }

    @Override
    public void destroy() {
        if (this.onCompleteSequence != null) {
            this.onCompleteSequence.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog;
        block31: {
            Aggregate aggregate;
            block32: {
                String correlation;
                block30: {
                    block29: {
                        synLog = this.getLog(synCtx);
                        if (synLog.isTraceOrDebugEnabled()) {
                            synLog.traceOrDebug("Start : Aggregate mediator");
                            if (synLog.isTraceTraceEnabled()) {
                                synLog.traceTrace("Message : " + synCtx.getEnvelope());
                            }
                        }
                        try {
                            String correlationIdName;
                            aggregate = null;
                            String string = correlationIdName = this.id != null ? "aggregateCorelation." + this.id : "aggregateCorelation";
                            if (this.correlateExpression != null && this.correlateExpression.evaluate(synCtx) != null) break block29;
                            if (synCtx.getProperty(correlationIdName) == null) {
                                synLog.traceOrDebug("Unable to find aggrgation correlation XPath or property");
                                return true;
                            }
                            Object o = synCtx.getProperty(correlationIdName);
                            if (o != null && o instanceof String) {
                                correlation = (String)o;
                                break block30;
                            }
                            synLog.traceOrDebug("Unable to find aggrgation correlation property");
                            return true;
                        }
                        catch (JaxenException e) {
                            this.handleException("Unable to execute the XPATH over the message", (Exception)((Object)e), synCtx);
                            break block31;
                        }
                    }
                    while (aggregate == null) {
                        Object object = this.lock;
                        synchronized (object) {
                            if (this.activeAggregates.containsKey(this.correlateExpression.toString())) {
                                aggregate = this.activeAggregates.get(this.correlateExpression.toString());
                                if (aggregate != null && !aggregate.getLock()) {
                                    aggregate = null;
                                }
                            } else {
                                if (synLog.isTraceOrDebugEnabled()) {
                                    synLog.traceOrDebug("Creating new Aggregator - " + (this.completionTimeoutMillis > 0L ? "expires in : " + this.completionTimeoutMillis / 1000L + "secs" : "without expiry time"));
                                }
                                aggregate = new Aggregate(synCtx.getEnvironment(), this.correlateExpression.toString(), this.completionTimeoutMillis, this.minMessagesToComplete, this.maxMessagesToComplete, this);
                                if (this.completionTimeoutMillis > 0L) {
                                    synCtx.getConfiguration().getSynapseTimer().schedule((TimerTask)aggregate, this.completionTimeoutMillis);
                                }
                                aggregate.getLock();
                                this.activeAggregates.put(this.correlateExpression.toString(), aggregate);
                            }
                        }
                    }
                    break block32;
                }
                while (aggregate == null) {
                    Object object = this.lock;
                    synchronized (object) {
                        block33: {
                            if (!this.activeAggregates.containsKey(correlation)) break block33;
                            aggregate = this.activeAggregates.get(correlation);
                            if (aggregate != null) {
                                if (!aggregate.getLock()) {
                                    aggregate = null;
                                }
                            } else {
                                break;
                            }
                        }
                        if (synLog.isTraceOrDebugEnabled()) {
                            synLog.traceOrDebug("Creating new Aggregator - " + (this.completionTimeoutMillis > 0L ? "expires in : " + this.completionTimeoutMillis / 1000L + "secs" : "without expiry time"));
                        }
                        aggregate = new Aggregate(synCtx.getEnvironment(), correlation, this.completionTimeoutMillis, this.minMessagesToComplete, this.maxMessagesToComplete, this);
                        if (this.completionTimeoutMillis > 0L) {
                            Aggregate aggregate2 = aggregate;
                            synchronized (aggregate2) {
                                if (!aggregate.isCompleted()) {
                                    synCtx.getConfiguration().getSynapseTimer().schedule((TimerTask)aggregate, this.completionTimeoutMillis);
                                }
                            }
                        }
                        aggregate.getLock();
                        this.activeAggregates.put(correlation, aggregate);
                    }
                }
            }
            if (aggregate == null) {
                synLog.traceOrDebug("Unable to find an aggregate for this message - skip");
                return true;
            }
            boolean collected = aggregate.addMessage(synCtx);
            if (synLog.isTraceOrDebugEnabled() && collected) {
                synLog.traceOrDebug("Collected a message during aggregation");
                if (synLog.isTraceTraceEnabled()) {
                    synLog.traceTrace("Collected message : " + synCtx);
                }
            }
            if (aggregate.isComplete(synLog)) {
                synLog.traceOrDebug("Aggregation completed - invoking onComplete");
                this.completeAggregate(aggregate);
                synLog.traceOrDebug("End : Aggregate mediator");
                return true;
            }
            aggregate.releaseLock();
        }
        synLog.traceOrDebug("End : Aggregate mediator");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeAggregate(Aggregate aggregate) {
        boolean markedCompletedNow = false;
        boolean wasComplete = aggregate.isCompleted();
        if (wasComplete) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Aggregation completed or timed out");
        }
        AggregateMediator aggregateMediator = this;
        synchronized (aggregateMediator) {
            if (!aggregate.isCompleted()) {
                aggregate.cancel();
                aggregate.setCompleted(true);
                markedCompletedNow = true;
            }
        }
        if (!markedCompletedNow) {
            return;
        }
        MessageContext newSynCtx = this.getAggregatedMessage(aggregate);
        if (newSynCtx == null) {
            log.warn((Object)"An aggregation of messages timed out with no aggregated messages", null);
            return;
        }
        this.activeAggregates.remove(aggregate.getCorrelation());
        if (this.correlateExpression != null && !this.correlateExpression.toString().equals(aggregate.getCorrelation()) || this.correlateExpression == null) {
            if (this.onCompleteSequence != null) {
                this.onCompleteSequence.mediate(newSynCtx);
            } else if (this.onCompleteSequenceRef != null && newSynCtx.getSequence(this.onCompleteSequenceRef) != null) {
                newSynCtx.getSequence(this.onCompleteSequenceRef).mediate(newSynCtx);
            } else {
                this.handleException("Unable to find the sequence for the mediation of the aggregated message", newSynCtx);
            }
        }
    }

    private MessageContext getAggregatedMessage(Aggregate aggregate) {
        MessageContext newCtx = null;
        for (MessageContext synCtx : aggregate.getMessages()) {
            if (newCtx == null) {
                newCtx = synCtx;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Generating Aggregated message from : " + newCtx.getEnvelope()));
                continue;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Merging message : " + synCtx.getEnvelope() + " using XPath : " + (Object)((Object)this.aggregationExpression)));
                }
                EIPUtils.enrichEnvelope(newCtx.getEnvelope(), synCtx.getEnvelope(), synCtx, this.aggregationExpression);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Merged result : " + newCtx.getEnvelope()));
            }
            catch (JaxenException e) {
                this.handleException("Error merging aggregation results using XPath : " + this.aggregationExpression.toString(), (Exception)((Object)e), synCtx);
            }
        }
        return newCtx;
    }

    public SynapseXPath getCorrelateExpression() {
        return this.correlateExpression;
    }

    public void setCorrelateExpression(SynapseXPath correlateExpression) {
        this.correlateExpression = correlateExpression;
    }

    public long getCompletionTimeoutMillis() {
        return this.completionTimeoutMillis;
    }

    public void setCompletionTimeoutMillis(long completionTimeoutMillis) {
        this.completionTimeoutMillis = completionTimeoutMillis;
    }

    public int getMinMessagesToComplete() {
        return this.minMessagesToComplete;
    }

    public void setMinMessagesToComplete(int minMessagesToComplete) {
        this.minMessagesToComplete = minMessagesToComplete;
    }

    public int getMaxMessagesToComplete() {
        return this.maxMessagesToComplete;
    }

    public void setMaxMessagesToComplete(int maxMessagesToComplete) {
        this.maxMessagesToComplete = maxMessagesToComplete;
    }

    public SynapseXPath getAggregationExpression() {
        return this.aggregationExpression;
    }

    public void setAggregationExpression(SynapseXPath aggregationExpression) {
        this.aggregationExpression = aggregationExpression;
    }

    public String getOnCompleteSequenceRef() {
        return this.onCompleteSequenceRef;
    }

    public void setOnCompleteSequenceRef(String onCompleteSequenceRef) {
        this.onCompleteSequenceRef = onCompleteSequenceRef;
    }

    public SequenceMediator getOnCompleteSequence() {
        return this.onCompleteSequence;
    }

    public void setOnCompleteSequence(SequenceMediator onCompleteSequence) {
        this.onCompleteSequence = onCompleteSequence;
    }

    public Map getActiveAggregates() {
        return this.activeAggregates;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

