/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.serializer.push.sax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.ext.stax.datahandler.DataHandlerWriter;
import org.apache.axiom.om.impl.common.serializer.push.sax.ContentHandlerWriter;
import org.apache.axiom.om.impl.common.serializer.push.sax.SAXExceptionWrapper;
import org.apache.axiom.om.impl.common.serializer.push.sax.SAXHelper;
import org.apache.axiom.util.base64.Base64EncodingWriterOutputStream;
import org.apache.axiom.util.namespace.ScopedNamespaceContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

final class ContentHandlerXMLStreamWriter
implements XMLStreamWriter,
DataHandlerWriter {
    private final SAXHelper helper;
    private final ContentHandler contentHandler;
    private final LexicalHandler lexicalHandler;
    private final ScopedNamespaceContext writerNsContext;
    private final ScopedNamespaceContext outputNsContext = new ScopedNamespaceContext();

    ContentHandlerXMLStreamWriter(SAXHelper helper, ContentHandler contentHandler, LexicalHandler lexicalHandler, ScopedNamespaceContext nsContext) {
        this.helper = helper;
        this.contentHandler = contentHandler;
        this.lexicalHandler = lexicalHandler;
        this.writerNsContext = nsContext;
    }

    private static String normalize(String s) {
        return s == null ? "" : s;
    }

    private String internalGetPrefix(String namespaceURI) throws XMLStreamException {
        String prefix = this.writerNsContext.getPrefix(namespaceURI);
        if (prefix == null) {
            throw new XMLStreamException("Unbound namespace URI '" + namespaceURI + "'");
        }
        return prefix;
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        if (name.equals(DataHandlerWriter.PROPERTY)) {
            return this;
        }
        return null;
    }

    public NamespaceContext getNamespaceContext() {
        return this.writerNsContext;
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.writerNsContext.setPrefix(ContentHandlerXMLStreamWriter.normalize(prefix), ContentHandlerXMLStreamWriter.normalize(uri));
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.writerNsContext.setPrefix("", ContentHandlerXMLStreamWriter.normalize(uri));
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return this.writerNsContext.getPrefix(uri);
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.finishStartElementIfNecessary();
        this.helper.beginStartElement(ContentHandlerXMLStreamWriter.normalize(prefix), ContentHandlerXMLStreamWriter.normalize(namespaceURI), localName);
        this.writerNsContext.startScope();
        this.outputNsContext.startScope();
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElement(this.internalGetPrefix(namespaceURI), localName, namespaceURI);
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.finishStartElementIfNecessary();
        this.helper.beginStartElement(ContentHandlerXMLStreamWriter.normalize(prefix), ContentHandlerXMLStreamWriter.normalize(namespaceURI), localName);
        try {
            this.helper.finishStartElement(this.contentHandler);
            this.helper.writeEndElement(this.contentHandler, null);
        }
        catch (SAXException ex) {
            throw new SAXExceptionWrapper(ex);
        }
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeEmptyElement(this.internalGetPrefix(namespaceURI), localName, namespaceURI);
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        prefix = ContentHandlerXMLStreamWriter.normalize(prefix);
        namespaceURI = ContentHandlerXMLStreamWriter.normalize(namespaceURI);
        this.outputNsContext.setPrefix(prefix, namespaceURI);
        try {
            this.contentHandler.startPrefixMapping(prefix, namespaceURI);
        }
        catch (SAXException ex) {
            throw new SAXExceptionWrapper(ex);
        }
    }

    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        namespaceURI = ContentHandlerXMLStreamWriter.normalize(namespaceURI);
        this.outputNsContext.setPrefix("", namespaceURI);
        try {
            this.contentHandler.startPrefixMapping("", namespaceURI);
        }
        catch (SAXException ex) {
            throw new SAXExceptionWrapper(ex);
        }
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.helper.addAttribute(ContentHandlerXMLStreamWriter.normalize(prefix), ContentHandlerXMLStreamWriter.normalize(namespaceURI), localName, "CDATA", value);
    }

    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.helper.addAttribute(this.internalGetPrefix(namespaceURI), ContentHandlerXMLStreamWriter.normalize(namespaceURI), localName, "CDATA", value);
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.helper.addAttribute("", "", localName, "CDATA", value);
    }

    private void finishStartElementIfNecessary() throws XMLStreamException {
        if (this.helper.isInStartElement()) {
            try {
                this.helper.finishStartElement(this.contentHandler);
            }
            catch (SAXException ex) {
                throw new SAXExceptionWrapper(ex);
            }
        }
    }

    public void writeEndElement() throws XMLStreamException {
        this.finishStartElementIfNecessary();
        try {
            this.helper.writeEndElement(this.contentHandler, this.outputNsContext);
            this.writerNsContext.endScope();
        }
        catch (SAXException ex) {
            throw new SAXExceptionWrapper(ex);
        }
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.finishStartElementIfNecessary();
        try {
            this.contentHandler.characters(text, start, len);
        }
        catch (SAXException ex) {
            throw new SAXExceptionWrapper(ex);
        }
    }

    public void writeCharacters(String text) throws XMLStreamException {
        char[] ch = text.toCharArray();
        this.writeCharacters(ch, 0, ch.length);
    }

    public void writeCData(String data) throws XMLStreamException {
        this.finishStartElementIfNecessary();
        try {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.startCDATA();
            }
            char[] ch = data.toCharArray();
            this.contentHandler.characters(ch, 0, ch.length);
            if (this.lexicalHandler != null) {
                this.lexicalHandler.endCDATA();
            }
        }
        catch (SAXException ex) {
            throw new SAXExceptionWrapper(ex);
        }
    }

    public void writeDataHandler(DataHandler dataHandler, String contentID, boolean optimize) throws IOException, XMLStreamException {
        this.finishStartElementIfNecessary();
        Base64EncodingWriterOutputStream out = new Base64EncodingWriterOutputStream((Writer)new ContentHandlerWriter(this.contentHandler), 4096, true);
        dataHandler.writeTo((OutputStream)out);
        out.complete();
    }

    public void writeDataHandler(DataHandlerProvider dataHandlerProvider, String contentID, boolean optimize) throws IOException, XMLStreamException {
        this.writeDataHandler(dataHandlerProvider.getDataHandler(), contentID, optimize);
    }

    public void writeComment(String data) throws XMLStreamException {
        this.finishStartElementIfNecessary();
        if (this.lexicalHandler != null) {
            try {
                char[] ch = data.toCharArray();
                this.lexicalHandler.comment(ch, 0, ch.length);
            }
            catch (SAXException ex) {
                throw new SAXExceptionWrapper(ex);
            }
        }
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.finishStartElementIfNecessary();
        try {
            this.contentHandler.processingInstruction(target, "");
        }
        catch (SAXException ex) {
            throw new SAXExceptionWrapper(ex);
        }
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.finishStartElementIfNecessary();
        try {
            this.contentHandler.processingInstruction(target, data);
        }
        catch (SAXException ex) {
            throw new SAXExceptionWrapper(ex);
        }
    }

    public void writeEntityRef(String name) throws XMLStreamException {
        this.finishStartElementIfNecessary();
        try {
            this.contentHandler.skippedEntity(name);
        }
        catch (SAXException ex) {
            throw new SAXExceptionWrapper(ex);
        }
    }

    public void flush() throws XMLStreamException {
    }

    public void close() throws XMLStreamException {
        throw new UnsupportedOperationException("OMDataSource#serialize(XMLStreamWriter) MUST NOT call XMLStreamWriter#close()");
    }

    public void writeStartDocument() throws XMLStreamException {
        throw new UnsupportedOperationException("OMDataSource#serialize(XMLStreamWriter) MUST NOT use XMLStreamWriter#writeStartDocument()");
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        throw new UnsupportedOperationException("OMDataSource#serialize(XMLStreamWriter) MUST NOT use XMLStreamWriter#writeStartDocument(String)");
    }

    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        throw new UnsupportedOperationException("OMDataSource#serialize(XMLStreamWriter) MUST NOT use XMLStreamWriter#writeStartDocument(String, String)");
    }

    public void writeEndDocument() throws XMLStreamException {
        throw new UnsupportedOperationException("OMDataSource#serialize(XMLStreamWriter) MUST NOT use XMLStreamWriter#writeEndDocument()");
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        throw new UnsupportedOperationException("OMDataSource#serialize(XMLStreamWriter) MUST NOT use XMLStreamWriter#writeStartElement(String)");
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        throw new UnsupportedOperationException("OMDataSource#serialize(XMLStreamWriter) MUST NOT use XMLStreamWriter#writeEmptyElement(String)");
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public void writeDTD(String dtd) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }
}

