/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.fix;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.transport.base.AbstractTransportListener;
import org.apache.axis2.transport.base.AbstractTransportSender;
import org.apache.axis2.transport.base.BaseConstants;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.fix.AxisFIXException;
import org.apache.synapse.transport.fix.FIXOutTransportInfo;
import org.apache.synapse.transport.fix.FIXTransportSender;
import org.apache.synapse.transport.fix.FIXUtils;
import org.apache.synapse.transport.fix.SessionEventHandler;
import quickfix.Application;
import quickfix.DoNotSend;
import quickfix.FieldNotFound;
import quickfix.IncorrectDataFormat;
import quickfix.IncorrectTagValue;
import quickfix.IntField;
import quickfix.Message;
import quickfix.RejectLogon;
import quickfix.SessionID;
import quickfix.StringField;
import quickfix.UnsupportedMessageType;
import quickfix.field.MsgSeqNum;
import quickfix.field.MsgType;
import quickfix.field.SenderCompID;
import quickfix.field.TargetCompID;

public class FIXIncomingMessageHandler
implements Application {
    private ConfigurationContext cfgCtx;
    private WorkerPool workerPool;
    private AxisService service;
    private Log log;
    private boolean acceptor;
    private Map<SessionID, AtomicInteger> countersMap;
    private Queue<MessageContext> outgoingMessages;
    private boolean allNewApproach = true;
    private boolean dropExtraResponses = false;
    private Semaphore semaphore;
    private SessionEventHandler eventHandler;
    private boolean singleThreaded;

    public FIXIncomingMessageHandler(ConfigurationContext cfgCtx, WorkerPool workerPool, AxisService service, boolean acceptor) {
        this.cfgCtx = cfgCtx;
        this.workerPool = workerPool;
        this.service = service;
        this.log = LogFactory.getLog(this.getClass());
        this.acceptor = acceptor;
        this.countersMap = new ConcurrentHashMap<SessionID, AtomicInteger>();
        this.outgoingMessages = new LinkedBlockingQueue<MessageContext>();
        this.semaphore = new Semaphore(0);
        this.getResponseHandlingApproach();
        Parameter eventHandlerParam = acceptor ? service.getParameter("transport.fix.AcceptorSessionEventHandler") : service.getParameter("transport.fix.InitiatorSessionEventHandler");
        if (eventHandlerParam != null && eventHandlerParam.getValue() != null && !"".equals(eventHandlerParam.getValue())) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass((String)eventHandlerParam.getValue());
                this.eventHandler = (SessionEventHandler)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                this.log.error((Object)("Unable to find the session event handler class: " + eventHandlerParam.getValue()), (Throwable)e);
            }
            catch (Exception e) {
                this.log.error((Object)("Error while initializing the session event handler class: " + eventHandlerParam.getValue()), (Throwable)e);
            }
        }
        this.singleThreaded = this.isSingleThreaded();
    }

    private void getResponseHandlingApproach() {
        Parameter dropResponsesParam;
        Parameter param = this.service.getParameter("transport.fix.SendAllToInSequence");
        if (param != null && "false".equals(param.getValue().toString())) {
            this.allNewApproach = false;
        }
        if ((dropResponsesParam = this.service.getParameter("transport.fix.DropExtraResponses")) != null && "true".equals(dropResponsesParam.getValue().toString())) {
            this.dropExtraResponses = true;
        }
    }

    private boolean isSingleThreaded() {
        Parameter singleThreadParam = this.service.getParameter("transport.fix.AcceptorSingleThreaded");
        if (this.acceptor && singleThreadParam != null && JavaUtils.isTrueExplicitly((Object)singleThreadParam.getValue())) {
            this.log.info((Object)("FIX acceptor for service: " + this.service.getName() + " is single threaded"));
            return true;
        }
        singleThreadParam = this.service.getParameter("transport.fix.InitiatorSingleThreaded");
        if (!this.acceptor && singleThreadParam != null && JavaUtils.isTrueExplicitly((Object)singleThreadParam.getValue())) {
            this.log.info((Object)("FIX initiator for service: " + this.service.getName() + " is single threaded"));
            return true;
        }
        singleThreadParam = this.service.getParameter("transport.fix.ProcessSingleThreaded");
        if (singleThreadParam != null && JavaUtils.isTrueExplicitly((Object)singleThreadParam.getValue())) {
            this.log.info((Object)("FIX processor for service: " + this.service.getName() + " is single threaded"));
            return true;
        }
        return false;
    }

    public void setOutgoingMessageContext(MessageContext msgCtx) {
        if (!this.allNewApproach) {
            this.outgoingMessages.offer(msgCtx);
        }
    }

    public void acquire() throws InterruptedException {
        this.semaphore.acquire();
    }

    private void handleException(String msg, Exception e) {
        this.log.error((Object)msg, (Throwable)e);
        throw new AxisFIXException(msg, e);
    }

    public void onCreate(SessionID sessionID) {
        this.log.info((Object)("New FIX session created: " + sessionID.toString()));
        if (this.eventHandler != null) {
            this.eventHandler.onCreate(sessionID);
        }
    }

    public void onLogon(SessionID sessionID) {
        if (!this.countersMap.containsKey(sessionID)) {
            this.countersMap.put(sessionID, new AtomicInteger(0));
        }
        this.log.info((Object)("FIX session logged on: " + sessionID.toString()));
        this.semaphore.release();
        if (this.eventHandler != null) {
            this.eventHandler.onLogon(sessionID);
        }
    }

    public void onLogout(SessionID sessionID) {
        FIXTransportSender trpSender = (FIXTransportSender)this.cfgCtx.getAxisConfiguration().getTransportOut("fix").getSender();
        trpSender.logOutIncomingSession(sessionID);
        this.log.info((Object)("FIX session logged out: " + sessionID.toString()));
        if (this.eventHandler != null) {
            this.eventHandler.onLogout(sessionID);
        }
    }

    public void toAdmin(Message message, SessionID sessionID) {
        if (this.log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            try {
                sb.append("Sending admin level FIX message to ").append(message.getHeader().getField((StringField)new TargetCompID()).getValue());
                sb.append("\nMessage Type: ").append(message.getHeader().getField((StringField)new MsgType()).getValue());
                sb.append("\nMessage Sequence Number: ").append(message.getHeader().getField((IntField)new MsgSeqNum()).getValue());
                sb.append("\nSender ID: ").append(message.getHeader().getField((StringField)new SenderCompID()).getValue());
            }
            catch (FieldNotFound e) {
                sb.append("Sending admin level FIX message...");
                this.log.warn((Object)"One or more required fields are not found in the response message", (Throwable)e);
            }
            this.log.debug((Object)sb.toString());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Message: " + message.toString()));
            }
        }
        if (this.eventHandler != null) {
            this.eventHandler.toAdmin(message, sessionID);
        }
    }

    public void fromAdmin(Message message, SessionID sessionID) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, RejectLogon {
        if (this.log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Received admin level FIX message from ").append(message.getHeader().getField((StringField)new SenderCompID()).getValue());
            sb.append("\nMessage Type: ").append(message.getHeader().getField((StringField)new MsgType()).getValue());
            sb.append("\nMessage Sequence Number: ").append(message.getHeader().getField((IntField)new MsgSeqNum()).getValue());
            sb.append("\nReceiver ID: ").append(message.getHeader().getField((StringField)new TargetCompID()).getValue());
            this.log.debug((Object)sb.toString());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Message: " + message.toString()));
            }
        }
        if (this.eventHandler != null) {
            this.eventHandler.fromAdmin(message, sessionID);
        }
    }

    public void toApp(Message message, SessionID sessionID) throws DoNotSend {
        if (this.log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            try {
                sb.append("Sending application level FIX message to ").append(message.getHeader().getField((StringField)new TargetCompID()).getValue());
                sb.append("\nMessage Type: ").append(message.getHeader().getField((StringField)new MsgType()).getValue());
                sb.append("\nMessage Sequence Number: ").append(message.getHeader().getField((IntField)new MsgSeqNum()).getValue());
                sb.append("\nSender ID: ").append(message.getHeader().getField((StringField)new SenderCompID()).getValue());
            }
            catch (FieldNotFound e) {
                sb.append("Sending application level FIX message...");
                this.log.warn((Object)"One or more required fields are not found in the response message", (Throwable)e);
            }
            this.log.debug((Object)sb.toString());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Message: " + message.toString()));
            }
        }
        if (this.eventHandler != null) {
            this.eventHandler.toApp(message, sessionID);
        }
    }

    public void fromApp(Message message, SessionID sessionID) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
        if (this.log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Received FIX message from ").append(message.getHeader().getField((StringField)new SenderCompID()).getValue());
            sb.append("\nMessage Sequence Number: ").append(message.getHeader().getField((IntField)new MsgSeqNum()).getValue());
            sb.append("\nReceiver ID: ").append(message.getHeader().getField((StringField)new TargetCompID()).getValue());
            this.log.debug((Object)sb.toString());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Message: " + message.toString()));
            }
        }
        AtomicInteger atomicCounter = this.countersMap.get(sessionID);
        int counter = atomicCounter.incrementAndGet();
        boolean rolled = atomicCounter.compareAndSet(1000000000, 0);
        if (rolled && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Incoming request counter rolled over for the session: " + sessionID));
        }
        if (this.singleThreaded) {
            this.processMessage(message, sessionID, counter);
        } else {
            this.workerPool.execute((Runnable)new FIXWorkerThread(message, sessionID, counter));
        }
    }

    public void processMessage(Message message, SessionID sessionID, int counter) {
        if (this.allNewApproach) {
            this.handleIncomingRequest(message, sessionID, counter);
        } else if (this.acceptor) {
            this.handleIncomingRequest(message, sessionID, counter);
        } else {
            MessageContext outMsgCtx = this.outgoingMessages.poll();
            if (outMsgCtx != null) {
                this.handleIncomingResponse(outMsgCtx, message, sessionID, counter);
            } else if (!this.dropExtraResponses) {
                this.handleIncomingRequest(message, sessionID, counter);
            } else {
                this.log.debug((Object)"Dropping additional FIX response");
            }
        }
    }

    private void handleIncomingRequest(Message message, SessionID sessionID, int counter) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Source session: " + sessionID + " - Received message with sequence number " + counter));
        }
        AbstractTransportListener trpListener = (AbstractTransportListener)this.cfgCtx.getAxisConfiguration().getTransportIn("fix").getReceiver();
        MessageContext msgCtx = trpListener.createMessageContext();
        msgCtx.setProperty("OutTransportInfo", (Object)new FIXOutTransportInfo(sessionID));
        if (this.service != null) {
            msgCtx.setAxisService(this.service);
            Parameter operationParam = this.service.getParameter("Operation");
            QName operationQName = operationParam != null ? BaseUtils.getQNameFromString((Object)operationParam.getValue()) : BaseConstants.DEFAULT_OPERATION;
            AxisOperation operation = this.service.getOperation(operationQName);
            if (operation != null) {
                msgCtx.setAxisOperation(operation);
                msgCtx.setAxisMessage(operation.getMessage("In"));
                msgCtx.setSoapAction("urn:" + operation.getName().getLocalPart());
            }
        }
        String fixApplication = "initiator";
        if (this.acceptor) {
            fixApplication = "acceptor";
        } else {
            msgCtx.setProperty("synapse.isresponse", (Object)true);
        }
        try {
            FIXUtils.getInstance().setSOAPEnvelope(message, counter, sessionID.toString(), msgCtx);
            trpListener.handleIncomingMessage(msgCtx, FIXUtils.getTransportHeaders(this.service.getName(), fixApplication), null, "text/xml");
        }
        catch (AxisFault e) {
            this.handleException("Error while processing FIX message", (Exception)((Object)e));
        }
    }

    private void handleIncomingResponse(MessageContext outMsgCtx, Message message, SessionID sessionID, int counter) {
        AbstractTransportSender trpSender = (AbstractTransportSender)this.cfgCtx.getAxisConfiguration().getTransportOut("fix").getSender();
        MessageContext msgCtx = trpSender.createResponseMessageContext(outMsgCtx);
        try {
            FIXUtils.getInstance().setSOAPEnvelope(message, counter, sessionID.toString(), msgCtx);
            msgCtx.setServerSide(true);
            trpSender.handleIncomingMessage(msgCtx, FIXUtils.getTransportHeaders(this.service.getName(), "initiator"), null, "text/xml");
        }
        catch (AxisFault e) {
            this.handleException("Error while processing response FIX message", (Exception)((Object)e));
        }
    }

    class FIXWorkerThread
    implements Runnable {
        private Message message;
        private SessionID sessionID;
        private int counter;

        public FIXWorkerThread(Message message, SessionID sessionID, int counter) {
            this.message = message;
            this.sessionID = sessionID;
            this.counter = counter;
        }

        @Override
        public void run() {
            FIXIncomingMessageHandler.this.processMessage(this.message, this.sessionID, this.counter);
        }
    }
}

