/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.clustering.MembershipScheme;
import org.apache.axis2.clustering.control.wka.JoinGroupCommand;
import org.apache.axis2.clustering.control.wka.MemberListCommand;
import org.apache.axis2.clustering.control.wka.RpcMembershipRequestHandler;
import org.apache.axis2.clustering.tribes.AtMostOnceInterceptor;
import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.axis2.clustering.tribes.OperationMode;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.axis2.clustering.tribes.WkaMembershipService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.Utils;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ManagedChannel;
import org.apache.catalina.tribes.MembershipService;
import org.apache.catalina.tribes.group.Response;
import org.apache.catalina.tribes.group.RpcCallback;
import org.apache.catalina.tribes.group.RpcChannel;
import org.apache.catalina.tribes.group.interceptors.OrderInterceptor;
import org.apache.catalina.tribes.group.interceptors.StaticMembershipInterceptor;
import org.apache.catalina.tribes.group.interceptors.TcpFailureDetector;
import org.apache.catalina.tribes.group.interceptors.TcpPingInterceptor;
import org.apache.catalina.tribes.membership.StaticMember;
import org.apache.catalina.tribes.transport.ReceiverBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WkaBasedMembershipScheme
implements MembershipScheme {
    private static final Log log = LogFactory.getLog(WkaBasedMembershipScheme.class);
    private final ManagedChannel channel;
    private final MembershipManager primaryMembershipManager;
    private final List<MembershipManager> applicationDomainMembershipManagers;
    private StaticMembershipInterceptor staticMembershipInterceptor;
    private final Map<String, Parameter> parameters;
    private final byte[] localDomain;
    private final List<Member> members;
    private final OperationMode mode;
    private final boolean atmostOnceMessageSemantics;
    private final boolean preserverMsgOrder;

    public WkaBasedMembershipScheme(ManagedChannel channel, OperationMode mode, List<MembershipManager> applicationDomainMembershipManagers, MembershipManager primaryMembershipManager, Map<String, Parameter> parameters, byte[] domain, List<Member> members, boolean atmostOnceMessageSemantics, boolean preserverMsgOrder) {
        this.channel = channel;
        this.mode = mode;
        this.applicationDomainMembershipManagers = applicationDomainMembershipManagers;
        this.primaryMembershipManager = primaryMembershipManager;
        this.parameters = parameters;
        this.localDomain = domain;
        this.members = members;
        this.atmostOnceMessageSemantics = atmostOnceMessageSemantics;
        this.preserverMsgOrder = preserverMsgOrder;
    }

    @Override
    public void init() throws ClusteringFault {
        this.addInterceptors();
        this.configureStaticMembership();
    }

    private void configureStaticMembership() throws ClusteringFault {
        int port;
        String host;
        this.channel.setMembershipService((MembershipService)new WkaMembershipService(this.primaryMembershipManager));
        StaticMember localMember = new StaticMember();
        this.primaryMembershipManager.setLocalMember((org.apache.catalina.tribes.Member)localMember);
        ReceiverBase receiver = (ReceiverBase)this.channel.getChannelReceiver();
        Parameter localHost = this.getParameter("localMemberHost");
        if (localHost != null) {
            host = ((String)localHost.getValue()).trim();
        } else {
            try {
                try {
                    host = Utils.getIpAddress();
                }
                catch (SocketException e) {
                    String msg = "Could not get local IP address";
                    log.error((Object)msg, (Throwable)e);
                    throw new ClusteringFault(msg, (Exception)e);
                }
            }
            catch (Exception e) {
                String msg = "Could not get the localhost name";
                log.error((Object)msg, (Throwable)e);
                throw new ClusteringFault(msg, e);
            }
        }
        receiver.setAddress(host);
        try {
            localMember.setHostname(host);
        }
        catch (IOException e) {
            String msg = "Could not set the local member's name";
            log.error((Object)msg, (Throwable)e);
            throw new ClusteringFault(msg, (Exception)e);
        }
        Parameter localPort = this.getParameter("localMemberPort");
        try {
            if (localPort != null) {
                port = Integer.parseInt(((String)localPort.getValue()).trim());
                port = this.getLocalPort(new ServerSocket(), localMember.getHostname(), port, 4000, 1000);
            } else {
                port = this.getLocalPort(new ServerSocket(), localMember.getHostname(), -1, 4000, 1000);
            }
        }
        catch (IOException e) {
            String msg = "Could not allocate the specified port or a port in the range 4000-5000 for local host " + localMember.getHostname() + ". Check whether the IP address specified or inferred for the local member is correct.";
            log.error((Object)msg, (Throwable)e);
            throw new ClusteringFault(msg, (Exception)e);
        }
        byte[] payload = "ping".getBytes();
        localMember.setPayload(payload);
        receiver.setPort(port);
        localMember.setPort(port);
        localMember.setDomain(this.localDomain);
        this.staticMembershipInterceptor.setLocalMember((org.apache.catalina.tribes.Member)localMember);
        for (Member member : this.members) {
            StaticMember tribesMember;
            try {
                tribesMember = new StaticMember(member.getHostName(), member.getPort(), 0L, payload);
            }
            catch (IOException e) {
                String msg = "Could not add static member " + member.getHostName() + ":" + member.getPort();
                log.error((Object)msg, (Throwable)e);
                throw new ClusteringFault(msg, (Exception)e);
            }
            if (Arrays.equals(localMember.getHost(), tribesMember.getHost()) && localMember.getPort() == tribesMember.getPort()) continue;
            tribesMember.setDomain(this.localDomain);
            this.staticMembershipInterceptor.addStaticMember((org.apache.catalina.tribes.Member)tribesMember);
            this.primaryMembershipManager.addWellKnownMember((org.apache.catalina.tribes.Member)tribesMember);
            if (this.canConnect(member)) {
                this.primaryMembershipManager.memberAdded((org.apache.catalina.tribes.Member)tribesMember);
                log.info((Object)("Added static member " + TribesUtil.getName((org.apache.catalina.tribes.Member)tribesMember)));
                continue;
            }
            log.info((Object)("Could not connect to member " + TribesUtil.getName((org.apache.catalina.tribes.Member)tribesMember)));
        }
    }

    private boolean canConnect(Member member) {
        for (int retries = 5; retries > 0; --retries) {
            try {
                InetAddress addr = InetAddress.getByName(member.getHostName());
                InetSocketAddress sockaddr = new InetSocketAddress(addr, member.getPort());
                new Socket().connect(sockaddr, 500);
                return true;
            }
            catch (IOException e) {
                String msg = e.getMessage();
                if (msg.contains("Connection refused") || msg.contains("connect timed out")) continue;
                log.error((Object)("Cannot connect to member " + member.getHostName() + ":" + member.getPort()), (Throwable)e);
                continue;
            }
        }
        return false;
    }

    protected int getLocalPort(ServerSocket socket, String hostname, int preferredPort, int portstart, int retries) throws IOException {
        if (preferredPort != -1) {
            try {
                return this.getLocalPort(socket, hostname, preferredPort);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Object addr = null;
        if (retries > 0) {
            try {
                return this.getLocalPort(socket, hostname, portstart);
            }
            catch (IOException x) {
                if (--retries <= 0) {
                    log.error((Object)("Unable to bind server socket to:" + addr + " throwing error."));
                    throw x;
                }
                ++portstart;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ignored) {
                    ignored.printStackTrace();
                }
                portstart = this.getLocalPort(socket, hostname, portstart, retries, -1);
            }
        }
        return portstart;
    }

    private int getLocalPort(ServerSocket socket, String hostname, int port) throws IOException {
        InetSocketAddress addr = new InetSocketAddress(hostname, port);
        socket.bind(addr);
        log.info((Object)("Receiver Server Socket bound to:" + addr));
        socket.setSoTimeout(5);
        socket.close();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ignored) {
            ignored.printStackTrace();
        }
        return port;
    }

    private void addInterceptors() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding Interceptors...");
        }
        TcpPingInterceptor tcpPingInterceptor = new TcpPingInterceptor();
        tcpPingInterceptor.setInterval(10000L);
        this.channel.addInterceptor((ChannelInterceptor)tcpPingInterceptor);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Added TCP Ping Interceptor");
        }
        TcpFailureDetector tcpFailureDetector = new TcpFailureDetector();
        tcpFailureDetector.setReadTestTimeout(120000L);
        tcpFailureDetector.setConnectTimeout(180000L);
        this.channel.addInterceptor((ChannelInterceptor)tcpFailureDetector);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Added TCP Failure Detector");
        }
        this.staticMembershipInterceptor = new StaticMembershipInterceptor();
        this.staticMembershipInterceptor.setLocalMember(this.primaryMembershipManager.getLocalMember());
        this.primaryMembershipManager.setupStaticMembershipManagement(this.staticMembershipInterceptor);
        this.channel.addInterceptor((ChannelInterceptor)this.staticMembershipInterceptor);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Added Static Membership Interceptor");
        }
        this.channel.getMembershipService().setDomain(this.localDomain);
        this.mode.addInterceptors((Channel)this.channel);
        if (this.atmostOnceMessageSemantics) {
            AtMostOnceInterceptor atMostOnceInterceptor = new AtMostOnceInterceptor();
            atMostOnceInterceptor.setOptionFlag(2048);
            this.channel.addInterceptor((ChannelInterceptor)atMostOnceInterceptor);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Added At-most-once Interceptor");
            }
        }
        if (this.preserverMsgOrder) {
            OrderInterceptor orderInterceptor = new OrderInterceptor();
            orderInterceptor.setOptionFlag(512);
            this.channel.addInterceptor((ChannelInterceptor)orderInterceptor);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Added Message Order Interceptor");
            }
        }
    }

    @Override
    public void joinGroup() throws ClusteringFault {
        for (MembershipManager appDomainMembershipManager : this.applicationDomainMembershipManagers) {
            appDomainMembershipManager.setupStaticMembershipManagement(this.staticMembershipInterceptor);
            String domain = new String(appDomainMembershipManager.getDomain());
            RpcChannel rpcMembershipChannel2 = new RpcChannel(TribesUtil.getRpcMembershipChannelId(appDomainMembershipManager.getDomain()), (Channel)this.channel, (RpcCallback)new RpcMembershipRequestHandler(appDomainMembershipManager, this));
            appDomainMembershipManager.setRpcMembershipChannel(rpcMembershipChannel2);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Created RPC Membership Channel for application domain " + domain));
        }
        RpcChannel rpcMembershipChannel = new RpcChannel(TribesUtil.getRpcMembershipChannelId(this.localDomain), (Channel)this.channel, (RpcCallback)new RpcMembershipRequestHandler(this.primaryMembershipManager, this));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created primary membership channel " + new String(this.localDomain)));
        }
        this.primaryMembershipManager.setRpcMembershipChannel(rpcMembershipChannel);
        if (this.primaryMembershipManager.getMembers().length > 0) {
            org.apache.catalina.tribes.Member[] wkaMembers = this.primaryMembershipManager.getMembers();
            Response[] responses = null;
            do {
                try {
                    log.info((Object)"Sending JOIN message to WKA members...");
                    responses = rpcMembershipChannel.send(wkaMembers, (Serializable)((Object)new JoinGroupCommand()), 3, 1032, 10000L);
                    if (responses.length != 0) continue;
                    try {
                        log.info((Object)"No responses received from WKA members");
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException rpcMembershipChannel2) {}
                }
                catch (Exception e) {
                    String msg = "Error occurred while trying to send JOIN request to WKA members";
                    log.error((Object)msg, (Throwable)e);
                    wkaMembers = this.primaryMembershipManager.getMembers();
                    if (wkaMembers.length != 0) continue;
                    log.warn((Object)"There are no well-known members");
                    break;
                }
            } while (responses == null || responses.length == 0);
            for (Response response : responses) {
                MemberListCommand command = (MemberListCommand)((Object)response.getMessage());
                command.setMembershipManager(this.primaryMembershipManager);
                command.execute(null);
                if (TribesUtil.areInSameDomain(response.getSource(), this.primaryMembershipManager.getLocalMember())) continue;
                this.primaryMembershipManager.memberDisappeared(response.getSource());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Removed member " + TribesUtil.getName(response.getSource()) + " since it does not belong to the local domain " + new String(this.primaryMembershipManager.getLocalMember().getDomain())));
            }
        }
    }

    public void processJoin(org.apache.catalina.tribes.Member member) {
        this.mode.notifyMemberJoin(member);
    }

    public Parameter getParameter(String name) {
        return this.parameters.get(name);
    }
}

