/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.sslcert.pathvalidation;

import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.utils.sslcert.CertificateVerificationException;
import org.apache.synapse.transport.utils.sslcert.RevocationStatus;
import org.apache.synapse.transport.utils.sslcert.RevocationVerifier;

public class PathChecker
extends PKIXCertPathChecker {
    private X509Certificate[] certChainArray;
    private RevocationVerifier verifier;
    private int position;
    private static final Log log = LogFactory.getLog(PathChecker.class);

    protected PathChecker(X509Certificate[] certChainArray, RevocationVerifier verifier) {
        this.certChainArray = certChainArray;
        this.position = certChainArray.length - 1;
        this.verifier = verifier;
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("Forward checking is not supported");
        }
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        try {
            RevocationStatus status = this.verifier.checkRevocationStatus((X509Certificate)cert, this.nextIssuer());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Certificate status is: " + status.getMessage()));
            }
            if (status != RevocationStatus.GOOD) {
                throw new CertPathValidatorException("Revocation Status is Not Good");
            }
        }
        catch (CertificateVerificationException e) {
            throw new CertPathValidatorException(e);
        }
    }

    private X509Certificate nextIssuer() {
        if (this.position > 0) {
            return this.certChainArray[this.position--];
        }
        throw new ArrayIndexOutOfBoundsException("Certificate Chain Index Out of Bounds");
    }
}

