/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.servlet;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tiles.request.AbstractClientRequest;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.attribute.Addable;
import org.apache.tiles.request.collection.HeaderValuesMap;
import org.apache.tiles.request.collection.ReadOnlyEnumerationMap;
import org.apache.tiles.request.collection.ScopeMap;
import org.apache.tiles.request.servlet.ServletUtil;
import org.apache.tiles.request.servlet.extractor.HeaderExtractor;
import org.apache.tiles.request.servlet.extractor.ParameterExtractor;
import org.apache.tiles.request.servlet.extractor.RequestScopeExtractor;
import org.apache.tiles.request.servlet.extractor.SessionScopeExtractor;

public class ServletRequest
extends AbstractClientRequest {
    private static final List<String> SCOPES = Collections.unmodifiableList(Arrays.asList("request", "session", "application"));
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private OutputStream outputStream;
    private PrintWriter writer;
    private Map<String, String> header = null;
    private Addable<String> responseHeaders = null;
    private Map<String, String[]> headerValues = null;
    private Map<String, String> param = null;
    private Map<String, Object> requestScope = null;
    private Map<String, Object> sessionScope = null;

    public ServletRequest(ApplicationContext applicationContext, HttpServletRequest request, HttpServletResponse response) {
        super(applicationContext);
        this.request = request;
        this.response = response;
    }

    @Override
    public Map<String, String> getHeader() {
        if (this.header == null && this.request != null) {
            this.header = new ReadOnlyEnumerationMap<String>(new HeaderExtractor(this.request, null));
        }
        return this.header;
    }

    @Override
    public Addable<String> getResponseHeaders() {
        if (this.responseHeaders == null && this.response != null) {
            this.responseHeaders = new HeaderExtractor(null, this.response);
        }
        return this.responseHeaders;
    }

    @Override
    public Map<String, String[]> getHeaderValues() {
        if (this.headerValues == null && this.request != null) {
            this.headerValues = new HeaderValuesMap(new HeaderExtractor(this.request, this.response));
        }
        return this.headerValues;
    }

    @Override
    public Map<String, String> getParam() {
        if (this.param == null && this.request != null) {
            this.param = new ReadOnlyEnumerationMap<String>(new ParameterExtractor(this.request));
        }
        return this.param;
    }

    @Override
    public Map<String, String[]> getParamValues() {
        return this.request.getParameterMap();
    }

    @Override
    public Map<String, Object> getContext(String scope) {
        if ("request".equals(scope)) {
            return this.getRequestScope();
        }
        if ("session".equals(scope)) {
            return this.getSessionScope();
        }
        if ("application".equals(scope)) {
            return this.getApplicationScope();
        }
        throw new IllegalArgumentException(scope + " does not exist. Call getAvailableScopes() first to check.");
    }

    public Map<String, Object> getRequestScope() {
        if (this.requestScope == null && this.request != null) {
            this.requestScope = new ScopeMap(new RequestScopeExtractor(this.request));
        }
        return this.requestScope;
    }

    public Map<String, Object> getSessionScope() {
        if (this.sessionScope == null && this.request != null) {
            this.sessionScope = new ScopeMap(new SessionScopeExtractor(this.request));
        }
        return this.sessionScope;
    }

    @Override
    public List<String> getAvailableScopes() {
        return SCOPES;
    }

    @Override
    public void doForward(String path) throws IOException {
        if (this.response.isCommitted()) {
            this.doInclude(path);
        } else {
            this.forward(path);
        }
    }

    @Override
    public void doInclude(String path) throws IOException {
        RequestDispatcher rd = this.request.getRequestDispatcher(path);
        if (rd == null) {
            throw new IOException("No request dispatcher returned for path '" + path + "'");
        }
        try {
            rd.include((jakarta.servlet.ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException ex) {
            throw ServletUtil.wrapServletException(ex, "ServletException including path '" + path + "'.");
        }
    }

    private void forward(String path) throws IOException {
        RequestDispatcher rd = this.request.getRequestDispatcher(path);
        if (rd == null) {
            throw new IOException("No request dispatcher returned for path '" + path + "'");
        }
        try {
            rd.forward((jakarta.servlet.ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException ex) {
            throw ServletUtil.wrapServletException(ex, "ServletException including path '" + path + "'.");
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = this.response.getOutputStream();
        }
        return this.outputStream;
    }

    @Override
    public Writer getWriter() throws IOException {
        return this.getPrintWriter();
    }

    @Override
    public PrintWriter getPrintWriter() throws IOException {
        if (this.writer == null) {
            this.writer = this.response.getWriter();
        }
        return this.writer;
    }

    @Override
    public boolean isResponseCommitted() {
        return this.response.isCommitted();
    }

    @Override
    public void setContentType(String contentType) {
        this.response.setContentType(contentType);
    }

    @Override
    public Locale getRequestLocale() {
        return this.request.getLocale();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }
}

