/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sling.xss.impl.AntiSamyPolicyAdapter;
import org.apache.sling.xss.impl.SanitizedResult;
import org.apache.sling.xss.impl.xml.AntiSamyPolicy;
import org.owasp.html.DynamicAttributesSanitizerPolicy;
import org.owasp.html.Handler;
import org.owasp.html.HtmlStreamRenderer;
import org.owasp.html.PolicyFactory;

public class HtmlSanitizer {
    private AntiSamyPolicyAdapter customPolicy;
    private Map policies;
    private Set<String> textContainers;

    public HtmlSanitizer(AntiSamyPolicy policy) {
        this.customPolicy = new AntiSamyPolicyAdapter(policy);
        this.policies = this.reflectionGetPolicies(this.customPolicy.getHtmlCleanerPolicyFactory());
        this.textContainers = this.reflectionGetTextContainers(this.customPolicy.getHtmlCleanerPolicyFactory());
    }

    public SanitizedResult scan(String taintedHTML) {
        StringBuilder sb = new StringBuilder(taintedHTML.length());
        HtmlStreamRenderer out = HtmlStreamRenderer.create(sb, Handler.DO_NOTHING);
        DynamicAttributesSanitizerPolicy dynamicPolicy = new DynamicAttributesSanitizerPolicy(out, this.policies, this.textContainers, this.customPolicy.getDynamicAttributesPolicyMap(), this.customPolicy.getOnInvalidRemoveTagList());
        org.owasp.html.HtmlSanitizer.sanitize(taintedHTML, dynamicPolicy, this.customPolicy.getCssValidator().newStyleTagProcessor());
        return new SanitizedResult(sb.toString(), dynamicPolicy.getNumberOfErrors());
    }

    private Set<String> reflectionGetTextContainers(PolicyFactory policyFactory) {
        Class<?> c = policyFactory.getClass();
        try {
            Field field = c.getDeclaredField("textContainers");
            field.setAccessible(true);
            return (Set)field.get(policyFactory);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private Map reflectionGetPolicies(PolicyFactory policyFactory) {
        Class<?> c = policyFactory.getClass();
        try {
            Field field = c.getDeclaredField("policies");
            field.setAccessible(true);
            return (Map)field.get(policyFactory);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public SanitizedResult scan(String taintedHTML, AntiSamyPolicy policy) {
        Objects.requireNonNull(taintedHTML, "Null html input");
        Objects.requireNonNull(policy, "Null policy loaded");
        return new HtmlSanitizer(policy).scan(taintedHTML);
    }
}

