/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails.internal.providers;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.JEditorPane;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.thumbnails.OutputFileFormat;
import org.apache.sling.thumbnails.extension.ThumbnailProvider;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.WriteOutContentHandler;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@Component(service={ThumbnailProvider.class}, property={"service.ranking=-2147483648"}, immediate=true)
public class TikaFallbackProvider
implements ThumbnailProvider {
    private static final Logger log = LoggerFactory.getLogger(TikaFallbackProvider.class);

    @Override
    public boolean applies(Resource resource, String metaType) {
        return true;
    }

    @Override
    public InputStream getThumbnail(Resource resource) throws IOException {
        log.info("Extracting content thumbnail from {}", (Object)resource.getPath());
        try {
            log.debug("Extracting file contents");
            String contents = this.extractContents(resource);
            log.debug("Creating thumbnail of file contents");
            int width = 500;
            int height = 500;
            BufferedImage image = new BufferedImage(width, height, 2);
            Graphics2D graphics = image.createGraphics();
            JEditorPane jep = new JEditorPane("text/html", contents);
            jep.setSize(width, height);
            jep.print(graphics);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, OutputFileFormat.PNG.toString(), baos);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (TikaException | SAXException e) {
            throw new IOException("Failed to generate thumbnail from " + resource.getPath(), e);
        }
    }

    private String extractContents(Resource resource) throws IOException, TikaException, SAXException {
        InputStream is = (InputStream)resource.adaptTo(InputStream.class);
        AutoDetectParser parser = new AutoDetectParser();
        WriteOutContentHandler woHandler = new WriteOutContentHandler();
        BodyContentHandler bHandler = new BodyContentHandler((ContentHandler)woHandler);
        Metadata md = new Metadata();
        ParseContext context = new ParseContext();
        try {
            parser.parse(is, (ContentHandler)bHandler, md, context);
        }
        catch (SAXException se) {
            if (woHandler.isWriteLimitReached((Throwable)se)) {
                log.debug("Reached write limit for preview generation");
            }
            throw se;
        }
        return bHandler.toString();
    }
}

