/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.OrderingImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;

public class CoalesceImpl
extends DynamicOperandImpl {
    private final DynamicOperandImpl operand1;
    private final DynamicOperandImpl operand2;

    public CoalesceImpl(DynamicOperandImpl operand1, DynamicOperandImpl operand2) {
        this.operand1 = operand1;
        this.operand2 = operand2;
    }

    public DynamicOperandImpl getOperand1() {
        return this.operand1;
    }

    public DynamicOperandImpl getOperand2() {
        return this.operand2;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return "coalesce(" + String.valueOf(this.operand1) + ", " + String.valueOf(this.operand2) + ")";
    }

    @Override
    public PropertyExistenceImpl getPropertyExistence() {
        return null;
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return SetUtils.union(this.operand1.getSelectors(), this.operand2.getSelectors());
    }

    @Override
    public PropertyValue currentProperty() {
        PropertyValue p = this.operand1.currentProperty();
        return p != null ? p : this.operand2.currentProperty();
    }

    @Override
    public void restrict(FilterImpl f, Operator operator, PropertyValue v) {
        if (operator == Operator.NOT_EQUAL && v != null) {
            return;
        }
        String fn = this.getFunction(f.getSelector());
        if (fn != null) {
            f.restrictProperty("function*" + fn, operator, v, 1);
        }
    }

    @Override
    public void restrictList(FilterImpl f, List<PropertyValue> list) {
        String fn = this.getFunction(f.getSelector());
        f.restrictPropertyAsList("function*" + fn, list);
    }

    @Override
    public String getFunction(SelectorImpl s) {
        String f1 = this.operand1.getFunction(s);
        if (f1 == null) {
            return null;
        }
        String f2 = this.operand2.getFunction(s);
        if (f2 == null) {
            return null;
        }
        return "coalesce*" + f1 + "*" + f2;
    }

    @Override
    public boolean canRestrictSelector(SelectorImpl s) {
        return this.operand1.canRestrictSelector(s) && this.operand2.canRestrictSelector(s);
    }

    @Override
    int getPropertyType() {
        return 1;
    }

    @Override
    public DynamicOperandImpl createCopy() {
        return new CoalesceImpl(this.operand1.createCopy(), this.operand2.createCopy());
    }

    @Override
    public QueryIndex.OrderEntry getOrderEntry(SelectorImpl s, OrderingImpl o) {
        String fn = this.getFunction(s);
        if (fn != null) {
            return new QueryIndex.OrderEntry("function*" + fn, Type.STRING, o.isDescending() ? QueryIndex.OrderEntry.Order.DESCENDING : QueryIndex.OrderEntry.Order.ASCENDING);
        }
        return null;
    }
}

