/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sample.slingshot.impl;

import java.io.IOException;
import java.util.HashMap;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class SetupService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private ResourceResolverFactory factory;
    private static final String[] USERS = new String[]{"slingshot1", "slingshot2"};
    private static final String[] FOLDERS = new String[]{"info", "settings", "ugc"};

    @Activate
    protected void activate(BundleContext bc) throws IOException, LoginException, PersistenceException, RepositoryException {
        this.logger.info("Setting up SlingShot...");
        try (ResourceResolver resolver = null;){
            resolver = this.factory.getServiceResourceResolver(null);
            this.setupContent(resolver);
        }
        this.logger.info("Finished setting up SlingShot");
    }

    private void setupContent(ResourceResolver resolver) throws PersistenceException {
        Resource root = resolver.getResource("/content/slingshot");
        if (root != null) {
            if (!root.isResourceType("slingshot/Home")) {
                ModifiableValueMap mvm = (ModifiableValueMap)root.adaptTo(ModifiableValueMap.class);
                mvm.put((Object)"sling:resourceType", (Object)"slingshot/Home");
                resolver.commit();
            }
            Resource usersResource = root.getChild("users");
            for (String userName : USERS) {
                Resource homeResource = resolver.getResource(usersResource, userName);
                if (homeResource == null) {
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("sling:resourceType", "slingshot/User");
                    homeResource = resolver.create(usersResource, userName, props);
                    resolver.commit();
                }
                for (String def : FOLDERS) {
                    String rt;
                    String name;
                    int index = def.indexOf(58);
                    if (index == -1) {
                        name = def;
                        rt = "sling:OrderedFolder";
                    } else {
                        name = def.substring(0, index);
                        rt = def.substring(index + 1);
                    }
                    Resource rsrc = resolver.getResource(homeResource, name);
                    if (rsrc != null) continue;
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("sling:resourceType", rt);
                    resolver.create(homeResource, name, props);
                    resolver.commit();
                }
            }
        }
    }
}

