/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceaccesssecurity.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.resourceaccesssecurity.ResourceAccessGate;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.ServiceReference;

public class ResourceAccessGateHandler {
    @NotNull
    private final ResourceAccessGate resourceAccessGate;
    @NotNull
    private final ServiceReference<ResourceAccessGate> reference;
    @NotNull
    private final Pattern pathPattern;
    private final Set<ResourceAccessGate.Operation> operations = new HashSet<ResourceAccessGate.Operation>();
    private final Set<ResourceAccessGate.Operation> finalOperations = new HashSet<ResourceAccessGate.Operation>();

    public ResourceAccessGateHandler(@NotNull ServiceReference<ResourceAccessGate> resourceAccessGateRef, @NotNull ResourceAccessGate resourceAccessGate) {
        this.reference = resourceAccessGateRef;
        this.resourceAccessGate = resourceAccessGate;
        String path = (String)resourceAccessGateRef.getProperty("path");
        this.pathPattern = path != null ? Pattern.compile(path) : Pattern.compile(".*");
        String[] ops = PropertiesUtil.toStringArray((Object)resourceAccessGateRef.getProperty("operations"));
        if (ops != null && ops.length > 0) {
            for (String opAsString : ops) {
                ResourceAccessGate.Operation operation = ResourceAccessGate.Operation.fromString(opAsString);
                if (operation == null) continue;
                this.operations.add(operation);
            }
        } else {
            Collections.addAll(this.operations, ResourceAccessGate.Operation.values());
        }
        String[] finalOps = PropertiesUtil.toStringArray((Object)resourceAccessGateRef.getProperty("finaloperations"));
        if (finalOps != null) {
            for (String opAsString : finalOps) {
                ResourceAccessGate.Operation operation = ResourceAccessGate.Operation.fromString(opAsString);
                if (operation == null) continue;
                this.finalOperations.add(operation);
            }
        }
    }

    public boolean matches(String path, ResourceAccessGate.Operation operation) {
        boolean returnValue = false;
        if (this.operations.contains((Object)operation)) {
            if (path != null) {
                Matcher match = this.pathPattern.matcher(path);
                returnValue = match.matches();
            } else {
                return true;
            }
        }
        return returnValue;
    }

    public boolean isFinalOperation(ResourceAccessGate.Operation operation) {
        return this.finalOperations.contains((Object)operation);
    }

    @NotNull
    public ResourceAccessGate getResourceAccessGate() {
        return this.resourceAccessGate;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceAccessGateHandler) {
            return ((ResourceAccessGateHandler)obj).reference.equals(this.reference);
        }
        return false;
    }

    public int hashCode() {
        return this.reference.hashCode();
    }
}

