/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resource.inventory.impl;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.LoggerFactory;

public abstract class JsonObjectCreator {
    private static final String ECMA_DATE_FORMAT = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z";
    private static final Locale DATE_FORMAT_LOCALE = Locale.US;
    private static final DateFormat CALENDAR_FORMAT = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss 'GMT'Z", DATE_FORMAT_LOCALE);

    public static JsonObjectBuilder create(Resource resource) {
        ValueMap valueMap = (ValueMap)resource.adaptTo(ValueMap.class);
        ValueMap propertyMap = valueMap != null ? valueMap : (Map)resource.adaptTo(Map.class);
        JsonObjectBuilder obj = Json.createObjectBuilder();
        if (propertyMap == null) {
            String value = (String)resource.adaptTo(String.class);
            if (value != null) {
                obj.add(resource.getName(), value);
            } else {
                String[] values = (String[])resource.adaptTo(String[].class);
                if (values != null) {
                    JsonArrayBuilder array = Json.createArrayBuilder();
                    for (String v : values) {
                        array.add(v);
                    }
                    obj.add(resource.getName(), array);
                }
            }
            if (resource.getResourceType() != null) {
                obj.add("sling:resourceType", resource.getResourceType());
            }
            if (resource.getResourceSuperType() != null) {
                obj.add("sling:resourceSuperType", resource.getResourceSuperType());
            }
        } else {
            for (Map.Entry prop : propertyMap.entrySet()) {
                if (prop.getValue() == null) continue;
                JsonObjectCreator.createProperty(obj, valueMap, prop.getKey().toString(), prop.getValue());
            }
        }
        Iterator children = resource.listChildren();
        while (children.hasNext()) {
            Resource n = (Resource)children.next();
            JsonObjectCreator.createSingleResource(n, obj);
        }
        return obj;
    }

    private static synchronized String format(Calendar date) {
        return CALENDAR_FORMAT.format(date.getTime());
    }

    private static JsonValue getValue(Object value) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        if (value instanceof InputStream) {
            builder.add("key", 0);
        } else if (value instanceof Calendar) {
            builder.add("key", JsonObjectCreator.format((Calendar)value));
        } else if (value instanceof Boolean) {
            builder.add("key", ((Boolean)value).booleanValue());
        } else if (value instanceof Long) {
            builder.add("key", ((Long)value).longValue());
        } else if (value instanceof Integer) {
            builder.add("key", ((Integer)value).intValue());
        } else if (value != null) {
            builder.add("key", value.toString());
        } else {
            builder.add("key", "");
        }
        return (JsonValue)builder.build().get((Object)"key");
    }

    private static void createSingleResource(Resource n, JsonObjectBuilder parent) {
        parent.add(n.getName(), JsonObjectCreator.create(n));
    }

    private static void createProperty(JsonObjectBuilder obj, ValueMap valueMap, String key, Object value) {
        Object[] values = null;
        if (value.getClass().isArray() && (values = value instanceof long[] ? ArrayUtils.toObject((long[])((long[])value)) : (value instanceof int[] ? ArrayUtils.toObject((int[])((int[])value)) : (value instanceof double[] ? ArrayUtils.toObject((double[])((double[])value)) : (value instanceof byte[] ? ArrayUtils.toObject((byte[])((byte[])value)) : (value instanceof float[] ? ArrayUtils.toObject((float[])((float[])value)) : (value instanceof short[] ? ArrayUtils.toObject((short[])((short[])value)) : (value instanceof long[] ? ArrayUtils.toObject((long[])((long[])value)) : (value instanceof boolean[] ? ArrayUtils.toObject((boolean[])((boolean[])value)) : (value instanceof char[] ? ArrayUtils.toObject((char[])((char[])value)) : (Object[])value))))))))).length == 0) {
            obj.add(key, Json.createArrayBuilder());
            return;
        }
        if (value instanceof InputStream || values != null && values[0] instanceof InputStream) {
            try {
                if (values == null) {
                    obj.add(":" + key, JsonObjectCreator.getLength(valueMap, -1, key, (InputStream)value));
                } else {
                    JsonArrayBuilder result = Json.createArrayBuilder();
                    for (int i = 0; i < values.length; ++i) {
                        result.add(JsonObjectCreator.getLength(valueMap, i, key, (InputStream)((Object)values[i])));
                    }
                    obj.add(":" + key, result);
                }
            }
            catch (JsonException ignore) {
                LoggerFactory.getLogger(JsonObjectCreator.class).warn("Unable to create JSON value", (Throwable)ignore);
            }
            return;
        }
        try {
            if (!value.getClass().isArray()) {
                obj.add(key, JsonObjectCreator.getValue(value));
            } else {
                JsonArrayBuilder result = Json.createArrayBuilder();
                for (Number number : values) {
                    result.add(JsonObjectCreator.getValue(number));
                }
                obj.add(key, result);
            }
        }
        catch (JsonException ignore) {
            LoggerFactory.getLogger(JsonObjectCreator.class).warn("Unable to create JSON value", (Throwable)ignore);
        }
    }

    private static long getLength(ValueMap valueMap, int index, String key, InputStream stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        long length = -1L;
        if (valueMap != null) {
            if (index == -1) {
                length = (Long)valueMap.get(key, (Object)length);
            } else {
                Long[] lengths = (Long[])valueMap.get(key, Long[].class);
                if (lengths != null && lengths.length > index) {
                    length = lengths[index];
                }
            }
        }
        return length;
    }
}

