/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.internal.Scope;
import org.apache.commons.jexl3.parser.ASTAmbiguous;
import org.apache.commons.jexl3.parser.ASTAssignment;
import org.apache.commons.jexl3.parser.ASTIdentifier;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.apache.commons.jexl3.parser.ASTVar;
import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.ParseException;
import org.apache.commons.jexl3.parser.StringParser;
import org.apache.commons.jexl3.parser.Token;

public abstract class JexlParser
extends StringParser {
    boolean ALLOW_REGISTERS = false;
    String source = null;
    Scope frame = null;
    Stack<Scope> frames = new Stack();
    Map<String, Object> pragmas = null;

    public void allowRegisters(boolean registers) {
        this.ALLOW_REGISTERS = registers;
    }

    public void setFrame(Scope theFrame) {
        this.frame = theFrame;
    }

    public Scope getFrame() {
        return this.frame;
    }

    public void pushFrame() {
        if (this.frame != null) {
            this.frames.push(this.frame);
        }
        this.frame = new Scope(this.frame, null);
    }

    public void popFrame() {
        this.frame = !this.frames.isEmpty() ? this.frames.pop() : null;
    }

    public String checkVariable(ASTIdentifier identifier, String image) {
        Integer register;
        if (this.frame != null && (register = this.frame.getSymbol(image)) != null) {
            identifier.setSymbol(register, image);
        }
        return image;
    }

    public void declareVariable(ASTVar identifier, String image) {
        if (this.frame == null) {
            this.frame = new Scope(null, null);
        }
        Integer register = this.frame.declareVariable(image);
        identifier.setSymbol(register, image);
    }

    public void declarePragma(String key, Object value) {
        if (this.pragmas == null) {
            this.pragmas = new TreeMap<String, Object>();
        }
        this.pragmas.put(key, value);
    }

    public void declareParameter(String identifier) {
        if (this.frame == null) {
            this.frame = new Scope(null, null);
        }
        this.frame.declareParameter(identifier);
    }

    public void Identifier(boolean top) throws ParseException {
    }

    public final void Identifier() throws ParseException {
        this.Identifier(false);
    }

    public Token getToken(int index) {
        return null;
    }

    void jjtreeOpenNodeScope(JexlNode node) {
    }

    void jjtreeCloseNodeScope(JexlNode node) throws ParseException {
        JexlNode lv;
        if (node instanceof ASTJexlScript) {
            ASTJexlScript script = (ASTJexlScript)node;
            if (script.getScope() != this.frame) {
                script.setScope(this.frame);
            }
            this.popFrame();
        } else if (node instanceof ASTAmbiguous) {
            this.throwParsingException(JexlException.Ambiguous.class, node);
        } else if (node instanceof ASTAssignment && !(lv = node.jjtGetChild(0)).isLeftValue()) {
            this.throwParsingException(JexlException.Assignment.class, lv);
        }
    }

    String stringify(List<String> lstr) {
        StringBuilder strb = new StringBuilder();
        boolean dot = false;
        for (String str : lstr) {
            if (!dot) {
                dot = true;
            } else {
                strb.append('.');
            }
            strb.append(str);
        }
        return strb.toString();
    }

    protected void throwParsingException(JexlNode node) {
        this.throwParsingException(null, node);
    }

    private void throwParsingException(Class<? extends JexlException> xclazz, JexlNode node) {
        Token tok = this.getToken(0);
        JexlInfo dbgInfo = tok != null ? new JexlInfo(tok.image, tok.beginLine, tok.beginColumn) : node.jexlInfo();
        String msg = null;
        try {
            if (this.source != null) {
                BufferedReader reader = new BufferedReader(new StringReader(this.source));
                for (int l = 0; l < dbgInfo.getLine(); ++l) {
                    msg = reader.readLine();
                }
            } else {
                msg = "";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (JexlException.Ambiguous.class.equals(xclazz)) {
            throw new JexlException.Ambiguous(dbgInfo, msg);
        }
        if (JexlException.Assignment.class.equals(xclazz)) {
            throw new JexlException.Assignment(dbgInfo, msg);
        }
        throw new JexlException.Parsing(dbgInfo, msg);
    }
}

