/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.m2e.internal;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenProjectUtils {
    private static final String DEFAULT_SERVLET_API_VERSION = "2.5";
    private static final Pattern SERVLET_API_VERSION_MATCHER = Pattern.compile("^(\\d\\.\\d)");
    private static final int MAX_RELATIVE_DEPTH_OF_JCR_ROOT = 4;

    public static Optional<Path> guessJcrRootFolder(MavenProject project) throws IOException {
        return MavenProjectUtils.guessJcrRootFolder(project.getBasedir().toPath());
    }

    static Optional<Path> guessJcrRootFolder(Path baseDir) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<Path> stream = Files.find(baseDir, 4, (a, b) -> a.endsWith("jcr_root"), new FileVisitOption[0]);){
            Optional<Path> jcrRoot = stream.findFirst();
            if (jcrRoot.isPresent()) {
                jcrRoot = Optional.of(baseDir.relativize(jcrRoot.get()));
            }
            return jcrRoot;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String guessServletApiVersion(MavenProject project) {
        for (Dependency dependency : project.getDependencies()) {
            Matcher matcher;
            if (!"servlet-api".equals(dependency.getArtifactId()) && !"javax.servlet-api".equals(dependency.getArtifactId()) || !(matcher = SERVLET_API_VERSION_MATCHER.matcher(dependency.getVersion())).matches()) continue;
            return matcher.group(1);
        }
        return DEFAULT_SERVLET_API_VERSION;
    }

    public static Set<String> getModelDirectoryCandidateLocations(MavenProject mavenProject) {
        Xpp3Dom config;
        Xpp3Dom modelDir;
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add("src/main/provisioning");
        candidates.add("src/test/provisioning");
        Plugin slingstartPlugin = mavenProject.getPlugin("org.apache.sling:slingstart-maven-plugin");
        if (slingstartPlugin != null && slingstartPlugin.getConfiguration() instanceof Xpp3Dom && (modelDir = (config = (Xpp3Dom)slingstartPlugin.getConfiguration()).getChild("modelDirectory")) != null) {
            candidates.add(0, modelDir.getValue());
        }
        return new LinkedHashSet<String>(candidates);
    }

    public static Set<String> getFeatureDirectoryCandidateLocations(MavenProject mavenProject) {
        Xpp3Dom config;
        Xpp3Dom featuresDir;
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add("src/main/features");
        candidates.add("src/test/features");
        Plugin slingFeaturePlugin = mavenProject.getPlugin("org.apache.sling:slingfeature-maven-plugin");
        if (slingFeaturePlugin.getConfiguration() instanceof Xpp3Dom && (featuresDir = (config = (Xpp3Dom)slingFeaturePlugin.getConfiguration()).getChild("features")) != null) {
            candidates.add(0, featuresDir.getValue());
        }
        return new LinkedHashSet<String>(candidates);
    }

    private MavenProjectUtils() {
    }
}

