/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.impl.def;

import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.caconfig.management.ConfigurationManagementSettings;
import org.apache.sling.caconfig.management.impl.PropertiesFilterUtil;
import org.apache.sling.caconfig.resource.impl.util.MapUtil;
import org.apache.sling.caconfig.spi.ConfigurationCollectionPersistData;
import org.apache.sling.caconfig.spi.ConfigurationPersistData;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceAccessDeniedException;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceException;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceStrategy2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ConfigurationPersistenceStrategy2.class})
@Designate(ocd=Config.class)
public class DefaultConfigurationPersistenceStrategy
implements ConfigurationPersistenceStrategy2 {
    @Reference
    private ConfigurationManagementSettings configurationManagementSettings;
    private volatile Config config;
    private static final Logger log = LoggerFactory.getLogger(DefaultConfigurationPersistenceStrategy.class);

    @Activate
    private void activate(ComponentContext componentContext, Config config) {
        this.config = config;
    }

    public Resource getResource(@NotNull Resource resource) {
        if (!this.config.enabled()) {
            return null;
        }
        return resource;
    }

    public Resource getCollectionParentResource(@NotNull Resource resource) {
        if (!this.config.enabled()) {
            return null;
        }
        return resource;
    }

    public Resource getCollectionItemResource(@NotNull Resource resource) {
        if (!this.config.enabled()) {
            return null;
        }
        return resource;
    }

    public String getResourcePath(@NotNull String resourcePath) {
        if (!this.config.enabled()) {
            return null;
        }
        return resourcePath;
    }

    public String getCollectionParentResourcePath(@NotNull String resourcePath) {
        if (!this.config.enabled()) {
            return null;
        }
        return resourcePath;
    }

    public String getCollectionItemResourcePath(@NotNull String resourcePath) {
        if (!this.config.enabled()) {
            return null;
        }
        return resourcePath;
    }

    public String getConfigName(@NotNull String configName, @Nullable String relatedConfigPath) {
        if (!this.config.enabled()) {
            return null;
        }
        return configName;
    }

    public String getCollectionParentConfigName(@NotNull String configName, @Nullable String relatedConfigPath) {
        if (!this.config.enabled()) {
            return null;
        }
        return configName;
    }

    public String getCollectionItemConfigName(@NotNull String configName, @Nullable String relatedConfigPath) {
        if (!this.config.enabled()) {
            return null;
        }
        return configName;
    }

    public boolean persistConfiguration(@NotNull ResourceResolver resourceResolver, @NotNull String configResourcePath, @NotNull ConfigurationPersistData data) {
        if (!this.config.enabled()) {
            return false;
        }
        this.getOrCreateResource(resourceResolver, configResourcePath, data.getProperties());
        this.commit(resourceResolver, configResourcePath);
        return true;
    }

    public boolean persistConfigurationCollection(@NotNull ResourceResolver resourceResolver, @NotNull String configResourceCollectionParentPath, @NotNull ConfigurationCollectionPersistData data) {
        if (!this.config.enabled()) {
            return false;
        }
        Resource configResourceParent = this.getOrCreateResource(resourceResolver, configResourceCollectionParentPath, data.getProperties());
        this.deleteChildrenNotInCollection(configResourceParent, data);
        for (ConfigurationPersistData item : data.getItems()) {
            String path = configResourceParent.getPath() + "/" + item.getCollectionItemName();
            this.getOrCreateResource(resourceResolver, path, item.getProperties());
        }
        this.commit(resourceResolver, configResourceCollectionParentPath);
        return true;
    }

    public boolean deleteConfiguration(@NotNull ResourceResolver resourceResolver, @NotNull String configResourcePath) {
        if (!this.config.enabled()) {
            return false;
        }
        Resource resource = resourceResolver.getResource(configResourcePath);
        if (resource != null) {
            try {
                log.trace("! Delete resource {}", (Object)resource.getPath());
                resourceResolver.delete(resource);
            }
            catch (PersistenceException ex) {
                throw this.convertPersistenceException("Unable to delete configuration at " + configResourcePath, ex);
            }
        }
        this.commit(resourceResolver, configResourcePath);
        return true;
    }

    private Resource getOrCreateResource(ResourceResolver resourceResolver, String path, Map<String, Object> properties) {
        try {
            Resource resource = ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)path, (String)null, (String)null, (boolean)false);
            if (properties != null) {
                this.replaceProperties(resource, properties);
            }
            return resource;
        }
        catch (PersistenceException ex) {
            throw this.convertPersistenceException("Unable to persist configuration to " + path, ex);
        }
    }

    private void deleteChildrenNotInCollection(Resource resource, ConfigurationCollectionPersistData data) {
        ResourceResolver resourceResolver = resource.getResourceResolver();
        HashSet<String> collectionItemNames = new HashSet<String>();
        for (ConfigurationPersistData item : data.getItems()) {
            collectionItemNames.add(item.getCollectionItemName());
        }
        try {
            for (Resource child : resource.getChildren()) {
                if (collectionItemNames.contains(child.getName())) continue;
                log.trace("! Delete resource {}", (Object)child.getPath());
                resourceResolver.delete(child);
            }
        }
        catch (PersistenceException ex) {
            throw this.convertPersistenceException("Unable to remove children from " + resource.getPath(), ex);
        }
    }

    private void replaceProperties(Resource resource, Map<String, Object> properties) {
        ModifiableValueMap modValueMap;
        if (log.isTraceEnabled()) {
            log.trace("! Store properties for resource {}: {}", (Object)resource.getPath(), (Object)MapUtil.traceOutput(properties));
        }
        if ((modValueMap = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class)) == null) {
            throw new ConfigurationPersistenceAccessDeniedException("No write access: Unable to store configuration data to " + resource.getPath() + ".");
        }
        HashSet<String> propertyNamesToRemove = new HashSet<String>(modValueMap.keySet());
        PropertiesFilterUtil.removeIgnoredProperties(propertyNamesToRemove, this.configurationManagementSettings);
        for (String propertyName : propertyNamesToRemove) {
            modValueMap.remove((Object)propertyName);
        }
        modValueMap.putAll(properties);
    }

    private void commit(ResourceResolver resourceResolver, String relatedResourcePath) {
        try {
            resourceResolver.commit();
        }
        catch (PersistenceException ex) {
            throw this.convertPersistenceException("Unable to persist configuration changes to " + relatedResourcePath, ex);
        }
    }

    private ConfigurationPersistenceException convertPersistenceException(String message, PersistenceException ex) {
        if (StringUtils.equals((CharSequence)ex.getCause().getClass().getName(), (CharSequence)"javax.jcr.AccessDeniedException")) {
            return new ConfigurationPersistenceAccessDeniedException("No write access: " + message, (Throwable)ex);
        }
        return new ConfigurationPersistenceException(message, (Throwable)ex);
    }

    @ObjectClassDefinition(name="Apache Sling Context-Aware Configuration Default Resource Persistence Strategy", description="Directly uses configuration resources for storing configuration data.")
    static @interface Config {
        @AttributeDefinition(name="Enabled", description="Enable this configuration resource persistence strategy.")
        public boolean enabled() default true;
    }
}

