/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.saml2.sp;

import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import org.apache.sling.auth.saml2.SAML2RuntimeException;
import org.apache.sling.auth.saml2.sp.JksCredentials;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.x509.BasicX509Credential;

public class KeyPairCredentials
extends JksCredentials {
    private KeyPairCredentials() {
    }

    public static BasicX509Credential getCredential(String jksPath, char[] jksPassword, String certAlias, char[] keysPassword) {
        try {
            KeyStore keyStore = KeyPairCredentials.getKeyStore(jksPath, jksPassword);
            Key key = keyStore.getKey(certAlias, keysPassword);
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(certAlias);
            PublicKey publicKey = cert.getPublicKey();
            KeyPair keyPair = new KeyPair(publicKey, (PrivateKey)key);
            return CredentialSupport.getSimpleCredential((X509Certificate)cert, (PrivateKey)keyPair.getPrivate());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new SAML2RuntimeException(e);
        }
    }
}

