/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.sling.maven.projectsupport.ArtifactDefinition;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.Bundle;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.StartLevel;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.io.xpp3.BundleListXpp3Reader;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class BundleListUtils {
    private BundleListUtils() {
    }

    public static final void initArtifactDefinitions(ClassLoader classLoader, ArtifactDefinitionsCallback callback) throws IOException {
        Properties dependencies = new Properties();
        dependencies.load(classLoader.getResourceAsStream("org/apache/sling/maven/projectsupport/dependencies.properties"));
        callback.initArtifactDefinitions(dependencies);
    }

    public static boolean isCurrentArtifact(MavenProject project, ArtifactDefinition def) {
        return def.getGroupId().equals(project.getGroupId()) && def.getArtifactId().equals(project.getArtifactId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BundleList readBundleList(File file) throws IOException, XmlPullParserException {
        BundleListXpp3Reader reader = new BundleListXpp3Reader();
        FileInputStream fis = new FileInputStream(file);
        try {
            BundleList bundleList = reader.read(fis);
            return bundleList;
        }
        finally {
            fis.close();
        }
    }

    public static int nodeValue(Xpp3Dom config, String name, int defaultValue) {
        Xpp3Dom node = config.getChild(name);
        if (node != null) {
            return Integer.parseInt(node.getValue());
        }
        return defaultValue;
    }

    public static boolean nodeValue(Xpp3Dom config, String name, boolean defaultValue) {
        Xpp3Dom node = config.getChild(name);
        if (node != null) {
            return Boolean.parseBoolean(node.getValue());
        }
        return defaultValue;
    }

    public static String nodeValue(Xpp3Dom config, String name, String defaultValue) {
        Xpp3Dom node = config.getChild(name);
        if (node != null) {
            return node.getValue();
        }
        return defaultValue;
    }

    public static void interpolateProperties(BundleList bundleList, MavenProject project, MavenSession mavenSession) throws MojoExecutionException {
        Interpolator interpolator = BundleListUtils.createInterpolator(project, mavenSession);
        for (StartLevel sl : bundleList.getStartLevels()) {
            for (Bundle bndl : sl.getBundles()) {
                try {
                    bndl.setArtifactId(interpolator.interpolate(bndl.getArtifactId()));
                    bndl.setGroupId(interpolator.interpolate(bndl.getGroupId()));
                    bndl.setVersion(interpolator.interpolate(bndl.getVersion()));
                    bndl.setClassifier(interpolator.interpolate(bndl.getClassifier()));
                    bndl.setType(interpolator.interpolate(bndl.getType()));
                }
                catch (InterpolationException e) {
                    throw new MojoExecutionException("Unable to interpolate properties for bundle " + bndl.toString(), (Exception)((Object)e));
                }
            }
        }
    }

    public static Interpolator createInterpolator(MavenProject project, MavenSession mavenSession) {
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)project.getProperties());
        props.putAll((Map<?, ?>)mavenSession.getSystemProperties());
        props.putAll((Map<?, ?>)mavenSession.getUserProperties());
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(props));
        interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource(Arrays.asList("project", "pom"), (Object)project, true));
        interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("session", (Object)mavenSession));
        Settings settings = mavenSession.getSettings();
        if (settings != null) {
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("settings", (Object)settings));
        }
        return interpolator;
    }

    public static interface ArtifactDefinitionsCallback {
        public void initArtifactDefinitions(Properties var1);
    }
}

