/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.framework.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.PropertyUtils;
import org.apache.sling.launchpad.api.LaunchpadContentProvider;
import org.apache.sling.launchpad.base.impl.Sling;
import org.apache.sling.launchpad.base.shared.Notifiable;
import org.apache.sling.maven.projectsupport.AbstractUsingBundleListMojo;
import org.apache.sling.maven.projectsupport.ArtifactDefinition;
import org.apache.sling.maven.projectsupport.BundleListContentProvider;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.osgi.framework.BundleException;

public abstract class AbstractLaunchpadStartingMojo
extends AbstractUsingBundleListMojo
implements Notifiable {
    private static final int DEFAULT_LOG_LEVEL = 3;
    private static final String[] logLevels = new String[]{"FATAL", "ERROR", "WARN", "INFO", "DEBUG"};
    private static final String PROP_PORT = "org.osgi.service.http.port";
    private int httpPort;
    @Parameter
    private ArtifactDefinition jarWebSupport;
    @Parameter(property="felix.log.level")
    private String logLevel;
    @Parameter(property="propertiesFile", defaultValue="src/test/config/sling.properties")
    private File propertiesFile;
    @Parameter(property="resourceProviderRoot", defaultValue="src/test/resources")
    private File resourceProviderRoot;
    private LaunchpadContentProvider resourceProvider;
    private Sling sling;
    private String slingHome;
    private boolean forceBundleLoad;

    public AbstractLaunchpadStartingMojo() {
        this.resourceProvider = new BundleListContentProvider(this.resourceProviderRoot){

            @Override
            BundleList getInitializedBundleList() {
                return AbstractLaunchpadStartingMojo.this.getInitializedBundleList();
            }

            @Override
            File getConfigDirectory() {
                return AbstractLaunchpadStartingMojo.this.getConfigDirectory();
            }

            @Override
            Artifact getArtifact(ArtifactDefinition def) throws MojoExecutionException {
                return AbstractLaunchpadStartingMojo.this.getArtifact(def);
            }

            @Override
            Log getLog() {
                return AbstractLaunchpadStartingMojo.this.getLog();
            }
        };
    }

    private static int toLogLevelInt(String level, int defaultLevel) {
        for (int i = 0; i < logLevels.length; ++i) {
            if (!logLevels[i].equalsIgnoreCase(level)) continue;
            return i;
        }
        return defaultLevel;
    }

    public void stopped() {
        this.sling = null;
    }

    public void updated(File updateFile) {
        this.sling = null;
        if (updateFile != null) {
            this.getLog().warn((CharSequence)"Maven Launchpad Plugin doesn't support updating the framework bundle.");
        }
        this.getLog().info((CharSequence)"Restarting Framework and Sling");
        try {
            this.executeWithArtifacts();
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)"Unable to restart Framework and Sling", (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    protected void executeWithArtifacts() throws MojoExecutionException {
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("sling.home", this.slingHome);
            props.put("sling.launchpad", this.slingHome);
            if (this.forceBundleLoad) {
                props.put("org.apache.sling.launchpad.force.package.bundle.loading", "true");
            }
            int logLevelNum = this.logLevel == null ? 3 : AbstractLaunchpadStartingMojo.toLogLevelInt(this.logLevel, 3);
            props.put("felix.log.level", String.valueOf(logLevelNum));
            this.getLog().info((CharSequence)("HTTP server port: " + this.httpPort));
            props.put(PROP_PORT, String.valueOf(this.httpPort));
            Logger logger = new Logger();
            logger.setLogLevel(1);
            if (this.propertiesFile.exists()) {
                File tmp = null;
                try {
                    tmp = File.createTempFile("sling", "props");
                    this.mavenFileFilter.copyFile(this.propertiesFile, tmp, true, this.project, Collections.EMPTY_LIST, true, System.getProperty("file.encoding"), this.mavenSession);
                    Properties loadedProps = PropertyUtils.loadPropertyFile((File)tmp, null);
                    for (Object key : loadedProps.keySet()) {
                        props.put((String)key, (String)loadedProps.get(key));
                    }
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to create filtered properties file", (Exception)e);
                }
                catch (MavenFilteringException e) {
                    throw new MojoExecutionException("Unable to create filtered properties file", (Exception)((Object)e));
                }
                finally {
                    if (tmp != null) {
                        tmp.delete();
                    }
                }
            }
            this.sling = this.startSling(this.resourceProvider, props, logger);
        }
        catch (BundleException be) {
            this.getLog().error((CharSequence)"Failed to Start OSGi framework", (Throwable)be);
        }
    }

    protected abstract Sling startSling(LaunchpadContentProvider var1, Map<String, String> var2, Logger var3) throws BundleException;

    protected void stopSling() {
        if (this.sling != null) {
            this.sling.destroy();
        }
    }

    @Override
    protected void initArtifactDefinitions(Properties dependencies) {
        if (this.jarWebSupport == null) {
            this.jarWebSupport = new ArtifactDefinition();
        }
        this.jarWebSupport.initDefaults(dependencies.getProperty("jarWebSupport"));
    }

    @Override
    protected void initBundleList(BundleList bundleList) {
        bundleList.add(this.jarWebSupport.toBundleList());
    }
}

