/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.internal;

import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.internal.shared.AttributeConvention;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.internal.GeometryConverter;
import org.apache.sis.filter.internal.shared.XPath;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.pending.geoapi.filter.ValueReference;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class GeometryFromFeature<G>
extends GeometryConverter<AbstractFeature, G> {
    private static final long serialVersionUID = -550060050444279386L;
    private final String propertyName;

    private GeometryFromFeature(Geometries<G> library, Expression<AbstractFeature, ?> expression, String propertyName) {
        super(library, expression);
        this.propertyName = propertyName;
    }

    static <G> GeometryFromFeature<G> tryCreate(Geometries<G> library, Expression<?, ?> expression) {
        if (AbstractFeature.class.isAssignableFrom(expression.getResourceClass()) && expression instanceof ValueReference) {
            XPath xpath = new XPath(((ValueReference)expression).getXPath());
            if (xpath.path == null) {
                Expression<?, ?> ve = expression;
                return new GeometryFromFeature<G>(library, ve, xpath.tip);
            }
        }
        return null;
    }

    @Override
    public GeometryWrapper apply(AbstractFeature input) {
        CoordinateReferenceSystem crs;
        Object wrapper = super.apply(input);
        if (wrapper != null && ((GeometryWrapper)wrapper).getCoordinateReferenceSystem() == null && (crs = AttributeConvention.getCRSCharacteristic(input, this.propertyName)) != null) {
            ((GeometryWrapper)wrapper).setCoordinateReferenceSystem(crs);
        }
        return wrapper;
    }
}

