/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter.impl;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import io.vertx.core.json.jackson.DatabindCodec;
import java.lang.reflect.Type;
import org.hibernate.validator.spi.nodenameprovider.JavaBeanProperty;
import org.hibernate.validator.spi.nodenameprovider.Property;
import org.hibernate.validator.spi.nodenameprovider.PropertyNodeNameProvider;

public class JacksonPropertyNodeNameProvider
implements PropertyNodeNameProvider {
    public String getName(Property property) {
        if (property instanceof JavaBeanProperty) {
            return this.getJavaBeanPropertyName((JavaBeanProperty)property);
        }
        return property.getName();
    }

    private String getJavaBeanPropertyName(JavaBeanProperty property) {
        ObjectMapper objectMapper = DatabindCodec.mapper();
        JavaType type = objectMapper.constructType((Type)property.getDeclaringClass());
        BeanDescription desc = objectMapper.getSerializationConfig().introspect(type);
        return desc.findProperties().stream().filter(prop -> prop.getInternalName().equals(property.getName())).map(BeanPropertyDefinition::getName).findFirst().orElse(property.getName());
    }
}

