/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.ha.autoswitch;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.store.ha.autoswitch.MetadataFile;

public class BrokerMetadata
extends MetadataFile {
    protected String clusterName;
    protected String brokerName;
    protected Long brokerId;

    public BrokerMetadata(String filePath) {
        this.filePath = filePath;
    }

    public void updateAndPersist(String clusterName, String brokerName, Long brokerId) throws Exception {
        this.clusterName = clusterName;
        this.brokerName = brokerName;
        this.brokerId = brokerId;
        this.writeToFile();
    }

    @Override
    public String encodeToStr() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.clusterName).append("#");
        sb.append(this.brokerName).append("#");
        sb.append(this.brokerId);
        return sb.toString();
    }

    @Override
    public void decodeFromStr(String dataStr) {
        if (dataStr == null) {
            return;
        }
        String[] dataArr = dataStr.split("#");
        this.clusterName = dataArr[0];
        this.brokerName = dataArr[1];
        this.brokerId = Long.valueOf(dataArr[2]);
    }

    @Override
    public boolean isLoaded() {
        return StringUtils.isNotEmpty((CharSequence)this.clusterName) && StringUtils.isNotEmpty((CharSequence)this.brokerName) && this.brokerId != null;
    }

    @Override
    public void clearInMem() {
        this.clusterName = null;
        this.brokerName = null;
        this.brokerId = null;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public Long getBrokerId() {
        return this.brokerId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerMetadata that = (BrokerMetadata)o;
        return Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.brokerName, that.brokerName) && Objects.equals(this.brokerId, that.brokerId);
    }

    public int hashCode() {
        return Objects.hash(this.clusterName, this.brokerName, this.brokerId);
    }

    public String toString() {
        return "BrokerMetadata{clusterName='" + this.clusterName + '\'' + ", brokerName='" + this.brokerName + '\'' + ", brokerId=" + this.brokerId + ", filePath='" + this.filePath + '\'' + '}';
    }
}

