/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.auth.authentication.model;

import org.apache.rocketmq.auth.authentication.enums.SubjectType;
import org.apache.rocketmq.auth.authentication.enums.UserStatus;
import org.apache.rocketmq.auth.authentication.enums.UserType;
import org.apache.rocketmq.auth.authentication.model.Subject;

public class User
implements Subject {
    private String username;
    private String password;
    private UserType userType;
    private UserStatus userStatus;

    public static User of(String username) {
        User user = new User();
        user.setUsername(username);
        return user;
    }

    public static User of(String username, String password) {
        User user = new User();
        user.setUsername(username);
        user.setPassword(password);
        return user;
    }

    public static User of(String username, String password, UserType userType) {
        User user = new User();
        user.setUsername(username);
        user.setPassword(password);
        user.setUserType(userType);
        return user;
    }

    @Override
    public String getSubjectKey() {
        return this.getSubjectType().getName() + ":" + this.username;
    }

    @Override
    public SubjectType getSubjectType() {
        return SubjectType.USER;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    public UserStatus getUserStatus() {
        return this.userStatus;
    }

    public void setUserStatus(UserStatus userStatus) {
        this.userStatus = userStatus;
    }
}

