/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.tieredstore.common.SelectBufferResult;
import org.apache.rocketmq.tieredstore.util.CQItemBufferUtil;

public class MessageBufferUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    public static final int QUEUE_OFFSET_POSITION = 20;
    public static final int PHYSICAL_OFFSET_POSITION = 28;
    public static final int SYS_FLAG_OFFSET_POSITION = 36;
    public static final int STORE_TIMESTAMP_POSITION = 56;
    public static final int STORE_HOST_POSITION = 64;

    public static int getTotalSize(ByteBuffer message) {
        return message.getInt(message.position());
    }

    public static int getMagicCode(ByteBuffer message) {
        return message.getInt(message.position() + 4);
    }

    public static long getQueueOffset(ByteBuffer message) {
        return message.getLong(message.position() + 20);
    }

    public static long getCommitLogOffset(ByteBuffer message) {
        return message.getLong(message.position() + 28);
    }

    public static long getStoreTimeStamp(ByteBuffer message) {
        return message.getLong(message.position() + 56);
    }

    public static ByteBuffer getOffsetIdBuffer(ByteBuffer message) {
        ByteBuffer idBuffer = ByteBuffer.allocate(16);
        idBuffer.limit(16);
        idBuffer.putLong(message.getLong(message.position() + 64));
        idBuffer.putLong(MessageBufferUtil.getCommitLogOffset(message));
        idBuffer.flip();
        return idBuffer;
    }

    public static String getOffsetId(ByteBuffer message) {
        return UtilAll.bytes2string((byte[])MessageBufferUtil.getOffsetIdBuffer(message).array());
    }

    public static Map<String, String> getProperties(ByteBuffer message) {
        ByteBuffer slice = message.slice();
        return MessageDecoder.decodeProperties((ByteBuffer)slice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SelectBufferResult> splitMessageBuffer(ByteBuffer cqBuffer, ByteBuffer msgBuffer) {
        cqBuffer.rewind();
        msgBuffer.rewind();
        ArrayList<SelectBufferResult> bufferResultList = new ArrayList<SelectBufferResult>(cqBuffer.remaining() / 20);
        if (msgBuffer.remaining() == 0) {
            logger.error("MessageBufferUtil#splitMessage, msg buffer length is zero");
            return bufferResultList;
        }
        if (cqBuffer.remaining() % 20 != 0) {
            logger.error("MessageBufferUtil#splitMessage, consume queue buffer size incorrect, {}", (Object)cqBuffer.remaining());
            return bufferResultList;
        }
        try {
            long firstCommitLogOffset = CQItemBufferUtil.getCommitLogOffset(cqBuffer);
            for (int position = cqBuffer.position(); position < cqBuffer.limit(); position += 20) {
                cqBuffer.position(position);
                long logOffset = CQItemBufferUtil.getCommitLogOffset(cqBuffer);
                int bufferSize = CQItemBufferUtil.getSize(cqBuffer);
                long tagCode = CQItemBufferUtil.getTagCode(cqBuffer);
                int offset = (int)(logOffset - firstCommitLogOffset);
                if (offset + bufferSize > msgBuffer.limit()) {
                    logger.error("MessageBufferUtil#splitMessage, message buffer size incorrect. Expect length in consume queue: {}, actual length: {}", (Object)(offset + bufferSize), (Object)msgBuffer.limit());
                    break;
                }
                msgBuffer.position(offset);
                int magicCode = MessageBufferUtil.getMagicCode(msgBuffer);
                if (magicCode == -875286124) {
                    msgBuffer.position(offset += 16);
                    magicCode = MessageBufferUtil.getMagicCode(msgBuffer);
                }
                if (magicCode != -626843481 && magicCode != -626843477) {
                    logger.warn("MessageBufferUtil#splitMessage, found unknown magic code. Message offset: {}, wrong magic code: {}", (Object)offset, (Object)magicCode);
                    continue;
                }
                if (bufferSize != MessageBufferUtil.getTotalSize(msgBuffer)) {
                    logger.warn("MessageBufferUtil#splitMessage, message length in commitlog incorrect. Except length in commitlog: {}, actual: {}", (Object)MessageBufferUtil.getTotalSize(msgBuffer), (Object)bufferSize);
                    continue;
                }
                ByteBuffer sliceBuffer = msgBuffer.slice();
                sliceBuffer.limit(bufferSize);
                bufferResultList.add(new SelectBufferResult(sliceBuffer, offset, bufferSize, tagCode));
            }
        }
        catch (Exception e) {
            logger.error("MessageBufferUtil#splitMessage, split message buffer error", (Throwable)e);
        }
        finally {
            cqBuffer.rewind();
            msgBuffer.rewind();
        }
        return bufferResultList;
    }
}

