/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.impl.factory;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.ClientConfig;
import org.apache.rocketmq.client.admin.MQAdminExtInner;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.ClientRemotingProcessor;
import org.apache.rocketmq.client.impl.FindBrokerResult;
import org.apache.rocketmq.client.impl.MQAdminImpl;
import org.apache.rocketmq.client.impl.MQClientAPIImpl;
import org.apache.rocketmq.client.impl.MQClientManager;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPullConsumerImpl;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import org.apache.rocketmq.client.impl.consumer.MQConsumerInner;
import org.apache.rocketmq.client.impl.consumer.ProcessQueue;
import org.apache.rocketmq.client.impl.consumer.PullMessageService;
import org.apache.rocketmq.client.impl.consumer.RebalanceService;
import org.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import org.apache.rocketmq.client.impl.producer.MQProducerInner;
import org.apache.rocketmq.client.impl.producer.TopicPublishInfo;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.stat.ConsumerStatsManager;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.ServiceState;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.filter.ExpressionType;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.message.MessageQueueAssignment;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.common.HeartbeatV2Result;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.protocol.NamespaceUtil;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.body.ConsumeMessageDirectlyResult;
import org.apache.rocketmq.remoting.protocol.body.ConsumerRunningInfo;
import org.apache.rocketmq.remoting.protocol.heartbeat.ConsumerData;
import org.apache.rocketmq.remoting.protocol.heartbeat.HeartbeatData;
import org.apache.rocketmq.remoting.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.remoting.protocol.heartbeat.ProducerData;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;
import org.apache.rocketmq.remoting.protocol.route.QueueData;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;
import org.apache.rocketmq.remoting.rpc.ClientMetadata;

public class MQClientInstance {
    private static final long LOCK_TIMEOUT_MILLIS = 3000L;
    private static final Logger log = LoggerFactory.getLogger(MQClientInstance.class);
    private final ClientConfig clientConfig;
    private final String clientId;
    private final long bootTimestamp = System.currentTimeMillis();
    private final ConcurrentMap<String, MQProducerInner> producerTable = new ConcurrentHashMap<String, MQProducerInner>();
    private final ConcurrentMap<String, MQConsumerInner> consumerTable = new ConcurrentHashMap<String, MQConsumerInner>();
    private final ConcurrentMap<String, MQAdminExtInner> adminExtTable = new ConcurrentHashMap<String, MQAdminExtInner>();
    private final NettyClientConfig nettyClientConfig;
    private final MQClientAPIImpl mQClientAPIImpl;
    private final MQAdminImpl mQAdminImpl;
    private final ConcurrentMap<String, TopicRouteData> topicRouteTable = new ConcurrentHashMap<String, TopicRouteData>();
    private final ConcurrentMap<String, ConcurrentMap<MessageQueue, String>> topicEndPointsTable = new ConcurrentHashMap<String, ConcurrentMap<MessageQueue, String>>();
    private final Lock lockNamesrv = new ReentrantLock();
    private final Lock lockHeartbeat = new ReentrantLock();
    private final ConcurrentMap<String, HashMap<Long, String>> brokerAddrTable = new ConcurrentHashMap<String, HashMap<Long, String>>();
    private final ConcurrentMap<String, HashMap<String, Integer>> brokerVersionTable = new ConcurrentHashMap<String, HashMap<String, Integer>>();
    private final Set<String> brokerSupportV2HeartbeatSet = new HashSet<String>();
    private final ConcurrentMap<String, Integer> brokerAddrHeartbeatFingerprintTable = new ConcurrentHashMap<String, Integer>();
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "MQClientFactoryScheduledThread"));
    private final ScheduledExecutorService fetchRemoteConfigExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "MQClientFactoryFetchRemoteConfigScheduledThread");
        }
    });
    private final PullMessageService pullMessageService;
    private final RebalanceService rebalanceService;
    private final DefaultMQProducer defaultMQProducer;
    private final ConsumerStatsManager consumerStatsManager;
    private final AtomicLong sendHeartbeatTimesTotal = new AtomicLong(0L);
    private ServiceState serviceState = ServiceState.CREATE_JUST;
    private final Random random = new Random();

    public MQClientInstance(ClientConfig clientConfig, int instanceIndex, String clientId) {
        this(clientConfig, instanceIndex, clientId, null);
    }

    public MQClientInstance(ClientConfig clientConfig, int instanceIndex, String clientId, RPCHook rpcHook) {
        this.clientConfig = clientConfig;
        this.nettyClientConfig = new NettyClientConfig();
        this.nettyClientConfig.setClientCallbackExecutorThreads(clientConfig.getClientCallbackExecutorThreads());
        this.nettyClientConfig.setUseTLS(clientConfig.isUseTLS());
        this.nettyClientConfig.setSocksProxyConfig(clientConfig.getSocksProxyConfig());
        ClientRemotingProcessor clientRemotingProcessor = new ClientRemotingProcessor(this);
        this.mQClientAPIImpl = new MQClientAPIImpl(this.nettyClientConfig, clientRemotingProcessor, rpcHook, clientConfig);
        if (this.clientConfig.getNamesrvAddr() != null) {
            this.mQClientAPIImpl.updateNameServerAddressList(this.clientConfig.getNamesrvAddr());
            log.info("user specified name server address: {}", (Object)this.clientConfig.getNamesrvAddr());
        }
        this.clientId = clientId;
        this.mQAdminImpl = new MQAdminImpl(this);
        this.pullMessageService = new PullMessageService(this);
        this.rebalanceService = new RebalanceService(this);
        this.defaultMQProducer = new DefaultMQProducer("CLIENT_INNER_PRODUCER");
        this.defaultMQProducer.resetClientConfig(clientConfig);
        this.consumerStatsManager = new ConsumerStatsManager(this.scheduledExecutorService);
        log.info("Created a new client Instance, InstanceIndex:{}, ClientID:{}, ClientConfig:{}, ClientVersion:{}, SerializerType:{}", new Object[]{instanceIndex, this.clientId, this.clientConfig, MQVersion.getVersionDesc((int)MQVersion.CURRENT_VERSION), RemotingCommand.getSerializeTypeConfigInThisServer()});
    }

    public static TopicPublishInfo topicRouteData2TopicPublishInfo(String topic, TopicRouteData route) {
        TopicPublishInfo info = new TopicPublishInfo();
        info.setTopicRouteData(route);
        if (route.getOrderTopicConf() != null && route.getOrderTopicConf().length() > 0) {
            String[] brokers;
            for (String broker : brokers = route.getOrderTopicConf().split(";")) {
                String[] item = broker.split(":");
                int nums = Integer.parseInt(item[1]);
                for (int i = 0; i < nums; ++i) {
                    MessageQueue mq = new MessageQueue(topic, item[0], i);
                    info.getMessageQueueList().add(mq);
                }
            }
            info.setOrderTopic(true);
        } else if (route.getOrderTopicConf() == null && route.getTopicQueueMappingByBroker() != null && !route.getTopicQueueMappingByBroker().isEmpty()) {
            info.setOrderTopic(false);
            ConcurrentMap mqEndPoints = ClientMetadata.topicRouteData2EndpointsForStaticTopic((String)topic, (TopicRouteData)route);
            info.getMessageQueueList().addAll(mqEndPoints.keySet());
            info.getMessageQueueList().sort((mq1, mq2) -> MixAll.compareInteger((int)mq1.getQueueId(), (int)mq2.getQueueId()));
        } else {
            List qds = route.getQueueDatas();
            Collections.sort(qds);
            for (QueueData qd : qds) {
                if (!PermName.isWriteable((int)qd.getPerm())) continue;
                BrokerData brokerData = null;
                for (BrokerData bd : route.getBrokerDatas()) {
                    if (!bd.getBrokerName().equals(qd.getBrokerName())) continue;
                    brokerData = bd;
                    break;
                }
                if (null == brokerData || !brokerData.getBrokerAddrs().containsKey(0L)) continue;
                for (int i = 0; i < qd.getWriteQueueNums(); ++i) {
                    MessageQueue mq = new MessageQueue(topic, qd.getBrokerName(), i);
                    info.getMessageQueueList().add(mq);
                }
            }
            info.setOrderTopic(false);
        }
        return info;
    }

    public static Set<MessageQueue> topicRouteData2TopicSubscribeInfo(String topic, TopicRouteData route) {
        HashSet<MessageQueue> mqList = new HashSet<MessageQueue>();
        if (route.getTopicQueueMappingByBroker() != null && !route.getTopicQueueMappingByBroker().isEmpty()) {
            ConcurrentMap mqEndPoints = ClientMetadata.topicRouteData2EndpointsForStaticTopic((String)topic, (TopicRouteData)route);
            return mqEndPoints.keySet();
        }
        List qds = route.getQueueDatas();
        for (QueueData qd : qds) {
            if (!PermName.isReadable((int)qd.getPerm())) continue;
            for (int i = 0; i < qd.getReadQueueNums(); ++i) {
                MessageQueue mq = new MessageQueue(topic, qd.getBrokerName(), i);
                mqList.add(mq);
            }
        }
        return mqList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws MQClientException {
        MQClientInstance mQClientInstance = this;
        synchronized (mQClientInstance) {
            switch (this.serviceState) {
                case CREATE_JUST: {
                    this.serviceState = ServiceState.START_FAILED;
                    if (null == this.clientConfig.getNamesrvAddr()) {
                        this.mQClientAPIImpl.fetchNameServerAddr();
                    }
                    this.mQClientAPIImpl.start();
                    this.startScheduledTask();
                    this.pullMessageService.start();
                    this.rebalanceService.start();
                    this.defaultMQProducer.getDefaultMQProducerImpl().start(false);
                    log.info("the client factory [{}] start OK", (Object)this.clientId);
                    this.serviceState = ServiceState.RUNNING;
                    break;
                }
                case START_FAILED: {
                    throw new MQClientException("The Factory object[" + this.getClientId() + "] has been created before, and failed.", null);
                }
            }
        }
    }

    private void startScheduledTask() {
        if (null == this.clientConfig.getNamesrvAddr()) {
            this.scheduledExecutorService.scheduleAtFixedRate(() -> {
                try {
                    this.mQClientAPIImpl.fetchNameServerAddr();
                }
                catch (Exception e) {
                    log.error("ScheduledTask fetchNameServerAddr exception", (Throwable)e);
                }
            }, 10000L, 120000L, TimeUnit.MILLISECONDS);
        }
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                this.updateTopicRouteInfoFromNameServer();
            }
            catch (Exception e) {
                log.error("ScheduledTask updateTopicRouteInfoFromNameServer exception", (Throwable)e);
            }
        }, 10L, this.clientConfig.getPollNameServerInterval(), TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                this.cleanOfflineBroker();
                this.sendHeartbeatToAllBrokerWithLock();
            }
            catch (Exception e) {
                log.error("ScheduledTask sendHeartbeatToAllBroker exception", (Throwable)e);
            }
        }, 1000L, this.clientConfig.getHeartbeatBrokerInterval(), TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                this.persistAllConsumerOffset();
            }
            catch (Exception e) {
                log.error("ScheduledTask persistAllConsumerOffset exception", (Throwable)e);
            }
        }, 10000L, this.clientConfig.getPersistConsumerOffsetInterval(), TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                this.adjustThreadPool();
            }
            catch (Exception e) {
                log.error("ScheduledTask adjustThreadPool exception", (Throwable)e);
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void updateTopicRouteInfoFromNameServer() {
        Object impl;
        HashSet<String> topicList = new HashSet<String>();
        for (Map.Entry entry : this.consumerTable.entrySet()) {
            Set<SubscriptionData> subList;
            impl = (MQConsumerInner)entry.getValue();
            if (impl == null || (subList = impl.subscriptions()) == null) continue;
            for (SubscriptionData subData : subList) {
                topicList.add(subData.getTopic());
            }
        }
        for (Map.Entry entry : this.producerTable.entrySet()) {
            impl = (MQProducerInner)entry.getValue();
            if (impl == null) continue;
            Set<String> lst = impl.getPublishTopicList();
            topicList.addAll(lst);
        }
        for (String topic : topicList) {
            this.updateTopicRouteInfoFromNameServer(topic);
        }
    }

    public Map<MessageQueue, Long> parseOffsetTableFromBroker(Map<MessageQueue, Long> offsetTable, String namespace) {
        HashMap<MessageQueue, Long> newOffsetTable = new HashMap<MessageQueue, Long>(offsetTable.size(), 1.0f);
        if (StringUtils.isNotEmpty((CharSequence)namespace)) {
            for (Map.Entry<MessageQueue, Long> entry : offsetTable.entrySet()) {
                MessageQueue queue = entry.getKey();
                queue.setTopic(NamespaceUtil.withoutNamespace((String)queue.getTopic(), (String)namespace));
                newOffsetTable.put(queue, entry.getValue());
            }
        } else {
            newOffsetTable.putAll(offsetTable);
        }
        return newOffsetTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanOfflineBroker() {
        block9: {
            try {
                if (!this.lockNamesrv.tryLock(3000L, TimeUnit.MILLISECONDS)) break block9;
                try {
                    ConcurrentHashMap updatedTable = new ConcurrentHashMap(this.brokerAddrTable.size(), 1.0f);
                    Iterator itBrokerTable = this.brokerAddrTable.entrySet().iterator();
                    while (itBrokerTable.hasNext()) {
                        Map.Entry entry = itBrokerTable.next();
                        String brokerName = (String)entry.getKey();
                        HashMap oneTable = (HashMap)entry.getValue();
                        HashMap cloneAddrTable = new HashMap(oneTable.size(), 1.0f);
                        cloneAddrTable.putAll(oneTable);
                        Iterator it = cloneAddrTable.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry ee = it.next();
                            String addr = (String)ee.getValue();
                            if (this.isBrokerAddrExistInTopicRouteTable(addr)) continue;
                            it.remove();
                            log.info("the broker addr[{} {}] is offline, remove it", (Object)brokerName, (Object)addr);
                        }
                        if (cloneAddrTable.isEmpty()) {
                            itBrokerTable.remove();
                            log.info("the broker[{}] name's host is offline, remove it", (Object)brokerName);
                            continue;
                        }
                        updatedTable.put(brokerName, cloneAddrTable);
                    }
                    if (!updatedTable.isEmpty()) {
                        this.brokerAddrTable.putAll(updatedTable);
                    }
                }
                finally {
                    this.lockNamesrv.unlock();
                }
            }
            catch (InterruptedException e) {
                log.warn("cleanOfflineBroker Exception", (Throwable)e);
            }
        }
    }

    public void checkClientInBroker() throws MQClientException {
        for (Map.Entry entry : this.consumerTable.entrySet()) {
            Set<SubscriptionData> subscriptionInner = ((MQConsumerInner)entry.getValue()).subscriptions();
            if (subscriptionInner == null || subscriptionInner.isEmpty()) {
                return;
            }
            for (SubscriptionData subscriptionData : subscriptionInner) {
                String addr;
                if (ExpressionType.isTagType((String)subscriptionData.getExpressionType()) || (addr = this.findBrokerAddrByTopic(subscriptionData.getTopic())) == null) continue;
                try {
                    this.getMQClientAPIImpl().checkClientInBroker(addr, (String)entry.getKey(), this.clientId, subscriptionData, this.clientConfig.getMqClientApiTimeout());
                }
                catch (Exception e) {
                    if (e instanceof MQClientException) {
                        throw (MQClientException)e;
                    }
                    throw new MQClientException("Check client in broker error, maybe because you use " + subscriptionData.getExpressionType() + " to filter message, but server has not been upgraded to support!This error would not affect the launch of consumer, but may has impact on message receiving if you have use the new features which are not supported by server, please check the log!", e);
                }
            }
        }
    }

    public void sendHeartbeatToAllBrokerWithLockV2(boolean isRebalance) {
        if (this.lockHeartbeat.tryLock()) {
            try {
                if (this.clientConfig.isUseHeartbeatV2()) {
                    this.sendHeartbeatToAllBrokerV2(isRebalance);
                }
                this.sendHeartbeatToAllBroker();
            }
            catch (Exception e) {
                log.error("sendHeartbeatToAllBrokerWithLockV2 exception", (Throwable)e);
            }
            finally {
                this.lockHeartbeat.unlock();
            }
        } else {
            log.warn("sendHeartbeatToAllBrokerWithLockV2 lock heartBeat, but failed.");
        }
    }

    public void sendHeartbeatToAllBrokerWithLock() {
        if (this.lockHeartbeat.tryLock()) {
            try {
                if (this.clientConfig.isUseHeartbeatV2()) {
                    this.sendHeartbeatToAllBrokerV2(false);
                }
                this.sendHeartbeatToAllBroker();
            }
            catch (Exception e) {
                log.error("sendHeartbeatToAllBroker exception", (Throwable)e);
            }
            finally {
                this.lockHeartbeat.unlock();
            }
        } else {
            log.warn("lock heartBeat, but failed. [{}]", (Object)this.clientId);
        }
    }

    private void persistAllConsumerOffset() {
        for (Map.Entry entry : this.consumerTable.entrySet()) {
            MQConsumerInner impl = (MQConsumerInner)entry.getValue();
            impl.persistConsumerOffset();
        }
    }

    public void adjustThreadPool() {
        for (Map.Entry entry : this.consumerTable.entrySet()) {
            MQConsumerInner impl = (MQConsumerInner)entry.getValue();
            if (impl == null) continue;
            try {
                if (!(impl instanceof DefaultMQPushConsumerImpl)) continue;
                DefaultMQPushConsumerImpl dmq = (DefaultMQPushConsumerImpl)impl;
                dmq.adjustThreadPool();
            }
            catch (Exception exception) {}
        }
    }

    public boolean updateTopicRouteInfoFromNameServer(String topic) {
        return this.updateTopicRouteInfoFromNameServer(topic, false, null);
    }

    private boolean isBrokerAddrExistInTopicRouteTable(String addr) {
        for (Map.Entry entry : this.topicRouteTable.entrySet()) {
            TopicRouteData topicRouteData = (TopicRouteData)entry.getValue();
            List bds = topicRouteData.getBrokerDatas();
            for (BrokerData bd : bds) {
                boolean exist;
                if (bd.getBrokerAddrs() == null || !(exist = bd.getBrokerAddrs().containsValue(addr))) continue;
                return true;
            }
        }
        return false;
    }

    private void sendHeartbeatToAllBroker() {
        HeartbeatData heartbeatData = this.prepareHeartbeatData(false);
        boolean producerEmpty = heartbeatData.getProducerDataSet().isEmpty();
        boolean consumerEmpty = heartbeatData.getConsumerDataSet().isEmpty();
        if (producerEmpty && consumerEmpty) {
            log.warn("sending heartbeat, but no consumer and no producer. [{}]", (Object)this.clientId);
            return;
        }
        if (this.brokerAddrTable.isEmpty()) {
            return;
        }
        long times = this.sendHeartbeatTimesTotal.getAndIncrement();
        for (Map.Entry brokerClusterInfo : this.brokerAddrTable.entrySet()) {
            String brokerName = (String)brokerClusterInfo.getKey();
            HashMap oneTable = (HashMap)brokerClusterInfo.getValue();
            if (oneTable == null) continue;
            for (Map.Entry singleBrokerInstance : oneTable.entrySet()) {
                Long id = (Long)singleBrokerInstance.getKey();
                String addr = (String)singleBrokerInstance.getValue();
                if (addr == null || consumerEmpty && 0L != id) continue;
                try {
                    int version = this.mQClientAPIImpl.sendHeartbeat(addr, heartbeatData, this.clientConfig.getMqClientApiTimeout());
                    if (!this.brokerVersionTable.containsKey(brokerName)) {
                        this.brokerVersionTable.put(brokerName, new HashMap(4));
                    }
                    ((HashMap)this.brokerVersionTable.get(brokerName)).put(addr, version);
                    if (times % 20L != 0L) continue;
                    log.info("send heart beat to broker[{} {} {}] success", new Object[]{brokerName, id, addr});
                    log.info(heartbeatData.toString());
                }
                catch (Exception e) {
                    if (this.isBrokerInNameServer(addr)) {
                        log.warn("send heart beat to broker[{} {} {}] failed", new Object[]{brokerName, id, addr, e});
                        continue;
                    }
                    log.warn("send heart beat to broker[{} {} {}] exception, because the broker not up, forget it", new Object[]{brokerName, id, addr, e});
                }
            }
        }
    }

    private void sendHeartbeatToAllBrokerV2(boolean isRebalance) {
        HeartbeatData heartbeatDataWithSub = this.prepareHeartbeatData(false);
        boolean producerEmpty = heartbeatDataWithSub.getProducerDataSet().isEmpty();
        boolean consumerEmpty = heartbeatDataWithSub.getConsumerDataSet().isEmpty();
        if (producerEmpty && consumerEmpty) {
            log.warn("sendHeartbeatToAllBrokerV2 sending heartbeat, but no consumer and no producer. [{}]", (Object)this.clientId);
            return;
        }
        if (this.brokerAddrTable.isEmpty()) {
            return;
        }
        if (isRebalance) {
            this.resetBrokerAddrHeartbeatFingerprintMap();
        }
        long times = this.sendHeartbeatTimesTotal.getAndIncrement();
        int currentHeartbeatFingerprint = heartbeatDataWithSub.computeHeartbeatFingerprint();
        heartbeatDataWithSub.setHeartbeatFingerprint(currentHeartbeatFingerprint);
        HeartbeatData heartbeatDataWithoutSub = this.prepareHeartbeatData(true);
        heartbeatDataWithoutSub.setHeartbeatFingerprint(currentHeartbeatFingerprint);
        for (Map.Entry brokerClusterInfo : this.brokerAddrTable.entrySet()) {
            String brokerName = (String)brokerClusterInfo.getKey();
            HashMap oneTable = (HashMap)brokerClusterInfo.getValue();
            if (oneTable == null) continue;
            for (Map.Entry singleBrokerInstance : oneTable.entrySet()) {
                Long id = (Long)singleBrokerInstance.getKey();
                String addr = (String)singleBrokerInstance.getValue();
                if (addr == null || consumerEmpty && 0L != id) continue;
                try {
                    int version = 0;
                    boolean isBrokerSupportV2 = this.brokerSupportV2HeartbeatSet.contains(addr);
                    HeartbeatV2Result heartbeatV2Result = null;
                    if (isBrokerSupportV2 && null != this.brokerAddrHeartbeatFingerprintTable.get(addr) && (Integer)this.brokerAddrHeartbeatFingerprintTable.get(addr) == currentHeartbeatFingerprint) {
                        heartbeatV2Result = this.mQClientAPIImpl.sendHeartbeatV2(addr, heartbeatDataWithoutSub, this.clientConfig.getMqClientApiTimeout());
                        if (heartbeatV2Result.isSubChange()) {
                            this.brokerAddrHeartbeatFingerprintTable.remove(addr);
                        }
                        log.info("sendHeartbeatToAllBrokerV2 simple brokerName: {} subChange: {} brokerAddrHeartbeatFingerprintTable: {}", new Object[]{brokerName, heartbeatV2Result.isSubChange(), JSON.toJSONString(this.brokerAddrHeartbeatFingerprintTable)});
                    } else {
                        heartbeatV2Result = this.mQClientAPIImpl.sendHeartbeatV2(addr, heartbeatDataWithSub, this.clientConfig.getMqClientApiTimeout());
                        if (heartbeatV2Result.isSupportV2()) {
                            this.brokerSupportV2HeartbeatSet.add(addr);
                            if (heartbeatV2Result.isSubChange()) {
                                this.brokerAddrHeartbeatFingerprintTable.remove(addr);
                            } else if (!this.brokerAddrHeartbeatFingerprintTable.containsKey(addr) || (Integer)this.brokerAddrHeartbeatFingerprintTable.get(addr) != currentHeartbeatFingerprint) {
                                this.brokerAddrHeartbeatFingerprintTable.put(addr, currentHeartbeatFingerprint);
                            }
                        }
                        log.info("sendHeartbeatToAllBrokerV2 normal brokerName: {} subChange: {} brokerAddrHeartbeatFingerprintTable: {}", new Object[]{brokerName, heartbeatV2Result.isSubChange(), JSON.toJSONString(this.brokerAddrHeartbeatFingerprintTable)});
                    }
                    version = heartbeatV2Result.getVersion();
                    if (!this.brokerVersionTable.containsKey(brokerName)) {
                        this.brokerVersionTable.put(brokerName, new HashMap(4));
                    }
                    ((HashMap)this.brokerVersionTable.get(brokerName)).put(addr, version);
                    if (times % 20L != 0L) continue;
                    log.info("send heart beat to broker[{} {} {}] success", new Object[]{brokerName, id, addr});
                    log.info(heartbeatDataWithSub.toString());
                }
                catch (Exception e) {
                    if (this.isBrokerInNameServer(addr)) {
                        log.warn("sendHeartbeatToAllBrokerV2 send heart beat to broker[{} {} {}] failed", new Object[]{brokerName, id, addr, e});
                        continue;
                    }
                    log.warn("sendHeartbeatToAllBrokerV2 send heart beat to broker[{} {} {}] exception, because the broker not up, forget it", new Object[]{brokerName, id, addr, e});
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateTopicRouteInfoFromNameServer(String topic, boolean isDefault, DefaultMQProducer defaultMQProducer) {
        try {
            if (!this.lockNamesrv.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                log.warn("updateTopicRouteInfoFromNameServer tryLock timeout {}ms. [{}]", (Object)3000L, (Object)this.clientId);
                return false;
            }
            try {
                TopicRouteData topicRouteData;
                if (isDefault && defaultMQProducer != null) {
                    topicRouteData = this.mQClientAPIImpl.getDefaultTopicRouteInfoFromNameServer(this.clientConfig.getMqClientApiTimeout());
                    if (topicRouteData != null) {
                        for (QueueData data : topicRouteData.getQueueDatas()) {
                            int queueNums = Math.min(defaultMQProducer.getDefaultTopicQueueNums(), data.getReadQueueNums());
                            data.setReadQueueNums(queueNums);
                            data.setWriteQueueNums(queueNums);
                        }
                    }
                } else {
                    topicRouteData = this.mQClientAPIImpl.getTopicRouteInfoFromNameServer(topic, this.clientConfig.getMqClientApiTimeout());
                }
                if (topicRouteData != null) {
                    Object impl;
                    TopicRouteData old = (TopicRouteData)this.topicRouteTable.get(topic);
                    boolean changed = topicRouteData.topicRouteDataChanged(old);
                    if (!changed) {
                        changed = this.isNeedUpdateTopicRouteInfo(topic);
                    } else {
                        log.info("the topic[{}] route info changed, old[{}] ,new[{}]", new Object[]{topic, old, topicRouteData});
                    }
                    if (!changed) return false;
                    for (BrokerData bd : topicRouteData.getBrokerDatas()) {
                        this.brokerAddrTable.put(bd.getBrokerName(), bd.getBrokerAddrs());
                    }
                    ConcurrentMap mqEndPoints = ClientMetadata.topicRouteData2EndpointsForStaticTopic((String)topic, (TopicRouteData)topicRouteData);
                    if (!mqEndPoints.isEmpty()) {
                        this.topicEndPointsTable.put(topic, mqEndPoints);
                    }
                    TopicPublishInfo publishInfo = MQClientInstance.topicRouteData2TopicPublishInfo(topic, topicRouteData);
                    publishInfo.setHaveTopicRouterInfo(true);
                    for (Map.Entry entry : this.producerTable.entrySet()) {
                        impl = (MQProducerInner)entry.getValue();
                        if (impl == null) continue;
                        impl.updateTopicPublishInfo(topic, publishInfo);
                    }
                    if (!this.consumerTable.isEmpty()) {
                        Set<MessageQueue> subscribeInfo = MQClientInstance.topicRouteData2TopicSubscribeInfo(topic, topicRouteData);
                        for (Map.Entry entry : this.consumerTable.entrySet()) {
                            impl = (MQConsumerInner)entry.getValue();
                            if (impl == null) continue;
                            impl.updateTopicSubscribeInfo(topic, subscribeInfo);
                        }
                    }
                    TopicRouteData cloneTopicRouteData = new TopicRouteData(topicRouteData);
                    log.info("topicRouteTable.put. Topic = {}, TopicRouteData[{}]", (Object)topic, (Object)cloneTopicRouteData);
                    this.topicRouteTable.put(topic, cloneTopicRouteData);
                    boolean bl = true;
                    return bl;
                }
                log.warn("updateTopicRouteInfoFromNameServer, getTopicRouteInfoFromNameServer return null, Topic: {}. [{}]", (Object)topic, (Object)this.clientId);
                return false;
            }
            catch (MQClientException e) {
                if (topic.startsWith("%RETRY%")) return false;
                if (topic.equals("TBW102")) return false;
                log.warn("updateTopicRouteInfoFromNameServer Exception", (Throwable)e);
                return false;
            }
            catch (RemotingException e) {
                log.error("updateTopicRouteInfoFromNameServer Exception", (Throwable)e);
                throw new IllegalStateException(e);
            }
            finally {
                this.lockNamesrv.unlock();
            }
        }
        catch (InterruptedException e) {
            log.warn("updateTopicRouteInfoFromNameServer Exception", (Throwable)e);
        }
        return false;
    }

    private HeartbeatData prepareHeartbeatData(boolean isWithoutSub) {
        Object impl;
        HeartbeatData heartbeatData = new HeartbeatData();
        heartbeatData.setClientID(this.clientId);
        for (Map.Entry entry : this.consumerTable.entrySet()) {
            impl = (MQConsumerInner)entry.getValue();
            if (impl == null) continue;
            ConsumerData consumerData = new ConsumerData();
            consumerData.setGroupName(impl.groupName());
            consumerData.setConsumeType(impl.consumeType());
            consumerData.setMessageModel(impl.messageModel());
            consumerData.setConsumeFromWhere(impl.consumeFromWhere());
            consumerData.getSubscriptionDataSet().addAll(impl.subscriptions());
            consumerData.setUnitMode(impl.isUnitMode());
            if (!isWithoutSub) {
                consumerData.getSubscriptionDataSet().addAll(impl.subscriptions());
            }
            heartbeatData.getConsumerDataSet().add(consumerData);
        }
        for (Map.Entry entry : this.producerTable.entrySet()) {
            impl = (MQProducerInner)entry.getValue();
            if (impl == null) continue;
            ProducerData producerData = new ProducerData();
            producerData.setGroupName((String)entry.getKey());
            heartbeatData.getProducerDataSet().add(producerData);
        }
        heartbeatData.setWithoutSub(isWithoutSub);
        return heartbeatData;
    }

    private boolean isBrokerInNameServer(String brokerAddr) {
        for (Map.Entry itNext : this.topicRouteTable.entrySet()) {
            List brokerDatas = ((TopicRouteData)itNext.getValue()).getBrokerDatas();
            for (BrokerData bd : brokerDatas) {
                boolean contain = bd.getBrokerAddrs().containsValue(brokerAddr);
                if (!contain) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNeedUpdateTopicRouteInfo(String topic) {
        boolean result = false;
        Iterator producerIterator = this.producerTable.entrySet().iterator();
        while (producerIterator.hasNext() && !result) {
            Map.Entry entry = producerIterator.next();
            MQProducerInner impl = (MQProducerInner)entry.getValue();
            if (impl == null) continue;
            result = impl.isPublishTopicNeedUpdate(topic);
        }
        if (result) {
            return true;
        }
        Iterator consumerIterator = this.consumerTable.entrySet().iterator();
        while (consumerIterator.hasNext() && !result) {
            Map.Entry entry = consumerIterator.next();
            MQConsumerInner impl = (MQConsumerInner)entry.getValue();
            if (impl == null) continue;
            result = impl.isSubscribeTopicNeedUpdate(topic);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.consumerTable.isEmpty()) {
            return;
        }
        if (!this.adminExtTable.isEmpty()) {
            return;
        }
        if (this.producerTable.size() > 1) {
            return;
        }
        MQClientInstance mQClientInstance = this;
        synchronized (mQClientInstance) {
            switch (this.serviceState) {
                case RUNNING: {
                    this.defaultMQProducer.getDefaultMQProducerImpl().shutdown(false);
                    this.serviceState = ServiceState.SHUTDOWN_ALREADY;
                    this.pullMessageService.shutdown(true);
                    this.scheduledExecutorService.shutdown();
                    this.mQClientAPIImpl.shutdown();
                    this.rebalanceService.shutdown();
                    MQClientManager.getInstance().removeClientFactory(this.clientId);
                    log.info("the client factory [{}] shutdown OK", (Object)this.clientId);
                    break;
                }
            }
        }
    }

    public synchronized boolean registerConsumer(String group, MQConsumerInner consumer) {
        if (null == group || null == consumer) {
            return false;
        }
        MQConsumerInner prev = this.consumerTable.putIfAbsent(group, consumer);
        if (prev != null) {
            log.warn("the consumer group[" + group + "] exist already.");
            return false;
        }
        return true;
    }

    public synchronized void unregisterConsumer(String group) {
        this.consumerTable.remove(group);
        this.unregisterClient(null, group);
    }

    private void unregisterClient(String producerGroup, String consumerGroup) {
        for (Map.Entry brokerClusterInfo : this.brokerAddrTable.entrySet()) {
            String brokerName = (String)brokerClusterInfo.getKey();
            HashMap oneTable = (HashMap)brokerClusterInfo.getValue();
            if (oneTable == null) continue;
            for (Map.Entry singleBrokerInstance : oneTable.entrySet()) {
                String addr = (String)singleBrokerInstance.getValue();
                if (addr == null) continue;
                try {
                    this.mQClientAPIImpl.unregisterClient(addr, this.clientId, producerGroup, consumerGroup, this.clientConfig.getMqClientApiTimeout());
                    log.info("unregister client[Producer: {} Consumer: {}] from broker[{} {} {}] success", new Object[]{producerGroup, consumerGroup, brokerName, singleBrokerInstance.getKey(), addr});
                }
                catch (RemotingException e) {
                    log.warn("unregister client RemotingException from broker: {}, {}", (Object)addr, (Object)e.getMessage());
                }
                catch (InterruptedException e) {
                    log.warn("unregister client InterruptedException from broker: {}, {}", (Object)addr, (Object)e.getMessage());
                }
                catch (MQBrokerException e) {
                    log.warn("unregister client MQBrokerException from broker: {}, {}", (Object)addr, (Object)e.getMessage());
                }
            }
        }
    }

    public synchronized boolean registerProducer(String group, DefaultMQProducerImpl producer) {
        if (null == group || null == producer) {
            return false;
        }
        MQProducerInner prev = this.producerTable.putIfAbsent(group, producer);
        if (prev != null) {
            log.warn("the producer group[{}] exist already.", (Object)group);
            return false;
        }
        return true;
    }

    public synchronized void unregisterProducer(String group) {
        this.producerTable.remove(group);
        this.unregisterClient(group, null);
    }

    public boolean registerAdminExt(String group, MQAdminExtInner admin) {
        if (null == group || null == admin) {
            return false;
        }
        MQAdminExtInner prev = this.adminExtTable.putIfAbsent(group, admin);
        if (prev != null) {
            log.warn("the admin group[{}] exist already.", (Object)group);
            return false;
        }
        return true;
    }

    public void unregisterAdminExt(String group) {
        this.adminExtTable.remove(group);
    }

    public void rebalanceLater(long delayMillis) {
        if (delayMillis <= 0L) {
            this.rebalanceService.wakeup();
        } else {
            this.scheduledExecutorService.schedule(() -> ((RebalanceService)this.rebalanceService).wakeup(), delayMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void rebalanceImmediately() {
        this.rebalanceService.wakeup();
    }

    public void doRebalance() {
        for (Map.Entry entry : this.consumerTable.entrySet()) {
            MQConsumerInner impl = (MQConsumerInner)entry.getValue();
            if (impl == null) continue;
            try {
                impl.doRebalance();
            }
            catch (Throwable e) {
                log.error("doRebalance exception", e);
            }
        }
    }

    public MQProducerInner selectProducer(String group) {
        return (MQProducerInner)this.producerTable.get(group);
    }

    public MQConsumerInner selectConsumer(String group) {
        return (MQConsumerInner)this.consumerTable.get(group);
    }

    public String getBrokerNameFromMessageQueue(MessageQueue mq) {
        if (this.topicEndPointsTable.get(mq.getTopic()) != null && !((ConcurrentMap)this.topicEndPointsTable.get(mq.getTopic())).isEmpty()) {
            return (String)((ConcurrentMap)this.topicEndPointsTable.get(mq.getTopic())).get(mq);
        }
        return mq.getBrokerName();
    }

    public FindBrokerResult findBrokerAddressInAdmin(String brokerName) {
        if (brokerName == null) {
            return null;
        }
        String brokerAddr = null;
        boolean slave = false;
        boolean found = false;
        HashMap map = (HashMap)this.brokerAddrTable.get(brokerName);
        if (map != null && !map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                Long id = (Long)entry.getKey();
                brokerAddr = (String)entry.getValue();
                if (brokerAddr == null) continue;
                found = true;
                slave = 0L != id;
                break;
            }
        }
        if (found) {
            return new FindBrokerResult(brokerAddr, slave, this.findBrokerVersion(brokerName, brokerAddr));
        }
        return null;
    }

    public String findBrokerAddressInPublish(String brokerName) {
        if (brokerName == null) {
            return null;
        }
        HashMap map = (HashMap)this.brokerAddrTable.get(brokerName);
        if (map != null && !map.isEmpty()) {
            return (String)map.get(0L);
        }
        return null;
    }

    public FindBrokerResult findBrokerAddressInSubscribe(String brokerName, long brokerId, boolean onlyThisBroker) {
        if (brokerName == null) {
            return null;
        }
        String brokerAddr = null;
        boolean slave = false;
        boolean found = false;
        HashMap map = (HashMap)this.brokerAddrTable.get(brokerName);
        if (map != null && !map.isEmpty()) {
            brokerAddr = (String)map.get(brokerId);
            slave = brokerId != 0L;
            boolean bl = found = brokerAddr != null;
            if (!found && slave) {
                brokerAddr = (String)map.get(brokerId + 1L);
                boolean bl2 = found = brokerAddr != null;
            }
            if (!found && !onlyThisBroker) {
                Map.Entry entry = map.entrySet().iterator().next();
                brokerAddr = (String)entry.getValue();
                slave = (Long)entry.getKey() != 0L;
                found = true;
            }
        }
        if (found) {
            return new FindBrokerResult(brokerAddr, slave, this.findBrokerVersion(brokerName, brokerAddr));
        }
        return null;
    }

    private int findBrokerVersion(String brokerName, String brokerAddr) {
        if (this.brokerVersionTable.containsKey(brokerName) && ((HashMap)this.brokerVersionTable.get(brokerName)).containsKey(brokerAddr)) {
            return (Integer)((HashMap)this.brokerVersionTable.get(brokerName)).get(brokerAddr);
        }
        return 0;
    }

    public List<String> findConsumerIdList(String topic, String group) {
        String brokerAddr = this.findBrokerAddrByTopic(topic);
        if (null == brokerAddr) {
            this.updateTopicRouteInfoFromNameServer(topic);
            brokerAddr = this.findBrokerAddrByTopic(topic);
        }
        if (null != brokerAddr) {
            try {
                return this.mQClientAPIImpl.getConsumerIdListByGroup(brokerAddr, group, this.clientConfig.getMqClientApiTimeout());
            }
            catch (Exception e) {
                log.warn("getConsumerIdListByGroup exception, " + brokerAddr + " " + group, (Throwable)e);
            }
        }
        return null;
    }

    public Set<MessageQueueAssignment> queryAssignment(String topic, String consumerGroup, String strategyName, MessageModel messageModel, int timeout) throws RemotingException, InterruptedException, MQBrokerException {
        String brokerAddr = this.findBrokerAddrByTopic(topic);
        if (null == brokerAddr) {
            this.updateTopicRouteInfoFromNameServer(topic);
            brokerAddr = this.findBrokerAddrByTopic(topic);
        }
        if (null != brokerAddr) {
            return this.mQClientAPIImpl.queryAssignment(brokerAddr, topic, consumerGroup, this.clientId, strategyName, messageModel, timeout);
        }
        return null;
    }

    public String findBrokerAddrByTopic(String topic) {
        List brokers;
        TopicRouteData topicRouteData = (TopicRouteData)this.topicRouteTable.get(topic);
        if (topicRouteData != null && !(brokers = topicRouteData.getBrokerDatas()).isEmpty()) {
            int index = this.random.nextInt(brokers.size());
            BrokerData bd = (BrokerData)brokers.get(index % brokers.size());
            return bd.selectBrokerAddr();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resetOffset(String topic, String group, Map<MessageQueue, Long> offsetTable) {
        DefaultMQPushConsumerImpl consumer = null;
        try {
            MQConsumerInner impl = (MQConsumerInner)this.consumerTable.get(group);
            if (!(impl instanceof DefaultMQPushConsumerImpl)) {
                log.info("[reset-offset] consumer dose not exist. group={}", (Object)group);
                return;
            }
            consumer = (DefaultMQPushConsumerImpl)impl;
            consumer.suspend();
            ConcurrentMap<MessageQueue, ProcessQueue> processQueueTable = consumer.getRebalanceImpl().getProcessQueueTable();
            for (Map.Entry entry : processQueueTable.entrySet()) {
                MessageQueue mq = (MessageQueue)entry.getKey();
                if (!topic.equals(mq.getTopic()) || !offsetTable.containsKey(mq)) continue;
                ProcessQueue pq = (ProcessQueue)entry.getValue();
                pq.setDropped(true);
                pq.clear();
            }
            try {
                TimeUnit.SECONDS.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Iterator iterator = processQueueTable.keySet().iterator();
            while (iterator.hasNext()) {
                MessageQueue mq = (MessageQueue)iterator.next();
                Long offset = offsetTable.get(mq);
                if (!topic.equals(mq.getTopic()) || offset == null) continue;
                try {
                    consumer.updateConsumeOffset(mq, offset);
                    consumer.getRebalanceImpl().removeUnnecessaryMessageQueue(mq, (ProcessQueue)processQueueTable.get(mq));
                    iterator.remove();
                }
                catch (Exception e) {
                    log.warn("reset offset failed. group={}, {}", new Object[]{group, mq, e});
                }
            }
        }
        finally {
            if (consumer != null) {
                consumer.resume();
            }
        }
    }

    public Map<MessageQueue, Long> getConsumerStatus(String topic, String group) {
        MQConsumerInner impl = (MQConsumerInner)this.consumerTable.get(group);
        if (impl instanceof DefaultMQPushConsumerImpl) {
            DefaultMQPushConsumerImpl consumer = (DefaultMQPushConsumerImpl)impl;
            return consumer.getOffsetStore().cloneOffsetTable(topic);
        }
        if (impl instanceof DefaultMQPullConsumerImpl) {
            DefaultMQPullConsumerImpl consumer = (DefaultMQPullConsumerImpl)impl;
            return consumer.getOffsetStore().cloneOffsetTable(topic);
        }
        return Collections.EMPTY_MAP;
    }

    public TopicRouteData getAnExistTopicRouteData(String topic) {
        return (TopicRouteData)this.topicRouteTable.get(topic);
    }

    public MQClientAPIImpl getMQClientAPIImpl() {
        return this.mQClientAPIImpl;
    }

    public MQAdminImpl getMQAdminImpl() {
        return this.mQAdminImpl;
    }

    public long getBootTimestamp() {
        return this.bootTimestamp;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public PullMessageService getPullMessageService() {
        return this.pullMessageService;
    }

    public DefaultMQProducer getDefaultMQProducer() {
        return this.defaultMQProducer;
    }

    public ConcurrentMap<String, TopicRouteData> getTopicRouteTable() {
        return this.topicRouteTable;
    }

    public ConsumeMessageDirectlyResult consumeMessageDirectly(MessageExt msg, String consumerGroup, String brokerName) {
        MQConsumerInner mqConsumerInner = (MQConsumerInner)this.consumerTable.get(consumerGroup);
        if (mqConsumerInner instanceof DefaultMQPushConsumerImpl) {
            DefaultMQPushConsumerImpl consumer = (DefaultMQPushConsumerImpl)mqConsumerInner;
            return consumer.getConsumeMessageService().consumeMessageDirectly(msg, brokerName);
        }
        return null;
    }

    public ConsumerRunningInfo consumerRunningInfo(String consumerGroup) {
        MQConsumerInner mqConsumerInner = (MQConsumerInner)this.consumerTable.get(consumerGroup);
        if (mqConsumerInner == null) {
            return null;
        }
        ConsumerRunningInfo consumerRunningInfo = mqConsumerInner.consumerRunningInfo();
        List nsList = this.mQClientAPIImpl.getRemotingClient().getNameServerAddressList();
        StringBuilder strBuilder = new StringBuilder();
        if (nsList != null) {
            for (String addr : nsList) {
                strBuilder.append(addr).append(";");
            }
        }
        String nsAddr = strBuilder.toString();
        consumerRunningInfo.getProperties().put("PROP_NAMESERVER_ADDR", nsAddr);
        consumerRunningInfo.getProperties().put("PROP_CONSUME_TYPE", mqConsumerInner.consumeType().name());
        consumerRunningInfo.getProperties().put("PROP_CLIENT_VERSION", MQVersion.getVersionDesc((int)MQVersion.CURRENT_VERSION));
        return consumerRunningInfo;
    }

    private void resetBrokerAddrHeartbeatFingerprintMap() {
        this.brokerAddrHeartbeatFingerprintTable.clear();
    }

    public ConsumerStatsManager getConsumerStatsManager() {
        return this.consumerStatsManager;
    }

    public NettyClientConfig getNettyClientConfig() {
        return this.nettyClientConfig;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public TopicRouteData queryTopicRouteData(String topic) {
        TopicRouteData data = this.getAnExistTopicRouteData(topic);
        if (data == null) {
            this.updateTopicRouteInfoFromNameServer(topic);
            data = this.getAnExistTopicRouteData(topic);
        }
        return data;
    }
}

