/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.acl.common.AclUtils;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.acl.ClusterAclConfigVersionListSubCommand;
import org.apache.rocketmq.tools.command.acl.DeleteAccessConfigSubCommand;
import org.apache.rocketmq.tools.command.acl.GetAccessConfigSubCommand;
import org.apache.rocketmq.tools.command.acl.UpdateAccessConfigSubCommand;
import org.apache.rocketmq.tools.command.acl.UpdateGlobalWhiteAddrSubCommand;
import org.apache.rocketmq.tools.command.broker.BrokerConsumeStatsSubCommad;
import org.apache.rocketmq.tools.command.broker.BrokerStatusSubCommand;
import org.apache.rocketmq.tools.command.broker.CleanExpiredCQSubCommand;
import org.apache.rocketmq.tools.command.broker.CleanUnusedTopicCommand;
import org.apache.rocketmq.tools.command.broker.CommitLogSetReadAheadSubCommand;
import org.apache.rocketmq.tools.command.broker.DeleteExpiredCommitLogSubCommand;
import org.apache.rocketmq.tools.command.broker.GetBrokerConfigCommand;
import org.apache.rocketmq.tools.command.broker.GetBrokerEpochSubCommand;
import org.apache.rocketmq.tools.command.broker.GetColdDataFlowCtrInfoSubCommand;
import org.apache.rocketmq.tools.command.broker.RemoveColdDataFlowCtrGroupConfigSubCommand;
import org.apache.rocketmq.tools.command.broker.ResetMasterFlushOffsetSubCommand;
import org.apache.rocketmq.tools.command.broker.SendMsgStatusCommand;
import org.apache.rocketmq.tools.command.broker.UpdateBrokerConfigSubCommand;
import org.apache.rocketmq.tools.command.broker.UpdateColdDataFlowCtrGroupConfigSubCommand;
import org.apache.rocketmq.tools.command.cluster.CLusterSendMsgRTCommand;
import org.apache.rocketmq.tools.command.cluster.ClusterListSubCommand;
import org.apache.rocketmq.tools.command.connection.ConsumerConnectionSubCommand;
import org.apache.rocketmq.tools.command.connection.ProducerConnectionSubCommand;
import org.apache.rocketmq.tools.command.consumer.ConsumerProgressSubCommand;
import org.apache.rocketmq.tools.command.consumer.ConsumerStatusSubCommand;
import org.apache.rocketmq.tools.command.consumer.DeleteSubscriptionGroupCommand;
import org.apache.rocketmq.tools.command.consumer.GetConsumerConfigSubCommand;
import org.apache.rocketmq.tools.command.consumer.SetConsumeModeSubCommand;
import org.apache.rocketmq.tools.command.consumer.StartMonitoringSubCommand;
import org.apache.rocketmq.tools.command.consumer.UpdateSubGroupSubCommand;
import org.apache.rocketmq.tools.command.container.AddBrokerSubCommand;
import org.apache.rocketmq.tools.command.container.RemoveBrokerSubCommand;
import org.apache.rocketmq.tools.command.controller.CleanControllerBrokerMetaSubCommand;
import org.apache.rocketmq.tools.command.controller.GetControllerConfigSubCommand;
import org.apache.rocketmq.tools.command.controller.GetControllerMetaDataSubCommand;
import org.apache.rocketmq.tools.command.controller.ReElectMasterSubCommand;
import org.apache.rocketmq.tools.command.controller.UpdateControllerConfigSubCommand;
import org.apache.rocketmq.tools.command.export.ExportConfigsCommand;
import org.apache.rocketmq.tools.command.export.ExportMetadataCommand;
import org.apache.rocketmq.tools.command.export.ExportMetadataInRocksDBCommand;
import org.apache.rocketmq.tools.command.export.ExportMetricsCommand;
import org.apache.rocketmq.tools.command.ha.GetSyncStateSetSubCommand;
import org.apache.rocketmq.tools.command.ha.HAStatusSubCommand;
import org.apache.rocketmq.tools.command.message.CheckMsgSendRTCommand;
import org.apache.rocketmq.tools.command.message.ConsumeMessageCommand;
import org.apache.rocketmq.tools.command.message.DumpCompactionLogCommand;
import org.apache.rocketmq.tools.command.message.PrintMessageByQueueCommand;
import org.apache.rocketmq.tools.command.message.PrintMessageSubCommand;
import org.apache.rocketmq.tools.command.message.QueryMsgByIdSubCommand;
import org.apache.rocketmq.tools.command.message.QueryMsgByKeySubCommand;
import org.apache.rocketmq.tools.command.message.QueryMsgByOffsetSubCommand;
import org.apache.rocketmq.tools.command.message.QueryMsgByUniqueKeySubCommand;
import org.apache.rocketmq.tools.command.message.QueryMsgTraceByIdSubCommand;
import org.apache.rocketmq.tools.command.message.SendMessageCommand;
import org.apache.rocketmq.tools.command.namesrv.AddWritePermSubCommand;
import org.apache.rocketmq.tools.command.namesrv.DeleteKvConfigCommand;
import org.apache.rocketmq.tools.command.namesrv.GetNamesrvConfigCommand;
import org.apache.rocketmq.tools.command.namesrv.UpdateKvConfigCommand;
import org.apache.rocketmq.tools.command.namesrv.UpdateNamesrvConfigCommand;
import org.apache.rocketmq.tools.command.namesrv.WipeWritePermSubCommand;
import org.apache.rocketmq.tools.command.offset.CloneGroupOffsetCommand;
import org.apache.rocketmq.tools.command.offset.ResetOffsetByTimeCommand;
import org.apache.rocketmq.tools.command.offset.SkipAccumulationSubCommand;
import org.apache.rocketmq.tools.command.producer.ProducerSubCommand;
import org.apache.rocketmq.tools.command.queue.QueryConsumeQueueCommand;
import org.apache.rocketmq.tools.command.stats.StatsAllSubCommand;
import org.apache.rocketmq.tools.command.topic.AllocateMQSubCommand;
import org.apache.rocketmq.tools.command.topic.DeleteTopicSubCommand;
import org.apache.rocketmq.tools.command.topic.RemappingStaticTopicSubCommand;
import org.apache.rocketmq.tools.command.topic.TopicClusterSubCommand;
import org.apache.rocketmq.tools.command.topic.TopicListSubCommand;
import org.apache.rocketmq.tools.command.topic.TopicRouteSubCommand;
import org.apache.rocketmq.tools.command.topic.TopicStatusSubCommand;
import org.apache.rocketmq.tools.command.topic.UpdateOrderConfCommand;
import org.apache.rocketmq.tools.command.topic.UpdateStaticTopicSubCommand;
import org.apache.rocketmq.tools.command.topic.UpdateTopicPermSubCommand;
import org.apache.rocketmq.tools.command.topic.UpdateTopicSubCommand;

public class MQAdminStartup {
    protected static final List<SubCommand> SUB_COMMANDS = new ArrayList<SubCommand>();
    private static final String ROCKETMQ_HOME = System.getProperty("rocketmq.home.dir", System.getenv("ROCKETMQ_HOME"));

    public static void main(String[] args) {
        MQAdminStartup.main0(args, null);
    }

    public static void main0(String[] args, RPCHook rpcHook) {
        System.setProperty("rocketmq.remoting.version", Integer.toString(MQVersion.CURRENT_VERSION));
        MQAdminStartup.initCommand();
        try {
            switch (args.length) {
                case 0: {
                    MQAdminStartup.printHelp();
                    break;
                }
                case 2: {
                    if (args[0].equals("help")) {
                        SubCommand cmd = MQAdminStartup.findSubCommand(args[1]);
                        if (cmd != null) {
                            Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
                            if ((options = cmd.buildCommandlineOptions(options)) != null) {
                                ServerUtil.printCommandLineHelp((String)("mqadmin " + cmd.commandName()), (Options)options);
                            }
                            break;
                        }
                        System.out.printf("The sub command %s not exist.%n", args[1]);
                        break;
                    }
                }
                default: {
                    SubCommand cmd = MQAdminStartup.findSubCommand(args[0]);
                    if (cmd != null) {
                        String[] subargs = MQAdminStartup.parseSubArgs(args);
                        Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
                        CommandLine commandLine = ServerUtil.parseCmdLine((String)("mqadmin " + cmd.commandName()), (String[])subargs, (Options)cmd.buildCommandlineOptions(options), (CommandLineParser)new DefaultParser());
                        if (null == commandLine) {
                            return;
                        }
                        if (commandLine.hasOption('n')) {
                            String namesrvAddr = commandLine.getOptionValue('n');
                            System.setProperty("rocketmq.namesrv.addr", namesrvAddr);
                        }
                        if (rpcHook != null) {
                            cmd.execute(commandLine, options, rpcHook);
                            break;
                        }
                        cmd.execute(commandLine, options, AclUtils.getAclRPCHook((String)(ROCKETMQ_HOME + "/conf/tools.yml")));
                        break;
                    }
                    System.out.printf("The sub command %s not exist.%n", args[0]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void initCommand() {
        MQAdminStartup.initCommand(new UpdateTopicSubCommand());
        MQAdminStartup.initCommand(new DeleteTopicSubCommand());
        MQAdminStartup.initCommand(new UpdateSubGroupSubCommand());
        MQAdminStartup.initCommand(new SetConsumeModeSubCommand());
        MQAdminStartup.initCommand(new DeleteSubscriptionGroupCommand());
        MQAdminStartup.initCommand(new UpdateBrokerConfigSubCommand());
        MQAdminStartup.initCommand(new UpdateTopicPermSubCommand());
        MQAdminStartup.initCommand(new TopicRouteSubCommand());
        MQAdminStartup.initCommand(new TopicStatusSubCommand());
        MQAdminStartup.initCommand(new TopicClusterSubCommand());
        MQAdminStartup.initCommand(new AddBrokerSubCommand());
        MQAdminStartup.initCommand(new RemoveBrokerSubCommand());
        MQAdminStartup.initCommand(new ResetMasterFlushOffsetSubCommand());
        MQAdminStartup.initCommand(new BrokerStatusSubCommand());
        MQAdminStartup.initCommand(new QueryMsgByIdSubCommand());
        MQAdminStartup.initCommand(new QueryMsgByKeySubCommand());
        MQAdminStartup.initCommand(new QueryMsgByUniqueKeySubCommand());
        MQAdminStartup.initCommand(new QueryMsgByOffsetSubCommand());
        MQAdminStartup.initCommand(new QueryMsgTraceByIdSubCommand());
        MQAdminStartup.initCommand(new PrintMessageSubCommand());
        MQAdminStartup.initCommand(new PrintMessageByQueueCommand());
        MQAdminStartup.initCommand(new SendMsgStatusCommand());
        MQAdminStartup.initCommand(new BrokerConsumeStatsSubCommad());
        MQAdminStartup.initCommand(new ProducerConnectionSubCommand());
        MQAdminStartup.initCommand(new ConsumerConnectionSubCommand());
        MQAdminStartup.initCommand(new ConsumerProgressSubCommand());
        MQAdminStartup.initCommand(new ConsumerStatusSubCommand());
        MQAdminStartup.initCommand(new CloneGroupOffsetCommand());
        MQAdminStartup.initCommand(new ProducerSubCommand());
        MQAdminStartup.initCommand(new ClusterListSubCommand());
        MQAdminStartup.initCommand(new TopicListSubCommand());
        MQAdminStartup.initCommand(new UpdateKvConfigCommand());
        MQAdminStartup.initCommand(new DeleteKvConfigCommand());
        MQAdminStartup.initCommand(new WipeWritePermSubCommand());
        MQAdminStartup.initCommand(new AddWritePermSubCommand());
        MQAdminStartup.initCommand(new ResetOffsetByTimeCommand());
        MQAdminStartup.initCommand(new SkipAccumulationSubCommand());
        MQAdminStartup.initCommand(new UpdateOrderConfCommand());
        MQAdminStartup.initCommand(new CleanExpiredCQSubCommand());
        MQAdminStartup.initCommand(new DeleteExpiredCommitLogSubCommand());
        MQAdminStartup.initCommand(new CleanUnusedTopicCommand());
        MQAdminStartup.initCommand(new StartMonitoringSubCommand());
        MQAdminStartup.initCommand(new StatsAllSubCommand());
        MQAdminStartup.initCommand(new AllocateMQSubCommand());
        MQAdminStartup.initCommand(new CheckMsgSendRTCommand());
        MQAdminStartup.initCommand(new CLusterSendMsgRTCommand());
        MQAdminStartup.initCommand(new GetNamesrvConfigCommand());
        MQAdminStartup.initCommand(new UpdateNamesrvConfigCommand());
        MQAdminStartup.initCommand(new GetBrokerConfigCommand());
        MQAdminStartup.initCommand(new GetConsumerConfigSubCommand());
        MQAdminStartup.initCommand(new QueryConsumeQueueCommand());
        MQAdminStartup.initCommand(new SendMessageCommand());
        MQAdminStartup.initCommand(new ConsumeMessageCommand());
        MQAdminStartup.initCommand(new UpdateAccessConfigSubCommand());
        MQAdminStartup.initCommand(new DeleteAccessConfigSubCommand());
        MQAdminStartup.initCommand(new ClusterAclConfigVersionListSubCommand());
        MQAdminStartup.initCommand(new UpdateGlobalWhiteAddrSubCommand());
        MQAdminStartup.initCommand(new GetAccessConfigSubCommand());
        MQAdminStartup.initCommand(new UpdateStaticTopicSubCommand());
        MQAdminStartup.initCommand(new RemappingStaticTopicSubCommand());
        MQAdminStartup.initCommand(new ExportMetadataCommand());
        MQAdminStartup.initCommand(new ExportConfigsCommand());
        MQAdminStartup.initCommand(new ExportMetricsCommand());
        MQAdminStartup.initCommand(new ExportMetadataInRocksDBCommand());
        MQAdminStartup.initCommand(new HAStatusSubCommand());
        MQAdminStartup.initCommand(new GetSyncStateSetSubCommand());
        MQAdminStartup.initCommand(new GetBrokerEpochSubCommand());
        MQAdminStartup.initCommand(new GetControllerMetaDataSubCommand());
        MQAdminStartup.initCommand(new GetControllerConfigSubCommand());
        MQAdminStartup.initCommand(new UpdateControllerConfigSubCommand());
        MQAdminStartup.initCommand(new ReElectMasterSubCommand());
        MQAdminStartup.initCommand(new CleanControllerBrokerMetaSubCommand());
        MQAdminStartup.initCommand(new DumpCompactionLogCommand());
        MQAdminStartup.initCommand(new GetColdDataFlowCtrInfoSubCommand());
        MQAdminStartup.initCommand(new UpdateColdDataFlowCtrGroupConfigSubCommand());
        MQAdminStartup.initCommand(new RemoveColdDataFlowCtrGroupConfigSubCommand());
        MQAdminStartup.initCommand(new CommitLogSetReadAheadSubCommand());
    }

    private static void printHelp() {
        System.out.printf("The most commonly used mqadmin commands are:%n", new Object[0]);
        for (SubCommand cmd : SUB_COMMANDS) {
            System.out.printf("   %-35s %s%n", cmd.commandName(), cmd.commandDesc());
        }
        System.out.printf("%nSee 'mqadmin help <command>' for more information on a specific command.%n", new Object[0]);
    }

    private static SubCommand findSubCommand(String name) {
        for (SubCommand cmd : SUB_COMMANDS) {
            if (!cmd.commandName().equalsIgnoreCase(name) && (cmd.commandAlias() == null || !cmd.commandAlias().equalsIgnoreCase(name))) continue;
            return cmd;
        }
        return null;
    }

    private static String[] parseSubArgs(String[] args) {
        if (args.length > 1) {
            String[] result = new String[args.length - 1];
            for (int i = 0; i < args.length - 1; ++i) {
                result[i] = args[i + 1];
            }
            return result;
        }
        return null;
    }

    public static void initCommand(SubCommand command) {
        SUB_COMMANDS.add(command);
    }
}

