/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.w3c.domts.DOMTest.load;


/**
 * The "hasAttributeNS()" method for an Element should
 * return true if the element has an attribute with the given local name
 * and the namespace URI is specified on this element or has a default value.
 * <p>
 * Retrieve the first "address" element and the "hasAttributeNS()" method
 * should return true since the element has "domestic" as the local name
 * and "http://www.usa.com" as the namespace URI.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElHasAttrNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElHasAttrNS</a>
 */
public class hasAttributeNS05 {
    @Test
    void testRun() throws Throwable {
        String localName = "domestic";
        String namespaceURI = "http://www.usa.com";
        Document doc = load("staffNS", false);
        NodeList elementList = doc.getElementsByTagName("address");
        Element testNode = (Element) elementList.item(0);
        boolean state = testNode.hasAttributeNS(namespaceURI, localName);
        assertTrue(state, "hasAttribute");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/hasAttributeNS05";
    }

}
