/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.plc4x.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class Plc4xConnectRequest extends Plc4xMessage implements Message {

  // Accessors for discriminator values.
  public Plc4xRequestType getRequestType() {
    return Plc4xRequestType.CONNECT_REQUEST;
  }

  // Properties.
  protected final String connectionString;

  public Plc4xConnectRequest(int requestId, String connectionString) {
    super(requestId);
    this.connectionString = connectionString;
  }

  public String getConnectionString() {
    return connectionString;
  }

  @Override
  protected void serializePlc4xMessageChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("Plc4xConnectRequest");

    // Implicit Field (connectionStringLen) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    short connectionStringLen = (short) (STR_LEN(getConnectionString()));
    writeImplicitField(
        "connectionStringLen",
        connectionStringLen,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (connectionString)
    writeSimpleField(
        "connectionString",
        connectionString,
        writeString(writeBuffer, (connectionStringLen) * (8)),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("Plc4xConnectRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    Plc4xConnectRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Implicit Field (connectionStringLen)
    lengthInBits += 8;

    // Simple field (connectionString)
    lengthInBits += (STR_LEN(getConnectionString())) * (8);

    return lengthInBits;
  }

  public static Plc4xMessageBuilder staticParsePlc4xMessageBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("Plc4xConnectRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short connectionStringLen =
        readImplicitField(
            "connectionStringLen",
            readUnsignedShort(readBuffer, 8),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    String connectionString =
        readSimpleField(
            "connectionString",
            readString(readBuffer, (connectionStringLen) * (8)),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("Plc4xConnectRequest");
    // Create the instance
    return new Plc4xConnectRequestBuilderImpl(connectionString);
  }

  public static class Plc4xConnectRequestBuilderImpl implements Plc4xMessage.Plc4xMessageBuilder {
    private final String connectionString;

    public Plc4xConnectRequestBuilderImpl(String connectionString) {
      this.connectionString = connectionString;
    }

    public Plc4xConnectRequest build(int requestId) {
      Plc4xConnectRequest plc4xConnectRequest =
          new Plc4xConnectRequest(requestId, connectionString);
      return plc4xConnectRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof Plc4xConnectRequest)) {
      return false;
    }
    Plc4xConnectRequest that = (Plc4xConnectRequest) o;
    return (getConnectionString() == that.getConnectionString()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getConnectionString());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
