/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum OpcuaNodeIdServicesVariableL {
  LLDP_RemoteStatistics_LastChangeTime((int) 18960L),
  LLDP_RemoteStatistics_RemoteInserts((int) 18961L),
  LLDP_RemoteStatistics_RemoteDeletes((int) 18962L),
  LLDP_RemoteStatistics_RemoteDrops((int) 18963L),
  LLDP_RemoteStatistics_RemoteAgeouts((int) 18964L),
  LLDP_LocalSystemData_ChassisIdSubtype((int) 18966L),
  LLDP_LocalSystemData_ChassisId((int) 18967L),
  LLDP_LocalSystemData_SystemName((int) 18968L),
  LLDP_LocalSystemData_SystemDescription((int) 18969L),
  LLDP_LocalSystemData_SystemCapabilitiesSupported((int) 18970L),
  LLDP_LocalSystemData_SystemCapabilitiesEnabled((int) 18971L);
  private static final Map<Integer, OpcuaNodeIdServicesVariableL> map;

  static {
    map = new HashMap<>();
    for (OpcuaNodeIdServicesVariableL value : OpcuaNodeIdServicesVariableL.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  OpcuaNodeIdServicesVariableL(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static OpcuaNodeIdServicesVariableL enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
