/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum AttributeId {
  NodeId((long) 1L),
  NodeClass((long) 2L),
  BrowseName((long) 3L),
  DisplayName((long) 4L),
  Description((long) 5L),
  WriteMask((long) 6L),
  UserWriteMask((long) 7L),
  IsAbstract((long) 8L),
  Symmetric((long) 9L),
  InverseName((long) 10L),
  ContainsNoLoops((long) 11L),
  EventNotifier((long) 12L),
  Value((long) 13L),
  DataType((long) 14L),
  ValueRank((long) 15L),
  ArrayDimensions((long) 16L),
  AccessLevel((long) 17L),
  UserAccessLevel((long) 18L),
  MinimumSamplingInterval((long) 19L),
  Historizing((long) 20L),
  Executable((long) 21L),
  UserExecutable((long) 22L),
  DataTypeDefinition((long) 23L),
  RolePermissions((long) 24L),
  UserRolePermissions((long) 25L),
  AccessRestrictions((long) 26L),
  AccessLevelEx((long) 27L);
  private static final Map<Long, AttributeId> map;

  static {
    map = new HashMap<>();
    for (AttributeId value : AttributeId.values()) {
      map.put((long) value.getValue(), value);
    }
  }

  private final long value;

  AttributeId(long value) {
    this.value = value;
  }

  public long getValue() {
    return value;
  }

  public static AttributeId enumForValue(long value) {
    return map.get(value);
  }

  public static Boolean isDefined(long value) {
    return map.containsKey(value);
  }
}
