/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.iec608705104.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class InformationObjectWithoutTime extends InformationObject implements Message {

  // Accessors for discriminator values.
  public Byte getNumTimeByte() {
    return (byte) 0;
  }

  // Abstract accessors for discriminator values.
  public abstract TypeIdentification getTypeIdentification();

  public InformationObjectWithoutTime(int address) {
    super(address);
  }

  protected abstract void serializeInformationObjectWithoutTimeChild(WriteBuffer writeBuffer)
      throws SerializationException;

  @Override
  protected void serializeInformationObjectChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("InformationObjectWithoutTime");

    // Switch field (Serialize the sub-type)
    serializeInformationObjectWithoutTimeChild(writeBuffer);

    writeBuffer.popContext("InformationObjectWithoutTime");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    InformationObjectWithoutTime _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static InformationObjectBuilder staticParseInformationObjectBuilder(
      ReadBuffer readBuffer, TypeIdentification typeIdentification, Byte numTimeByte)
      throws ParseException {
    readBuffer.pullContext("InformationObjectWithoutTime");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    InformationObjectWithoutTimeBuilder builder = null;
    if (EvaluationHelper.equals(typeIdentification, TypeIdentification.SINGLE_POINT_INFORMATION)) {
      builder =
          InformationObjectWithoutTime_SINGLE_POINT_INFORMATION
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.DOUBLE_POINT_INFORMATION)) {
      builder =
          InformationObjectWithoutTime_DOUBLE_POINT_INFORMATION
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.STEP_POSITION_INFORMATION)) {
      builder =
          InformationObjectWithoutTime_STEP_POSITION_INFORMATION
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.BITSTRING_OF_32_BIT)) {
      builder =
          InformationObjectWithoutTime_BITSTRING_OF_32_BIT
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.MEASURED_VALUE_NORMALISED_VALUE)) {
      builder =
          InformationObjectWithoutTime_MEASURED_VALUE_NORMALISED_VALUE
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.MEASURED_VALUE_SCALED_VALUE)) {
      builder =
          InformationObjectWithoutTime_MEASURED_VALUE_SCALED_VALUE
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER)) {
      builder =
          InformationObjectWithoutTime_MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(typeIdentification, TypeIdentification.INTEGRATED_TOTALS)) {
      builder =
          InformationObjectWithoutTime_INTEGRATED_TOTALS
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification,
        TypeIdentification.PACKED_SINGLE_POINT_INFORMATION_WITH_STATUS_CHANGE_DETECTION)) {
      builder =
          InformationObjectWithoutTime_PACKED_SINGLE_POINT_INFORMATION_WITH_STATUS_CHANGE_DETECTION
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification,
        TypeIdentification.MEASURED_VALUE_NORMALIZED_VALUE_WITHOUT_QUALITY_DESCRIPTOR)) {
      builder =
          InformationObjectWithoutTime_MEASURED_VALUE_NORMALIZED_VALUE_WITHOUT_QUALITY_DESCRIPTOR
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(typeIdentification, TypeIdentification.SINGLE_COMMAND)) {
      builder =
          InformationObjectWithoutTime_SINGLE_COMMAND
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(typeIdentification, TypeIdentification.DOUBLE_COMMAND)) {
      builder =
          InformationObjectWithoutTime_DOUBLE_COMMAND
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.REGULATING_STEP_COMMAND)) {
      builder =
          InformationObjectWithoutTime_REGULATING_STEP_COMMAND
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.SET_POINT_COMMAND_NORMALISED_VALUE)) {
      builder =
          InformationObjectWithoutTime_SET_POINT_COMMAND_NORMALISED_VALUE
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.SET_POINT_COMMAND_SCALED_VALUE)) {
      builder =
          InformationObjectWithoutTime_SET_POINT_COMMAND_SCALED_VALUE
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.SET_POINT_COMMAND_SHORT_FLOATING_POINT_NUMBER)) {
      builder =
          InformationObjectWithoutTime_SET_POINT_COMMAND_SHORT_FLOATING_POINT_NUMBER
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.BITSTRING_32_BIT_COMMAND)) {
      builder =
          InformationObjectWithoutTime_BITSTRING_32_BIT_COMMAND
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.END_OF_INITIALISATION)) {
      builder =
          InformationObjectWithoutTime_END_OF_INITIALISATION
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.INTERROGATION_COMMAND)) {
      builder =
          InformationObjectWithoutTime_INTERROGATION_COMMAND
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.COUNTER_INTERROGATION_COMMAND)) {
      builder =
          InformationObjectWithoutTime_COUNTER_INTERROGATION_COMMAND
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(typeIdentification, TypeIdentification.READ_COMMAND)) {
      builder =
          InformationObjectWithoutTime_READ_COMMAND.staticParseInformationObjectWithoutTimeBuilder(
              readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.CLOCK_SYNCHRONISATION_COMMAND)) {
      builder =
          InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMAND
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(typeIdentification, TypeIdentification.TEST_COMMAND)) {
      builder =
          InformationObjectWithoutTime_TEST_COMMAND.staticParseInformationObjectWithoutTimeBuilder(
              readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.RESET_PROCESS_COMMAND)) {
      builder =
          InformationObjectWithoutTime_RESET_PROCESS_COMMAND
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.DELAY_ACQUISITION_COMMAND)) {
      builder =
          InformationObjectWithoutTime_DELAY_ACQUISITION_COMMAND
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.PARAMETER_OF_MEASURED_VALUES_NORMALIZED_VALUE)) {
      builder =
          InformationObjectWithoutTime_PARAMETER_OF_MEASURED_VALUES_NORMALIZED_VALUE
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.PARAMETER_OF_MEASURED_VALUES_SCALED_VALUE)) {
      builder =
          InformationObjectWithoutTime_PARAMETER_OF_MEASURED_VALUES_SCALED_VALUE
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification,
        TypeIdentification.PARAMETER_OF_MEASURED_VALUES_SHORT_FLOATING_POINT_NUMBER)) {
      builder =
          InformationObjectWithoutTime_PARAMETER_OF_MEASURED_VALUES_SHORT_FLOATING_POINT_NUMBER
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.PARAMETER_ACTIVATION)) {
      builder =
          InformationObjectWithoutTime_PARAMETER_ACTIVATION
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(typeIdentification, TypeIdentification.FILE_READY)) {
      builder =
          InformationObjectWithoutTime_FILE_READY.staticParseInformationObjectWithoutTimeBuilder(
              readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(typeIdentification, TypeIdentification.SECTION_READY)) {
      builder =
          InformationObjectWithoutTime_SECTION_READY.staticParseInformationObjectWithoutTimeBuilder(
              readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.CALL_DIRECTORY_SELECT_FILE_CALL_FILE_CALL_SECTION)) {
      builder =
          InformationObjectWithoutTime_CALL_DIRECTORY_SELECT_FILE_CALL_FILE_CALL_SECTION
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.LAST_SECTION_LAST_SEGMENT)) {
      builder =
          InformationObjectWithoutTime_LAST_SECTION_LAST_SEGMENT
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.ACK_FILE_ACK_SECTION)) {
      builder =
          InformationObjectWithoutTime_ACK_FILE_ACK_SECTION
              .staticParseInformationObjectWithoutTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(typeIdentification, TypeIdentification.SEGMENT)) {
      builder =
          InformationObjectWithoutTime_SEGMENT.staticParseInformationObjectWithoutTimeBuilder(
              readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(typeIdentification, TypeIdentification.DIRECTORY)) {
      builder =
          InformationObjectWithoutTime_DIRECTORY.staticParseInformationObjectWithoutTimeBuilder(
              readBuffer, typeIdentification, numTimeByte);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "typeIdentification="
              + typeIdentification
              + "]");
    }

    readBuffer.closeContext("InformationObjectWithoutTime");
    // Create the instance
    return new InformationObjectWithoutTimeBuilderImpl(builder);
  }

  public interface InformationObjectWithoutTimeBuilder {
    InformationObjectWithoutTime build(int address);
  }

  public static class InformationObjectWithoutTimeBuilderImpl
      implements InformationObject.InformationObjectBuilder {
    private final InformationObjectWithoutTimeBuilder builder;

    public InformationObjectWithoutTimeBuilderImpl(InformationObjectWithoutTimeBuilder builder) {
      this.builder = builder;
    }

    public InformationObjectWithoutTime build(int address) {
      return builder.build(address);
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof InformationObjectWithoutTime)) {
      return false;
    }
    InformationObjectWithoutTime that = (InformationObjectWithoutTime) o;
    return super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
