/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ModelChangeStructureDataType is the corresponding interface of ModelChangeStructureDataType
type ModelChangeStructureDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetAffected returns Affected (property field)
	GetAffected() NodeId
	// GetAffectedType returns AffectedType (property field)
	GetAffectedType() NodeId
	// GetVerb returns Verb (property field)
	GetVerb() uint8
	// IsModelChangeStructureDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsModelChangeStructureDataType()
	// CreateBuilder creates a ModelChangeStructureDataTypeBuilder
	CreateModelChangeStructureDataTypeBuilder() ModelChangeStructureDataTypeBuilder
}

// _ModelChangeStructureDataType is the data-structure of this message
type _ModelChangeStructureDataType struct {
	ExtensionObjectDefinitionContract
	Affected     NodeId
	AffectedType NodeId
	Verb         uint8
}

var _ ModelChangeStructureDataType = (*_ModelChangeStructureDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_ModelChangeStructureDataType)(nil)

// NewModelChangeStructureDataType factory function for _ModelChangeStructureDataType
func NewModelChangeStructureDataType(affected NodeId, affectedType NodeId, verb uint8) *_ModelChangeStructureDataType {
	if affected == nil {
		panic("affected of type NodeId for ModelChangeStructureDataType must not be nil")
	}
	if affectedType == nil {
		panic("affectedType of type NodeId for ModelChangeStructureDataType must not be nil")
	}
	_result := &_ModelChangeStructureDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		Affected:                          affected,
		AffectedType:                      affectedType,
		Verb:                              verb,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ModelChangeStructureDataTypeBuilder is a builder for ModelChangeStructureDataType
type ModelChangeStructureDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(affected NodeId, affectedType NodeId, verb uint8) ModelChangeStructureDataTypeBuilder
	// WithAffected adds Affected (property field)
	WithAffected(NodeId) ModelChangeStructureDataTypeBuilder
	// WithAffectedBuilder adds Affected (property field) which is build by the builder
	WithAffectedBuilder(func(NodeIdBuilder) NodeIdBuilder) ModelChangeStructureDataTypeBuilder
	// WithAffectedType adds AffectedType (property field)
	WithAffectedType(NodeId) ModelChangeStructureDataTypeBuilder
	// WithAffectedTypeBuilder adds AffectedType (property field) which is build by the builder
	WithAffectedTypeBuilder(func(NodeIdBuilder) NodeIdBuilder) ModelChangeStructureDataTypeBuilder
	// WithVerb adds Verb (property field)
	WithVerb(uint8) ModelChangeStructureDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the ModelChangeStructureDataType or returns an error if something is wrong
	Build() (ModelChangeStructureDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ModelChangeStructureDataType
}

// NewModelChangeStructureDataTypeBuilder() creates a ModelChangeStructureDataTypeBuilder
func NewModelChangeStructureDataTypeBuilder() ModelChangeStructureDataTypeBuilder {
	return &_ModelChangeStructureDataTypeBuilder{_ModelChangeStructureDataType: new(_ModelChangeStructureDataType)}
}

type _ModelChangeStructureDataTypeBuilder struct {
	*_ModelChangeStructureDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (ModelChangeStructureDataTypeBuilder) = (*_ModelChangeStructureDataTypeBuilder)(nil)

func (b *_ModelChangeStructureDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._ModelChangeStructureDataType
}

func (b *_ModelChangeStructureDataTypeBuilder) WithMandatoryFields(affected NodeId, affectedType NodeId, verb uint8) ModelChangeStructureDataTypeBuilder {
	return b.WithAffected(affected).WithAffectedType(affectedType).WithVerb(verb)
}

func (b *_ModelChangeStructureDataTypeBuilder) WithAffected(affected NodeId) ModelChangeStructureDataTypeBuilder {
	b.Affected = affected
	return b
}

func (b *_ModelChangeStructureDataTypeBuilder) WithAffectedBuilder(builderSupplier func(NodeIdBuilder) NodeIdBuilder) ModelChangeStructureDataTypeBuilder {
	builder := builderSupplier(b.Affected.CreateNodeIdBuilder())
	var err error
	b.Affected, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "NodeIdBuilder failed"))
	}
	return b
}

func (b *_ModelChangeStructureDataTypeBuilder) WithAffectedType(affectedType NodeId) ModelChangeStructureDataTypeBuilder {
	b.AffectedType = affectedType
	return b
}

func (b *_ModelChangeStructureDataTypeBuilder) WithAffectedTypeBuilder(builderSupplier func(NodeIdBuilder) NodeIdBuilder) ModelChangeStructureDataTypeBuilder {
	builder := builderSupplier(b.AffectedType.CreateNodeIdBuilder())
	var err error
	b.AffectedType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "NodeIdBuilder failed"))
	}
	return b
}

func (b *_ModelChangeStructureDataTypeBuilder) WithVerb(verb uint8) ModelChangeStructureDataTypeBuilder {
	b.Verb = verb
	return b
}

func (b *_ModelChangeStructureDataTypeBuilder) Build() (ModelChangeStructureDataType, error) {
	if b.Affected == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'affected' not set"))
	}
	if b.AffectedType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'affectedType' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ModelChangeStructureDataType.deepCopy(), nil
}

func (b *_ModelChangeStructureDataTypeBuilder) MustBuild() ModelChangeStructureDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ModelChangeStructureDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_ModelChangeStructureDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_ModelChangeStructureDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateModelChangeStructureDataTypeBuilder().(*_ModelChangeStructureDataTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateModelChangeStructureDataTypeBuilder creates a ModelChangeStructureDataTypeBuilder
func (b *_ModelChangeStructureDataType) CreateModelChangeStructureDataTypeBuilder() ModelChangeStructureDataTypeBuilder {
	if b == nil {
		return NewModelChangeStructureDataTypeBuilder()
	}
	return &_ModelChangeStructureDataTypeBuilder{_ModelChangeStructureDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ModelChangeStructureDataType) GetExtensionId() int32 {
	return int32(879)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ModelChangeStructureDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ModelChangeStructureDataType) GetAffected() NodeId {
	return m.Affected
}

func (m *_ModelChangeStructureDataType) GetAffectedType() NodeId {
	return m.AffectedType
}

func (m *_ModelChangeStructureDataType) GetVerb() uint8 {
	return m.Verb
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastModelChangeStructureDataType(structType any) ModelChangeStructureDataType {
	if casted, ok := structType.(ModelChangeStructureDataType); ok {
		return casted
	}
	if casted, ok := structType.(*ModelChangeStructureDataType); ok {
		return *casted
	}
	return nil
}

func (m *_ModelChangeStructureDataType) GetTypeName() string {
	return "ModelChangeStructureDataType"
}

func (m *_ModelChangeStructureDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (affected)
	lengthInBits += m.Affected.GetLengthInBits(ctx)

	// Simple field (affectedType)
	lengthInBits += m.AffectedType.GetLengthInBits(ctx)

	// Simple field (verb)
	lengthInBits += 8

	return lengthInBits
}

func (m *_ModelChangeStructureDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ModelChangeStructureDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__modelChangeStructureDataType ModelChangeStructureDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ModelChangeStructureDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ModelChangeStructureDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	affected, err := ReadSimpleField[NodeId](ctx, "affected", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'affected' field"))
	}
	m.Affected = affected

	affectedType, err := ReadSimpleField[NodeId](ctx, "affectedType", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'affectedType' field"))
	}
	m.AffectedType = affectedType

	verb, err := ReadSimpleField(ctx, "verb", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'verb' field"))
	}
	m.Verb = verb

	if closeErr := readBuffer.CloseContext("ModelChangeStructureDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ModelChangeStructureDataType")
	}

	return m, nil
}

func (m *_ModelChangeStructureDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ModelChangeStructureDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ModelChangeStructureDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ModelChangeStructureDataType")
		}

		if err := WriteSimpleField[NodeId](ctx, "affected", m.GetAffected(), WriteComplex[NodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'affected' field")
		}

		if err := WriteSimpleField[NodeId](ctx, "affectedType", m.GetAffectedType(), WriteComplex[NodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'affectedType' field")
		}

		if err := WriteSimpleField[uint8](ctx, "verb", m.GetVerb(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'verb' field")
		}

		if popErr := writeBuffer.PopContext("ModelChangeStructureDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ModelChangeStructureDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ModelChangeStructureDataType) IsModelChangeStructureDataType() {}

func (m *_ModelChangeStructureDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ModelChangeStructureDataType) deepCopy() *_ModelChangeStructureDataType {
	if m == nil {
		return nil
	}
	_ModelChangeStructureDataTypeCopy := &_ModelChangeStructureDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[NodeId](m.Affected),
		utils.DeepCopy[NodeId](m.AffectedType),
		m.Verb,
	}
	_ModelChangeStructureDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _ModelChangeStructureDataTypeCopy
}

func (m *_ModelChangeStructureDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
