/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetEscalatorModeTagged is the corresponding interface of BACnetEscalatorModeTagged
type BACnetEscalatorModeTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetEscalatorMode
	// GetProprietaryValue returns ProprietaryValue (property field)
	GetProprietaryValue() uint32
	// GetIsProprietary returns IsProprietary (virtual field)
	GetIsProprietary() bool
	// IsBACnetEscalatorModeTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetEscalatorModeTagged()
	// CreateBuilder creates a BACnetEscalatorModeTaggedBuilder
	CreateBACnetEscalatorModeTaggedBuilder() BACnetEscalatorModeTaggedBuilder
}

// _BACnetEscalatorModeTagged is the data-structure of this message
type _BACnetEscalatorModeTagged struct {
	Header           BACnetTagHeader
	Value            BACnetEscalatorMode
	ProprietaryValue uint32

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetEscalatorModeTagged = (*_BACnetEscalatorModeTagged)(nil)

// NewBACnetEscalatorModeTagged factory function for _BACnetEscalatorModeTagged
func NewBACnetEscalatorModeTagged(header BACnetTagHeader, value BACnetEscalatorMode, proprietaryValue uint32, tagNumber uint8, tagClass TagClass) *_BACnetEscalatorModeTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetEscalatorModeTagged must not be nil")
	}
	return &_BACnetEscalatorModeTagged{Header: header, Value: value, ProprietaryValue: proprietaryValue, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetEscalatorModeTaggedBuilder is a builder for BACnetEscalatorModeTagged
type BACnetEscalatorModeTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetEscalatorMode, proprietaryValue uint32) BACnetEscalatorModeTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetEscalatorModeTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetEscalatorModeTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetEscalatorMode) BACnetEscalatorModeTaggedBuilder
	// WithProprietaryValue adds ProprietaryValue (property field)
	WithProprietaryValue(uint32) BACnetEscalatorModeTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetEscalatorModeTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetEscalatorModeTaggedBuilder
	// Build builds the BACnetEscalatorModeTagged or returns an error if something is wrong
	Build() (BACnetEscalatorModeTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetEscalatorModeTagged
}

// NewBACnetEscalatorModeTaggedBuilder() creates a BACnetEscalatorModeTaggedBuilder
func NewBACnetEscalatorModeTaggedBuilder() BACnetEscalatorModeTaggedBuilder {
	return &_BACnetEscalatorModeTaggedBuilder{_BACnetEscalatorModeTagged: new(_BACnetEscalatorModeTagged)}
}

type _BACnetEscalatorModeTaggedBuilder struct {
	*_BACnetEscalatorModeTagged

	collectedErr []error
}

var _ (BACnetEscalatorModeTaggedBuilder) = (*_BACnetEscalatorModeTaggedBuilder)(nil)

func (b *_BACnetEscalatorModeTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetEscalatorMode, proprietaryValue uint32) BACnetEscalatorModeTaggedBuilder {
	return b.WithHeader(header).WithValue(value).WithProprietaryValue(proprietaryValue)
}

func (b *_BACnetEscalatorModeTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetEscalatorModeTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetEscalatorModeTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetEscalatorModeTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetEscalatorModeTaggedBuilder) WithValue(value BACnetEscalatorMode) BACnetEscalatorModeTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetEscalatorModeTaggedBuilder) WithProprietaryValue(proprietaryValue uint32) BACnetEscalatorModeTaggedBuilder {
	b.ProprietaryValue = proprietaryValue
	return b
}

func (b *_BACnetEscalatorModeTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetEscalatorModeTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetEscalatorModeTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetEscalatorModeTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetEscalatorModeTaggedBuilder) Build() (BACnetEscalatorModeTagged, error) {
	if b.Header == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'header' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetEscalatorModeTagged.deepCopy(), nil
}

func (b *_BACnetEscalatorModeTaggedBuilder) MustBuild() BACnetEscalatorModeTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetEscalatorModeTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetEscalatorModeTaggedBuilder().(*_BACnetEscalatorModeTaggedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetEscalatorModeTaggedBuilder creates a BACnetEscalatorModeTaggedBuilder
func (b *_BACnetEscalatorModeTagged) CreateBACnetEscalatorModeTaggedBuilder() BACnetEscalatorModeTaggedBuilder {
	if b == nil {
		return NewBACnetEscalatorModeTaggedBuilder()
	}
	return &_BACnetEscalatorModeTaggedBuilder{_BACnetEscalatorModeTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetEscalatorModeTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetEscalatorModeTagged) GetValue() BACnetEscalatorMode {
	return m.Value
}

func (m *_BACnetEscalatorModeTagged) GetProprietaryValue() uint32 {
	return m.ProprietaryValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetEscalatorModeTagged) GetIsProprietary() bool {
	ctx := context.Background()
	_ = ctx
	return bool(bool((m.GetValue()) == (BACnetEscalatorMode_VENDOR_PROPRIETARY_VALUE)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetEscalatorModeTagged(structType any) BACnetEscalatorModeTagged {
	if casted, ok := structType.(BACnetEscalatorModeTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetEscalatorModeTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetEscalatorModeTagged) GetTypeName() string {
	return "BACnetEscalatorModeTagged"
}

func (m *_BACnetEscalatorModeTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32(int32(0)) }, func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }).(int32))

	// A virtual field doesn't have any in- or output.

	// Manual Field (proprietaryValue)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }, func() any { return int32(int32(0)) }).(int32))

	return lengthInBits
}

func (m *_BACnetEscalatorModeTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetEscalatorModeTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetEscalatorModeTagged, error) {
	return BACnetEscalatorModeTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetEscalatorModeTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEscalatorModeTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEscalatorModeTagged, error) {
		return BACnetEscalatorModeTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetEscalatorModeTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetEscalatorModeTagged, error) {
	v, err := (&_BACnetEscalatorModeTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetEscalatorModeTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetEscalatorModeTagged BACnetEscalatorModeTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetEscalatorModeTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetEscalatorModeTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetEscalatorMode](ctx, "value", readBuffer, EnsureType[BACnetEscalatorMode](ReadEnumGeneric(ctx, readBuffer, header.GetActualLength(), BACnetEscalatorMode_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	isProprietary, err := ReadVirtualField[bool](ctx, "isProprietary", (*bool)(nil), bool((value) == (BACnetEscalatorMode_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isProprietary' field"))
	}
	_ = isProprietary

	proprietaryValue, err := ReadManualField[uint32](ctx, "proprietaryValue", readBuffer, EnsureType[uint32](ReadProprietaryEnumGeneric(ctx, readBuffer, header.GetActualLength(), isProprietary)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'proprietaryValue' field"))
	}
	m.ProprietaryValue = proprietaryValue

	if closeErr := readBuffer.CloseContext("BACnetEscalatorModeTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetEscalatorModeTagged")
	}

	return m, nil
}

func (m *_BACnetEscalatorModeTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetEscalatorModeTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetEscalatorModeTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetEscalatorModeTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetEscalatorMode](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}
	// Virtual field
	isProprietary := m.GetIsProprietary()
	_ = isProprietary
	if _isProprietaryErr := writeBuffer.WriteVirtual(ctx, "isProprietary", m.GetIsProprietary()); _isProprietaryErr != nil {
		return errors.Wrap(_isProprietaryErr, "Error serializing 'isProprietary' field")
	}

	if err := WriteManualField[uint32](ctx, "proprietaryValue", func(ctx context.Context) error {
		return WriteProprietaryEnumGeneric(ctx, writeBuffer, m.GetProprietaryValue(), m.GetIsProprietary())
	}, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'proprietaryValue' field")
	}

	if popErr := writeBuffer.PopContext("BACnetEscalatorModeTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetEscalatorModeTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetEscalatorModeTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetEscalatorModeTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetEscalatorModeTagged) IsBACnetEscalatorModeTagged() {}

func (m *_BACnetEscalatorModeTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetEscalatorModeTagged) deepCopy() *_BACnetEscalatorModeTagged {
	if m == nil {
		return nil
	}
	_BACnetEscalatorModeTaggedCopy := &_BACnetEscalatorModeTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.ProprietaryValue,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetEscalatorModeTaggedCopy
}

func (m *_BACnetEscalatorModeTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
