/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataNumberOfAuthenticationPolicies is the corresponding interface of BACnetConstructedDataNumberOfAuthenticationPolicies
type BACnetConstructedDataNumberOfAuthenticationPolicies interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetNumberOfAuthenticationPolicies returns NumberOfAuthenticationPolicies (property field)
	GetNumberOfAuthenticationPolicies() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataNumberOfAuthenticationPolicies is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataNumberOfAuthenticationPolicies()
	// CreateBuilder creates a BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder
	CreateBACnetConstructedDataNumberOfAuthenticationPoliciesBuilder() BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder
}

// _BACnetConstructedDataNumberOfAuthenticationPolicies is the data-structure of this message
type _BACnetConstructedDataNumberOfAuthenticationPolicies struct {
	BACnetConstructedDataContract
	NumberOfAuthenticationPolicies BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataNumberOfAuthenticationPolicies = (*_BACnetConstructedDataNumberOfAuthenticationPolicies)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataNumberOfAuthenticationPolicies)(nil)

// NewBACnetConstructedDataNumberOfAuthenticationPolicies factory function for _BACnetConstructedDataNumberOfAuthenticationPolicies
func NewBACnetConstructedDataNumberOfAuthenticationPolicies(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, numberOfAuthenticationPolicies BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataNumberOfAuthenticationPolicies {
	if numberOfAuthenticationPolicies == nil {
		panic("numberOfAuthenticationPolicies of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataNumberOfAuthenticationPolicies must not be nil")
	}
	_result := &_BACnetConstructedDataNumberOfAuthenticationPolicies{
		BACnetConstructedDataContract:  NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		NumberOfAuthenticationPolicies: numberOfAuthenticationPolicies,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder is a builder for BACnetConstructedDataNumberOfAuthenticationPolicies
type BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(numberOfAuthenticationPolicies BACnetApplicationTagUnsignedInteger) BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder
	// WithNumberOfAuthenticationPolicies adds NumberOfAuthenticationPolicies (property field)
	WithNumberOfAuthenticationPolicies(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder
	// WithNumberOfAuthenticationPoliciesBuilder adds NumberOfAuthenticationPolicies (property field) which is build by the builder
	WithNumberOfAuthenticationPoliciesBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataNumberOfAuthenticationPolicies or returns an error if something is wrong
	Build() (BACnetConstructedDataNumberOfAuthenticationPolicies, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataNumberOfAuthenticationPolicies
}

// NewBACnetConstructedDataNumberOfAuthenticationPoliciesBuilder() creates a BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder
func NewBACnetConstructedDataNumberOfAuthenticationPoliciesBuilder() BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder {
	return &_BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder{_BACnetConstructedDataNumberOfAuthenticationPolicies: new(_BACnetConstructedDataNumberOfAuthenticationPolicies)}
}

type _BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder struct {
	*_BACnetConstructedDataNumberOfAuthenticationPolicies

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder) = (*_BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder)(nil)

func (b *_BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataNumberOfAuthenticationPolicies
}

func (b *_BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder) WithMandatoryFields(numberOfAuthenticationPolicies BACnetApplicationTagUnsignedInteger) BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder {
	return b.WithNumberOfAuthenticationPolicies(numberOfAuthenticationPolicies)
}

func (b *_BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder) WithNumberOfAuthenticationPolicies(numberOfAuthenticationPolicies BACnetApplicationTagUnsignedInteger) BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder {
	b.NumberOfAuthenticationPolicies = numberOfAuthenticationPolicies
	return b
}

func (b *_BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder) WithNumberOfAuthenticationPoliciesBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder {
	builder := builderSupplier(b.NumberOfAuthenticationPolicies.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.NumberOfAuthenticationPolicies, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder) Build() (BACnetConstructedDataNumberOfAuthenticationPolicies, error) {
	if b.NumberOfAuthenticationPolicies == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'numberOfAuthenticationPolicies' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataNumberOfAuthenticationPolicies.deepCopy(), nil
}

func (b *_BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder) MustBuild() BACnetConstructedDataNumberOfAuthenticationPolicies {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataNumberOfAuthenticationPoliciesBuilder().(*_BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataNumberOfAuthenticationPoliciesBuilder creates a BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder
func (b *_BACnetConstructedDataNumberOfAuthenticationPolicies) CreateBACnetConstructedDataNumberOfAuthenticationPoliciesBuilder() BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder {
	if b == nil {
		return NewBACnetConstructedDataNumberOfAuthenticationPoliciesBuilder()
	}
	return &_BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder{_BACnetConstructedDataNumberOfAuthenticationPolicies: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataNumberOfAuthenticationPolicies) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataNumberOfAuthenticationPolicies) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_NUMBER_OF_AUTHENTICATION_POLICIES
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataNumberOfAuthenticationPolicies) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataNumberOfAuthenticationPolicies) GetNumberOfAuthenticationPolicies() BACnetApplicationTagUnsignedInteger {
	return m.NumberOfAuthenticationPolicies
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataNumberOfAuthenticationPolicies) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetNumberOfAuthenticationPolicies())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataNumberOfAuthenticationPolicies(structType any) BACnetConstructedDataNumberOfAuthenticationPolicies {
	if casted, ok := structType.(BACnetConstructedDataNumberOfAuthenticationPolicies); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataNumberOfAuthenticationPolicies); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataNumberOfAuthenticationPolicies) GetTypeName() string {
	return "BACnetConstructedDataNumberOfAuthenticationPolicies"
}

func (m *_BACnetConstructedDataNumberOfAuthenticationPolicies) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (numberOfAuthenticationPolicies)
	lengthInBits += m.NumberOfAuthenticationPolicies.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataNumberOfAuthenticationPolicies) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataNumberOfAuthenticationPolicies) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataNumberOfAuthenticationPolicies BACnetConstructedDataNumberOfAuthenticationPolicies, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataNumberOfAuthenticationPolicies"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataNumberOfAuthenticationPolicies")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	numberOfAuthenticationPolicies, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "numberOfAuthenticationPolicies", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'numberOfAuthenticationPolicies' field"))
	}
	m.NumberOfAuthenticationPolicies = numberOfAuthenticationPolicies

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), numberOfAuthenticationPolicies)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataNumberOfAuthenticationPolicies"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataNumberOfAuthenticationPolicies")
	}

	return m, nil
}

func (m *_BACnetConstructedDataNumberOfAuthenticationPolicies) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataNumberOfAuthenticationPolicies) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataNumberOfAuthenticationPolicies"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataNumberOfAuthenticationPolicies")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "numberOfAuthenticationPolicies", m.GetNumberOfAuthenticationPolicies(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'numberOfAuthenticationPolicies' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataNumberOfAuthenticationPolicies"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataNumberOfAuthenticationPolicies")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataNumberOfAuthenticationPolicies) IsBACnetConstructedDataNumberOfAuthenticationPolicies() {
}

func (m *_BACnetConstructedDataNumberOfAuthenticationPolicies) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataNumberOfAuthenticationPolicies) deepCopy() *_BACnetConstructedDataNumberOfAuthenticationPolicies {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataNumberOfAuthenticationPoliciesCopy := &_BACnetConstructedDataNumberOfAuthenticationPolicies{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.NumberOfAuthenticationPolicies),
	}
	_BACnetConstructedDataNumberOfAuthenticationPoliciesCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataNumberOfAuthenticationPoliciesCopy
}

func (m *_BACnetConstructedDataNumberOfAuthenticationPolicies) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
