/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataAckRequired is the corresponding interface of BACnetConstructedDataAckRequired
type BACnetConstructedDataAckRequired interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetAckRequired returns AckRequired (property field)
	GetAckRequired() BACnetEventTransitionBitsTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetEventTransitionBitsTagged
	// IsBACnetConstructedDataAckRequired is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataAckRequired()
	// CreateBuilder creates a BACnetConstructedDataAckRequiredBuilder
	CreateBACnetConstructedDataAckRequiredBuilder() BACnetConstructedDataAckRequiredBuilder
}

// _BACnetConstructedDataAckRequired is the data-structure of this message
type _BACnetConstructedDataAckRequired struct {
	BACnetConstructedDataContract
	AckRequired BACnetEventTransitionBitsTagged
}

var _ BACnetConstructedDataAckRequired = (*_BACnetConstructedDataAckRequired)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataAckRequired)(nil)

// NewBACnetConstructedDataAckRequired factory function for _BACnetConstructedDataAckRequired
func NewBACnetConstructedDataAckRequired(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, ackRequired BACnetEventTransitionBitsTagged, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataAckRequired {
	if ackRequired == nil {
		panic("ackRequired of type BACnetEventTransitionBitsTagged for BACnetConstructedDataAckRequired must not be nil")
	}
	_result := &_BACnetConstructedDataAckRequired{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		AckRequired:                   ackRequired,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataAckRequiredBuilder is a builder for BACnetConstructedDataAckRequired
type BACnetConstructedDataAckRequiredBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(ackRequired BACnetEventTransitionBitsTagged) BACnetConstructedDataAckRequiredBuilder
	// WithAckRequired adds AckRequired (property field)
	WithAckRequired(BACnetEventTransitionBitsTagged) BACnetConstructedDataAckRequiredBuilder
	// WithAckRequiredBuilder adds AckRequired (property field) which is build by the builder
	WithAckRequiredBuilder(func(BACnetEventTransitionBitsTaggedBuilder) BACnetEventTransitionBitsTaggedBuilder) BACnetConstructedDataAckRequiredBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataAckRequired or returns an error if something is wrong
	Build() (BACnetConstructedDataAckRequired, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataAckRequired
}

// NewBACnetConstructedDataAckRequiredBuilder() creates a BACnetConstructedDataAckRequiredBuilder
func NewBACnetConstructedDataAckRequiredBuilder() BACnetConstructedDataAckRequiredBuilder {
	return &_BACnetConstructedDataAckRequiredBuilder{_BACnetConstructedDataAckRequired: new(_BACnetConstructedDataAckRequired)}
}

type _BACnetConstructedDataAckRequiredBuilder struct {
	*_BACnetConstructedDataAckRequired

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataAckRequiredBuilder) = (*_BACnetConstructedDataAckRequiredBuilder)(nil)

func (b *_BACnetConstructedDataAckRequiredBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataAckRequired
}

func (b *_BACnetConstructedDataAckRequiredBuilder) WithMandatoryFields(ackRequired BACnetEventTransitionBitsTagged) BACnetConstructedDataAckRequiredBuilder {
	return b.WithAckRequired(ackRequired)
}

func (b *_BACnetConstructedDataAckRequiredBuilder) WithAckRequired(ackRequired BACnetEventTransitionBitsTagged) BACnetConstructedDataAckRequiredBuilder {
	b.AckRequired = ackRequired
	return b
}

func (b *_BACnetConstructedDataAckRequiredBuilder) WithAckRequiredBuilder(builderSupplier func(BACnetEventTransitionBitsTaggedBuilder) BACnetEventTransitionBitsTaggedBuilder) BACnetConstructedDataAckRequiredBuilder {
	builder := builderSupplier(b.AckRequired.CreateBACnetEventTransitionBitsTaggedBuilder())
	var err error
	b.AckRequired, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetEventTransitionBitsTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataAckRequiredBuilder) Build() (BACnetConstructedDataAckRequired, error) {
	if b.AckRequired == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'ackRequired' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataAckRequired.deepCopy(), nil
}

func (b *_BACnetConstructedDataAckRequiredBuilder) MustBuild() BACnetConstructedDataAckRequired {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataAckRequiredBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataAckRequiredBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataAckRequiredBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataAckRequiredBuilder().(*_BACnetConstructedDataAckRequiredBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataAckRequiredBuilder creates a BACnetConstructedDataAckRequiredBuilder
func (b *_BACnetConstructedDataAckRequired) CreateBACnetConstructedDataAckRequiredBuilder() BACnetConstructedDataAckRequiredBuilder {
	if b == nil {
		return NewBACnetConstructedDataAckRequiredBuilder()
	}
	return &_BACnetConstructedDataAckRequiredBuilder{_BACnetConstructedDataAckRequired: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataAckRequired) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataAckRequired) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ACK_REQUIRED
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataAckRequired) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataAckRequired) GetAckRequired() BACnetEventTransitionBitsTagged {
	return m.AckRequired
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataAckRequired) GetActualValue() BACnetEventTransitionBitsTagged {
	ctx := context.Background()
	_ = ctx
	return CastBACnetEventTransitionBitsTagged(m.GetAckRequired())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataAckRequired(structType any) BACnetConstructedDataAckRequired {
	if casted, ok := structType.(BACnetConstructedDataAckRequired); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataAckRequired); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataAckRequired) GetTypeName() string {
	return "BACnetConstructedDataAckRequired"
}

func (m *_BACnetConstructedDataAckRequired) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (ackRequired)
	lengthInBits += m.AckRequired.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataAckRequired) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataAckRequired) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataAckRequired BACnetConstructedDataAckRequired, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataAckRequired"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataAckRequired")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	ackRequired, err := ReadSimpleField[BACnetEventTransitionBitsTagged](ctx, "ackRequired", ReadComplex[BACnetEventTransitionBitsTagged](BACnetEventTransitionBitsTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'ackRequired' field"))
	}
	m.AckRequired = ackRequired

	actualValue, err := ReadVirtualField[BACnetEventTransitionBitsTagged](ctx, "actualValue", (*BACnetEventTransitionBitsTagged)(nil), ackRequired)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataAckRequired"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataAckRequired")
	}

	return m, nil
}

func (m *_BACnetConstructedDataAckRequired) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataAckRequired) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataAckRequired"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataAckRequired")
		}

		if err := WriteSimpleField[BACnetEventTransitionBitsTagged](ctx, "ackRequired", m.GetAckRequired(), WriteComplex[BACnetEventTransitionBitsTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'ackRequired' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataAckRequired"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataAckRequired")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataAckRequired) IsBACnetConstructedDataAckRequired() {}

func (m *_BACnetConstructedDataAckRequired) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataAckRequired) deepCopy() *_BACnetConstructedDataAckRequired {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataAckRequiredCopy := &_BACnetConstructedDataAckRequired{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetEventTransitionBitsTagged](m.AckRequired),
	}
	_BACnetConstructedDataAckRequiredCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataAckRequiredCopy
}

func (m *_BACnetConstructedDataAckRequired) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
