/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetClientCOVNone is the corresponding interface of BACnetClientCOVNone
type BACnetClientCOVNone interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetClientCOV
	// GetDefaultIncrement returns DefaultIncrement (property field)
	GetDefaultIncrement() BACnetApplicationTagNull
	// IsBACnetClientCOVNone is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetClientCOVNone()
	// CreateBuilder creates a BACnetClientCOVNoneBuilder
	CreateBACnetClientCOVNoneBuilder() BACnetClientCOVNoneBuilder
}

// _BACnetClientCOVNone is the data-structure of this message
type _BACnetClientCOVNone struct {
	BACnetClientCOVContract
	DefaultIncrement BACnetApplicationTagNull
}

var _ BACnetClientCOVNone = (*_BACnetClientCOVNone)(nil)
var _ BACnetClientCOVRequirements = (*_BACnetClientCOVNone)(nil)

// NewBACnetClientCOVNone factory function for _BACnetClientCOVNone
func NewBACnetClientCOVNone(peekedTagHeader BACnetTagHeader, defaultIncrement BACnetApplicationTagNull) *_BACnetClientCOVNone {
	if defaultIncrement == nil {
		panic("defaultIncrement of type BACnetApplicationTagNull for BACnetClientCOVNone must not be nil")
	}
	_result := &_BACnetClientCOVNone{
		BACnetClientCOVContract: NewBACnetClientCOV(peekedTagHeader),
		DefaultIncrement:        defaultIncrement,
	}
	_result.BACnetClientCOVContract.(*_BACnetClientCOV)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetClientCOVNoneBuilder is a builder for BACnetClientCOVNone
type BACnetClientCOVNoneBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(defaultIncrement BACnetApplicationTagNull) BACnetClientCOVNoneBuilder
	// WithDefaultIncrement adds DefaultIncrement (property field)
	WithDefaultIncrement(BACnetApplicationTagNull) BACnetClientCOVNoneBuilder
	// WithDefaultIncrementBuilder adds DefaultIncrement (property field) which is build by the builder
	WithDefaultIncrementBuilder(func(BACnetApplicationTagNullBuilder) BACnetApplicationTagNullBuilder) BACnetClientCOVNoneBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetClientCOVBuilder
	// Build builds the BACnetClientCOVNone or returns an error if something is wrong
	Build() (BACnetClientCOVNone, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetClientCOVNone
}

// NewBACnetClientCOVNoneBuilder() creates a BACnetClientCOVNoneBuilder
func NewBACnetClientCOVNoneBuilder() BACnetClientCOVNoneBuilder {
	return &_BACnetClientCOVNoneBuilder{_BACnetClientCOVNone: new(_BACnetClientCOVNone)}
}

type _BACnetClientCOVNoneBuilder struct {
	*_BACnetClientCOVNone

	parentBuilder *_BACnetClientCOVBuilder

	collectedErr []error
}

var _ (BACnetClientCOVNoneBuilder) = (*_BACnetClientCOVNoneBuilder)(nil)

func (b *_BACnetClientCOVNoneBuilder) setParent(contract BACnetClientCOVContract) {
	b.BACnetClientCOVContract = contract
	contract.(*_BACnetClientCOV)._SubType = b._BACnetClientCOVNone
}

func (b *_BACnetClientCOVNoneBuilder) WithMandatoryFields(defaultIncrement BACnetApplicationTagNull) BACnetClientCOVNoneBuilder {
	return b.WithDefaultIncrement(defaultIncrement)
}

func (b *_BACnetClientCOVNoneBuilder) WithDefaultIncrement(defaultIncrement BACnetApplicationTagNull) BACnetClientCOVNoneBuilder {
	b.DefaultIncrement = defaultIncrement
	return b
}

func (b *_BACnetClientCOVNoneBuilder) WithDefaultIncrementBuilder(builderSupplier func(BACnetApplicationTagNullBuilder) BACnetApplicationTagNullBuilder) BACnetClientCOVNoneBuilder {
	builder := builderSupplier(b.DefaultIncrement.CreateBACnetApplicationTagNullBuilder())
	var err error
	b.DefaultIncrement, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagNullBuilder failed"))
	}
	return b
}

func (b *_BACnetClientCOVNoneBuilder) Build() (BACnetClientCOVNone, error) {
	if b.DefaultIncrement == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'defaultIncrement' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetClientCOVNone.deepCopy(), nil
}

func (b *_BACnetClientCOVNoneBuilder) MustBuild() BACnetClientCOVNone {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetClientCOVNoneBuilder) Done() BACnetClientCOVBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetClientCOVBuilder().(*_BACnetClientCOVBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetClientCOVNoneBuilder) buildForBACnetClientCOV() (BACnetClientCOV, error) {
	return b.Build()
}

func (b *_BACnetClientCOVNoneBuilder) DeepCopy() any {
	_copy := b.CreateBACnetClientCOVNoneBuilder().(*_BACnetClientCOVNoneBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetClientCOVNoneBuilder creates a BACnetClientCOVNoneBuilder
func (b *_BACnetClientCOVNone) CreateBACnetClientCOVNoneBuilder() BACnetClientCOVNoneBuilder {
	if b == nil {
		return NewBACnetClientCOVNoneBuilder()
	}
	return &_BACnetClientCOVNoneBuilder{_BACnetClientCOVNone: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetClientCOVNone) GetParent() BACnetClientCOVContract {
	return m.BACnetClientCOVContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetClientCOVNone) GetDefaultIncrement() BACnetApplicationTagNull {
	return m.DefaultIncrement
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetClientCOVNone(structType any) BACnetClientCOVNone {
	if casted, ok := structType.(BACnetClientCOVNone); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetClientCOVNone); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetClientCOVNone) GetTypeName() string {
	return "BACnetClientCOVNone"
}

func (m *_BACnetClientCOVNone) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetClientCOVContract.(*_BACnetClientCOV).getLengthInBits(ctx))

	// Simple field (defaultIncrement)
	lengthInBits += m.DefaultIncrement.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetClientCOVNone) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetClientCOVNone) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetClientCOV) (__bACnetClientCOVNone BACnetClientCOVNone, err error) {
	m.BACnetClientCOVContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetClientCOVNone"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetClientCOVNone")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	defaultIncrement, err := ReadSimpleField[BACnetApplicationTagNull](ctx, "defaultIncrement", ReadComplex[BACnetApplicationTagNull](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagNull](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'defaultIncrement' field"))
	}
	m.DefaultIncrement = defaultIncrement

	if closeErr := readBuffer.CloseContext("BACnetClientCOVNone"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetClientCOVNone")
	}

	return m, nil
}

func (m *_BACnetClientCOVNone) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetClientCOVNone) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetClientCOVNone"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetClientCOVNone")
		}

		if err := WriteSimpleField[BACnetApplicationTagNull](ctx, "defaultIncrement", m.GetDefaultIncrement(), WriteComplex[BACnetApplicationTagNull](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'defaultIncrement' field")
		}

		if popErr := writeBuffer.PopContext("BACnetClientCOVNone"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetClientCOVNone")
		}
		return nil
	}
	return m.BACnetClientCOVContract.(*_BACnetClientCOV).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetClientCOVNone) IsBACnetClientCOVNone() {}

func (m *_BACnetClientCOVNone) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetClientCOVNone) deepCopy() *_BACnetClientCOVNone {
	if m == nil {
		return nil
	}
	_BACnetClientCOVNoneCopy := &_BACnetClientCOVNone{
		m.BACnetClientCOVContract.(*_BACnetClientCOV).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagNull](m.DefaultIncrement),
	}
	_BACnetClientCOVNoneCopy.BACnetClientCOVContract.(*_BACnetClientCOV)._SubType = m
	return _BACnetClientCOVNoneCopy
}

func (m *_BACnetClientCOVNone) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
