/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline;

import java.awt.Color;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.exceptions.OutlineNotLocalException;
import org.apache.pdfbox.pdmodel.PDDestinationNameTreeNode;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDestinationDictionary;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorState;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionFactory;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDNamedDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;
import org.apache.pdfbox.util.BitFlagHelper;

public class PDOutlineItem
extends PDOutlineNode {
    private static final int ITALIC_FLAG = 1;
    private static final int BOLD_FLAG = 2;

    public PDOutlineItem() {
    }

    public PDOutlineItem(COSDictionary dic) {
        super(dic);
    }

    public void insertSiblingAfter(PDOutlineItem item) {
        item.setParent(this.getParent());
        PDOutlineItem next = this.getNextSibling();
        this.setNextSibling(item);
        item.setPreviousSibling(this);
        if (next != null) {
            item.setNextSibling(next);
            next.setPreviousSibling(item);
        }
        this.updateParentOpenCount(1);
    }

    public PDOutlineNode getParent() {
        return super.getParent();
    }

    public PDOutlineItem getPreviousSibling() {
        PDOutlineItem last = null;
        COSDictionary lastDic = (COSDictionary)this.node.getDictionaryObject(COSName.PREV);
        if (lastDic != null) {
            last = new PDOutlineItem(lastDic);
        }
        return last;
    }

    protected void setPreviousSibling(PDOutlineNode outlineNode) {
        this.node.setItem(COSName.PREV, (COSObjectable)outlineNode);
    }

    public PDOutlineItem getNextSibling() {
        PDOutlineItem last = null;
        COSDictionary lastDic = (COSDictionary)this.node.getDictionaryObject(COSName.NEXT);
        if (lastDic != null) {
            last = new PDOutlineItem(lastDic);
        }
        return last;
    }

    protected void setNextSibling(PDOutlineNode outlineNode) {
        this.node.setItem(COSName.NEXT, (COSObjectable)outlineNode);
    }

    public String getTitle() {
        return this.node.getString(COSName.TITLE);
    }

    public void setTitle(String title) {
        this.node.setString(COSName.TITLE, title);
    }

    public PDDestination getDestination() throws IOException {
        return PDDestination.create(this.node.getDictionaryObject(COSName.DEST));
    }

    public void setDestination(PDDestination dest) {
        this.node.setItem(COSName.DEST, (COSObjectable)dest);
    }

    public void setDestination(PDPage page) {
        PDPageXYZDestination dest = null;
        if (page != null) {
            dest = new PDPageXYZDestination();
            dest.setPage(page);
        }
        this.setDestination(dest);
    }

    public PDPage findDestinationPage(PDDocument doc) throws IOException {
        int pageNumber;
        PDPage page = null;
        PDDestination rawDest = this.getDestination();
        if (rawDest == null) {
            PDAction outlineAction = this.getAction();
            if (outlineAction instanceof PDActionGoTo) {
                rawDest = ((PDActionGoTo)outlineAction).getDestination();
            } else if (outlineAction != null) {
                throw new OutlineNotLocalException("Error: Outline does not reference a local page.");
            }
        }
        PDPageDestination pageDest = null;
        if (rawDest instanceof PDNamedDestination) {
            PDNamedDestination namedDest = (PDNamedDestination)rawDest;
            PDDocumentNameDictionary namesDict = doc.getDocumentCatalog().getNames();
            if (namesDict != null) {
                PDDestinationNameTreeNode destsTree = namesDict.getDests();
                if (destsTree != null) {
                    pageDest = (PDPageDestination)destsTree.getValue(namedDest.getNamedDestination());
                }
            } else {
                PDDocumentNameDestinationDictionary nameDestDict = doc.getDocumentCatalog().getDests();
                if (nameDestDict != null) {
                    String name = namedDest.getNamedDestination();
                    pageDest = (PDPageDestination)nameDestDict.getDestination(name);
                }
            }
        } else if (rawDest instanceof PDPageDestination) {
            pageDest = (PDPageDestination)rawDest;
        } else if (rawDest != null) {
            throw new IOException("Error: Unknown destination type " + rawDest);
        }
        if (pageDest != null && (page = pageDest.getPage()) == null && (pageNumber = pageDest.getPageNumber()) != -1) {
            List allPages = doc.getDocumentCatalog().getAllPages();
            page = (PDPage)allPages.get(pageNumber);
        }
        return page;
    }

    public PDAction getAction() {
        return PDActionFactory.createAction((COSDictionary)this.node.getDictionaryObject(COSName.A));
    }

    public void setAction(PDAction action) {
        this.node.setItem(COSName.A, (COSObjectable)action);
    }

    public PDStructureElement getStructureElement() {
        PDStructureElement se = null;
        COSDictionary dic = (COSDictionary)this.node.getDictionaryObject(COSName.SE);
        if (dic != null) {
            se = new PDStructureElement(dic);
        }
        return se;
    }

    public void setStructuredElement(PDStructureElement structureElement) {
        this.node.setItem(COSName.SE, (COSObjectable)structureElement);
    }

    public PDColorState getTextColor() {
        PDColorState retval = null;
        COSArray csValues = (COSArray)this.node.getDictionaryObject(COSName.C);
        if (csValues == null) {
            csValues = new COSArray();
            csValues.growToSize(3, new COSFloat(0.0f));
            this.node.setItem(COSName.C, (COSBase)csValues);
        }
        retval = new PDColorState(csValues);
        retval.setColorSpace(PDDeviceRGB.INSTANCE);
        return retval;
    }

    public void setTextColor(PDColorState textColor) {
        this.node.setItem(COSName.C, (COSBase)textColor.getCOSColorSpaceValue());
    }

    public void setTextColor(Color textColor) {
        COSArray array = new COSArray();
        array.add(new COSFloat((float)textColor.getRed() / 255.0f));
        array.add(new COSFloat((float)textColor.getGreen() / 255.0f));
        array.add(new COSFloat((float)textColor.getBlue() / 255.0f));
        this.node.setItem(COSName.C, (COSBase)array);
    }

    public boolean isItalic() {
        return BitFlagHelper.getFlag(this.node, COSName.F, 1);
    }

    public void setItalic(boolean italic) {
        BitFlagHelper.setFlag(this.node, COSName.F, 1, italic);
    }

    public boolean isBold() {
        return BitFlagHelper.getFlag(this.node, COSName.F, 2);
    }

    public void setBold(boolean bold) {
        BitFlagHelper.setFlag(this.node, COSName.F, 2, bold);
    }
}

