/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.AbstractPort;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.exception.CommunicationsException;
import org.apache.nifi.engine.FlowEngine;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroupCounts;
import org.apache.nifi.groups.RemoteProcessGroupPortDescriptor;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.remote.RemoteNiFiUtils;
import org.apache.nifi.remote.StandardRemoteGroupPort;
import org.apache.nifi.remote.StandardRemoteProcessGroupPortDescriptor;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.remote.protocol.SiteToSiteTransportProtocol;
import org.apache.nifi.remote.protocol.http.HttpProxy;
import org.apache.nifi.remote.util.SiteToSiteRestApiClient;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ComponentType;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.web.api.dto.ControllerDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardRemoteProcessGroup
implements RemoteProcessGroup {
    private static final Logger logger = LoggerFactory.getLogger(StandardRemoteProcessGroup.class);
    private static final int UNAUTHORIZED_STATUS_CODE = Response.Status.UNAUTHORIZED.getStatusCode();
    private static final int FORBIDDEN_STATUS_CODE = Response.Status.FORBIDDEN.getStatusCode();
    private final String id;
    private volatile String targetUris;
    private final ProcessScheduler scheduler;
    private final EventReporter eventReporter;
    private final StateManager stateManager;
    private final long remoteContentsCacheExpiration;
    private volatile boolean initialized = false;
    private final AtomicReference<String> name = new AtomicReference();
    private final AtomicReference<Position> position = new AtomicReference<Position>(new Position(0.0, 0.0));
    private final AtomicReference<String> comments = new AtomicReference();
    private final AtomicReference<ProcessGroup> processGroup;
    private final AtomicBoolean transmitting = new AtomicBoolean(false);
    private final AtomicBoolean configuredToTransmit = new AtomicBoolean(false);
    private final AtomicReference<String> versionedComponentId = new AtomicReference();
    private final SSLContext sslContext;
    private volatile String communicationsTimeout = "30 sec";
    private volatile String targetId;
    private volatile String yieldDuration = "10 sec";
    private volatile SiteToSiteTransportProtocol transportProtocol = SiteToSiteTransportProtocol.RAW;
    private volatile String proxyHost;
    private volatile Integer proxyPort;
    private volatile String proxyUser;
    private volatile String proxyPassword;
    private String networkInterfaceName;
    private InetAddress localAddress;
    private ValidationResult nicValidationResult;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final Map<String, StandardRemoteGroupPort> inputPorts = new HashMap<String, StandardRemoteGroupPort>();
    private final Map<String, StandardRemoteGroupPort> outputPorts = new HashMap<String, StandardRemoteGroupPort>();
    private RemoteProcessGroupCounts counts = new RemoteProcessGroupCounts(0, 0);
    private Long refreshContentsTimestamp = null;
    private Boolean destinationSecure;
    private Integer listeningPort;
    private Integer listeningHttpPort;
    private volatile String authorizationIssue;
    private final ScheduledExecutorService backgroundThreadExecutor;

    public StandardRemoteProcessGroup(String id, String targetUris, ProcessGroup processGroup, ProcessScheduler processScheduler, final BulletinRepository bulletinRepository, SSLContext sslContext, StateManager stateManager, long remoteContentsCacheExpirationMillis) {
        this.stateManager = stateManager;
        this.id = Objects.requireNonNull(id);
        this.targetUris = targetUris;
        this.targetId = null;
        this.processGroup = new AtomicReference<ProcessGroup>(processGroup);
        this.sslContext = sslContext;
        this.scheduler = processScheduler;
        this.authorizationIssue = "Establishing connection to " + targetUris;
        this.remoteContentsCacheExpiration = remoteContentsCacheExpirationMillis;
        this.eventReporter = new EventReporter(){
            private static final long serialVersionUID = 1L;

            public void reportEvent(Severity severity, String category, String message) {
                String groupId = StandardRemoteProcessGroup.this.getProcessGroup().getIdentifier();
                String groupName = StandardRemoteProcessGroup.this.getProcessGroup().getName();
                String sourceId = StandardRemoteProcessGroup.this.getIdentifier();
                String sourceName = StandardRemoteProcessGroup.this.getName();
                bulletinRepository.addBulletin(BulletinFactory.createBulletin((String)groupId, (String)groupName, (String)sourceId, (ComponentType)ComponentType.REMOTE_PROCESS_GROUP, (String)sourceName, (String)category, (String)severity.name(), (String)message));
            }
        };
        this.backgroundThreadExecutor = new FlowEngine(1, "Remote Process Group " + id, true);
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.backgroundThreadExecutor.schedule(() -> {
            try {
                this.refreshFlowContents();
            }
            catch (Exception e) {
                if (this.isConnectionTimeoutError(e)) {
                    logger.warn("Unable to communicate with remote instance {}", (Object)this);
                }
                logger.warn("Unable to communicate with remote instance {}", (Object)this, (Object)e);
            }
        }, 3L, TimeUnit.SECONDS);
        InitializationTask checkAuthorizations = new InitializationTask();
        this.backgroundThreadExecutor.scheduleWithFixedDelay(checkAuthorizations, 0L, 60L, TimeUnit.SECONDS);
    }

    private boolean isConnectionTimeoutError(Exception e) {
        return e instanceof CommunicationsException && e.getLocalizedMessage().contains("connect timed out");
    }

    public void setTargetUris(String targetUris) {
        Objects.requireNonNull(targetUris);
        if (targetUris.equals(this.targetUris)) {
            return;
        }
        this.verifyCanUpdate();
        this.targetUris = targetUris;
        this.backgroundThreadExecutor.submit(() -> {
            try {
                this.refreshFlowContents();
            }
            catch (Exception e) {
                if (this.isConnectionTimeoutError(e)) {
                    logger.warn("Unable to communicate with remote instance {}", (Object)this);
                }
                logger.warn("Unable to communicate with remote instance {}", (Object)this, (Object)e);
            }
        });
        this.backgroundThreadExecutor.submit(new InitializationTask());
    }

    public void reinitialize(boolean isClustered) {
        this.backgroundThreadExecutor.submit(new InitializationTask());
    }

    public void onRemove() {
        this.backgroundThreadExecutor.shutdown();
    }

    public void shutdown() {
        this.backgroundThreadExecutor.shutdown();
    }

    public String getIdentifier() {
        return this.id;
    }

    public String getProcessGroupIdentifier() {
        ProcessGroup procGroup = this.getProcessGroup();
        return procGroup == null ? null : procGroup.getIdentifier();
    }

    public Authorizable getParentAuthorizable() {
        return this.getProcessGroup();
    }

    public Resource getResource() {
        return ResourceFactory.getComponentResource((ResourceType)ResourceType.RemoteProcessGroup, (String)this.getIdentifier(), (String)this.getName());
    }

    public ProcessGroup getProcessGroup() {
        return this.processGroup.get();
    }

    public void setProcessGroup(ProcessGroup group) {
        this.processGroup.set(group);
        for (RemoteGroupPort port : this.getInputPorts()) {
            port.setProcessGroup(group);
        }
        for (RemoteGroupPort port : this.getOutputPorts()) {
            port.setProcessGroup(group);
        }
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public void setTransportProtocol(SiteToSiteTransportProtocol transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    public SiteToSiteTransportProtocol getTransportProtocol() {
        return this.transportProtocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getName() {
        String name = this.name.get();
        return name == null ? this.getTargetUri() : name;
    }

    public void setName(String name) {
        this.name.set(name);
    }

    public String getCommunicationsTimeout() {
        return this.communicationsTimeout;
    }

    public void setCommunicationsTimeout(String timePeriod) throws IllegalArgumentException {
        try {
            long millis = FormatUtils.getTimeDuration((String)timePeriod, (TimeUnit)TimeUnit.MILLISECONDS);
            if (millis <= 0L) {
                throw new IllegalArgumentException("Time Period must be more than 0 milliseconds; Invalid Time Period: " + timePeriod);
            }
            if (millis > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Timeout is too long; cannot be greater than 2147483647 milliseconds");
            }
            this.communicationsTimeout = timePeriod;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid Time Period: " + timePeriod);
        }
    }

    public int getCommunicationsTimeout(TimeUnit timeUnit) {
        return (int)FormatUtils.getTimeDuration((String)this.communicationsTimeout, (TimeUnit)timeUnit);
    }

    public String getComments() {
        return this.comments.get();
    }

    public void setComments(String comments) {
        this.comments.set(comments);
    }

    public Position getPosition() {
        return this.position.get();
    }

    public void setPosition(Position position) {
        this.position.set(position);
    }

    public String getTargetUri() {
        return SiteToSiteRestApiClient.getFirstUrl((String)this.targetUris);
    }

    public String getTargetUris() {
        return this.targetUris;
    }

    public String getAuthorizationIssue() {
        return this.authorizationIssue;
    }

    public Collection<ValidationResult> validate() {
        return this.nicValidationResult == null ? Collections.emptyList() : Collections.singletonList(this.nicValidationResult);
    }

    public int getInputPortCount() {
        this.readLock.lock();
        try {
            int n = this.inputPorts.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getOutputPortCount() {
        this.readLock.lock();
        try {
            int n = this.outputPorts.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean containsInputPort(String id) {
        this.readLock.lock();
        try {
            boolean bl = this.inputPorts.containsKey(id);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputPorts(Set<RemoteProcessGroupPortDescriptor> ports, boolean pruneUnusedPorts) {
        this.writeLock.lock();
        try {
            logger.debug("Updating Input Ports for {}", (Object)this);
            ArrayList<String> newPortTargetIds = new ArrayList<String>();
            for (RemoteProcessGroupPortDescriptor descriptor : ports) {
                newPortTargetIds.add(descriptor.getTargetId());
                Map inputPortByTargetId = this.inputPorts.values().stream().collect(Collectors.toMap(StandardRemoteGroupPort::getTargetIdentifier, Function.identity()));
                Map inputPortByName = this.inputPorts.values().stream().collect(Collectors.toMap(AbstractPort::getName, Function.identity()));
                StandardRemoteGroupPort sendPort = (StandardRemoteGroupPort)inputPortByTargetId.get(descriptor.getTargetId());
                if (sendPort == null) {
                    sendPort = (StandardRemoteGroupPort)inputPortByName.get(descriptor.getName());
                    if (sendPort == null) {
                        sendPort = this.addInputPort(descriptor);
                        logger.info("Added Input Port {} with Name {} and Target Identifier {} to {}", new Object[]{sendPort.getIdentifier(), sendPort.getName(), sendPort.getTargetIdentifier(), this});
                    } else if (descriptor.getTargetId() != null) {
                        String previousTargetId = sendPort.getTargetIdentifier();
                        sendPort.setTargetIdentifier(descriptor.getTargetId());
                        logger.info("Updated Target identifier for Input Port with Name {} from {} to {} for {}", new Object[]{descriptor.getName(), previousTargetId, descriptor.getTargetId(), this});
                    }
                }
                sendPort.setTargetExists(true);
                sendPort.setName(descriptor.getName());
                if (descriptor.isTargetRunning() != null) {
                    sendPort.setTargetRunning(descriptor.isTargetRunning().booleanValue());
                }
                sendPort.setComments(descriptor.getComments());
            }
            if (pruneUnusedPorts) {
                Iterator<StandardRemoteGroupPort> itr = this.inputPorts.values().iterator();
                int prunedCount = 0;
                while (itr.hasNext()) {
                    StandardRemoteGroupPort port = itr.next();
                    if (newPortTargetIds.contains(port.getTargetIdentifier())) continue;
                    port.setTargetExists(false);
                    port.setTargetRunning(false);
                    if (port.hasIncomingConnection()) continue;
                    itr.remove();
                    logger.debug("Pruning unused Input Port {} from {}", (Object)port, (Object)this);
                    ++prunedCount;
                }
                if (prunedCount == 0) {
                    logger.debug("There were no Input Ports to prune from {}", (Object)this);
                } else {
                    logger.debug("Successfully pruned {} unused Input Ports from {}", (Object)prunedCount, (Object)this);
                }
            } else {
                logger.debug("Updated Input Ports for {} but did not attempt to prune any unused ports", (Object)this);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean containsOutputPort(String id) {
        this.readLock.lock();
        try {
            boolean bl = this.outputPorts.containsKey(id);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputPorts(Set<RemoteProcessGroupPortDescriptor> ports, boolean pruneUnusedPorts) {
        this.writeLock.lock();
        try {
            ArrayList<String> newPortTargetIds = new ArrayList<String>();
            for (RemoteProcessGroupPortDescriptor descriptor : Objects.requireNonNull(ports)) {
                newPortTargetIds.add(descriptor.getTargetId());
                Map outputPortByTargetId = this.outputPorts.values().stream().collect(Collectors.toMap(StandardRemoteGroupPort::getTargetIdentifier, Function.identity()));
                Map outputPortByName = this.outputPorts.values().stream().collect(Collectors.toMap(AbstractPort::getName, Function.identity()));
                StandardRemoteGroupPort receivePort = (StandardRemoteGroupPort)outputPortByTargetId.get(descriptor.getTargetId());
                if (receivePort == null) {
                    receivePort = (StandardRemoteGroupPort)outputPortByName.get(descriptor.getName());
                    if (receivePort == null) {
                        receivePort = this.addOutputPort(descriptor);
                        logger.info("Added Output Port {} with Name {} and Target Identifier {} to {}", new Object[]{receivePort.getIdentifier(), receivePort.getName(), receivePort.getTargetIdentifier(), this});
                    } else {
                        String previousTargetId = receivePort.getTargetIdentifier();
                        receivePort.setTargetIdentifier(descriptor.getTargetId());
                        logger.info("Updated Target identifier for Output Port with Name {} from {} to {} for {}", new Object[]{descriptor.getName(), previousTargetId, descriptor.getTargetId(), this});
                    }
                }
                receivePort.setTargetExists(true);
                receivePort.setName(descriptor.getName());
                if (descriptor.isTargetRunning() != null) {
                    receivePort.setTargetRunning(descriptor.isTargetRunning().booleanValue());
                }
                receivePort.setComments(descriptor.getComments());
            }
            if (pruneUnusedPorts) {
                Iterator<StandardRemoteGroupPort> itr = this.outputPorts.values().iterator();
                int prunedCount = 0;
                while (itr.hasNext()) {
                    StandardRemoteGroupPort port = itr.next();
                    if (newPortTargetIds.contains(port.getTargetIdentifier())) continue;
                    port.setTargetExists(false);
                    port.setTargetRunning(false);
                    if (!port.getConnections().isEmpty()) continue;
                    itr.remove();
                    logger.info("Pruning unused Output Port {} from {}", (Object)port, (Object)this);
                }
                if (prunedCount == 0) {
                    logger.debug("There were no Output Ports to prune from {}", (Object)this);
                } else {
                    logger.debug("Successfully pruned {} unused Output Ports from {}", (Object)prunedCount, (Object)this);
                }
            } else {
                logger.debug("Updated Output Ports for {} but did not attempt to prune any unused ports", (Object)this);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeNonExistentPort(RemoteGroupPort port) {
        this.writeLock.lock();
        try {
            if (Objects.requireNonNull(port).getTargetExists()) {
                throw new IllegalStateException("Cannot remove Remote Port " + port.getIdentifier() + " because it still exists on the Remote Instance");
            }
            if (!port.getConnections().isEmpty() || port.hasIncomingConnection()) {
                throw new IllegalStateException("Cannot remove Remote Port because it is connected to other components");
            }
            this.scheduler.stopPort((Port)port);
            if (this.outputPorts.containsKey(port.getIdentifier())) {
                this.outputPorts.remove(port.getIdentifier());
            } else {
                if (!this.inputPorts.containsKey(port.getIdentifier())) {
                    throw new IllegalStateException("Cannot remove Remote Port because it does not belong to this Remote Process Group");
                }
                this.inputPorts.remove(port.getIdentifier());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StandardRemoteGroupPort addOutputPort(RemoteProcessGroupPortDescriptor descriptor) {
        this.writeLock.lock();
        try {
            if (this.outputPorts.containsKey(Objects.requireNonNull(descriptor).getId())) {
                throw new IllegalStateException("Output Port with ID " + descriptor.getId() + " already exists");
            }
            StandardRemoteGroupPort port = new StandardRemoteGroupPort(descriptor.getId(), descriptor.getTargetId(), descriptor.getName(), (RemoteProcessGroup)this, TransferDirection.RECEIVE, ConnectableType.REMOTE_OUTPUT_PORT, this.sslContext, this.scheduler);
            port.setProcessGroup(this.getProcessGroup());
            this.outputPorts.put(descriptor.getId(), port);
            if (descriptor.getConcurrentlySchedulableTaskCount() != null) {
                port.setMaxConcurrentTasks(descriptor.getConcurrentlySchedulableTaskCount().intValue());
            }
            if (descriptor.getUseCompression() != null) {
                port.setUseCompression(descriptor.getUseCompression().booleanValue());
            }
            if (descriptor.getBatchCount() != null && descriptor.getBatchCount() > 0) {
                port.setBatchCount(descriptor.getBatchCount());
            }
            if (!StringUtils.isBlank((CharSequence)descriptor.getBatchSize())) {
                port.setBatchSize(descriptor.getBatchSize());
            }
            if (!StringUtils.isBlank((CharSequence)descriptor.getBatchDuration())) {
                port.setBatchDuration(descriptor.getBatchDuration());
            }
            port.setVersionedComponentId(descriptor.getVersionedComponentId());
            StandardRemoteGroupPort standardRemoteGroupPort = port;
            return standardRemoteGroupPort;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public RemoteGroupPort getInputPort(String portIdentifier) {
        this.readLock.lock();
        try {
            if (Objects.requireNonNull(portIdentifier).startsWith(this.id + "-")) {
                RemoteGroupPort remoteGroupPort = (RemoteGroupPort)this.inputPorts.get(portIdentifier.substring(this.id.length() + 1));
                return remoteGroupPort;
            }
            RemoteGroupPort remoteGroupPort = (RemoteGroupPort)this.inputPorts.get(portIdentifier);
            return remoteGroupPort;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<RemoteGroupPort> getInputPorts() {
        this.readLock.lock();
        try {
            HashSet<RemoteGroupPort> set = new HashSet<RemoteGroupPort>();
            set.addAll(this.inputPorts.values());
            HashSet<RemoteGroupPort> hashSet = set;
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StandardRemoteGroupPort addInputPort(RemoteProcessGroupPortDescriptor descriptor) {
        this.writeLock.lock();
        try {
            if (this.inputPorts.containsKey(descriptor.getId())) {
                throw new IllegalStateException("Input Port with ID " + descriptor.getId() + " already exists");
            }
            StandardRemoteGroupPort port = new StandardRemoteGroupPort(descriptor.getId(), descriptor.getTargetId(), descriptor.getName(), (RemoteProcessGroup)this, TransferDirection.SEND, ConnectableType.REMOTE_INPUT_PORT, this.sslContext, this.scheduler);
            port.setProcessGroup(this.getProcessGroup());
            if (descriptor.getConcurrentlySchedulableTaskCount() != null) {
                port.setMaxConcurrentTasks(descriptor.getConcurrentlySchedulableTaskCount().intValue());
            }
            if (descriptor.getUseCompression() != null) {
                port.setUseCompression(descriptor.getUseCompression().booleanValue());
            }
            if (descriptor.getBatchCount() != null && descriptor.getBatchCount() > 0) {
                port.setBatchCount(descriptor.getBatchCount());
            }
            if (!StringUtils.isBlank((CharSequence)descriptor.getBatchSize())) {
                port.setBatchSize(descriptor.getBatchSize());
            }
            if (!StringUtils.isBlank((CharSequence)descriptor.getBatchDuration())) {
                port.setBatchDuration(descriptor.getBatchDuration());
            }
            port.setVersionedComponentId(descriptor.getVersionedComponentId());
            this.inputPorts.put(descriptor.getId(), port);
            StandardRemoteGroupPort standardRemoteGroupPort = port;
            return standardRemoteGroupPort;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private String generatePortId(String targetId) {
        return UUID.nameUUIDFromBytes((this.getIdentifier() + targetId).getBytes(StandardCharsets.UTF_8)).toString();
    }

    public RemoteGroupPort getOutputPort(String portIdentifier) {
        this.readLock.lock();
        try {
            if (Objects.requireNonNull(portIdentifier).startsWith(this.id + "-")) {
                RemoteGroupPort remoteGroupPort = (RemoteGroupPort)this.outputPorts.get(portIdentifier.substring(this.id.length() + 1));
                return remoteGroupPort;
            }
            RemoteGroupPort remoteGroupPort = (RemoteGroupPort)this.outputPorts.get(portIdentifier);
            return remoteGroupPort;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<RemoteGroupPort> getOutputPorts() {
        this.readLock.lock();
        try {
            HashSet<RemoteGroupPort> set = new HashSet<RemoteGroupPort>();
            set.addAll(this.outputPorts.values());
            HashSet<RemoteGroupPort> hashSet = set;
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        return "RemoteProcessGroup[" + this.targetUris + "]";
    }

    public RemoteProcessGroupCounts getCounts() {
        this.readLock.lock();
        try {
            RemoteProcessGroupCounts remoteProcessGroupCounts = this.counts;
            return remoteProcessGroupCounts;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void setCounts(RemoteProcessGroupCounts counts) {
        this.writeLock.lock();
        try {
            this.counts = counts;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Date getLastRefreshTime() {
        this.readLock.lock();
        try {
            Date date = this.refreshContentsTimestamp == null ? null : new Date(this.refreshContentsTimestamp);
            return date;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshFlowContents() throws CommunicationsException {
        if (!this.initialized) {
            return;
        }
        try {
            ControllerDTO dto;
            try (SiteToSiteRestApiClient apiClient = this.getSiteToSiteRestApiClient();){
                dto = apiClient.getController(this.targetUris);
            }
            catch (IOException e) {
                throw new CommunicationsException("Unable to communicate with Remote NiFi at URI " + this.targetUris + " due to: " + e.getMessage());
            }
            this.writeLock.lock();
            try {
                if (dto.getInputPorts() != null) {
                    this.setInputPorts(this.convertRemotePort(dto.getInputPorts()), true);
                }
                if (dto.getOutputPorts() != null) {
                    this.setOutputPorts(this.convertRemotePort(dto.getOutputPorts()), true);
                }
                this.setTargetId(dto.getId());
                this.setName(dto.getName());
                this.setComments(dto.getComments());
                int inputPortCount = 0;
                if (dto.getInputPortCount() != null) {
                    inputPortCount = dto.getInputPortCount();
                }
                int outputPortCount = 0;
                if (dto.getOutputPortCount() != null) {
                    outputPortCount = dto.getOutputPortCount();
                }
                this.listeningPort = dto.getRemoteSiteListeningPort();
                this.listeningHttpPort = dto.getRemoteSiteHttpListeningPort();
                this.destinationSecure = dto.isSiteToSiteSecure();
                RemoteProcessGroupCounts newCounts = new RemoteProcessGroupCounts(inputPortCount, outputPortCount);
                this.setCounts(newCounts);
                this.refreshContentsTimestamp = System.currentTimeMillis();
                List inputPortString = dto.getInputPorts().stream().map(port -> "InputPort[name=" + port.getName() + ", targetId=" + port.getId() + "]").collect(Collectors.toList());
                List outputPortString = dto.getOutputPorts().stream().map(port -> "OutputPort[name=" + port.getName() + ", targetId=" + port.getId() + "]").collect(Collectors.toList());
                logger.info("Successfully refreshed Flow Contents for {}; updated to reflect {} Input Ports {} and {} Output Ports {}", new Object[]{this, dto.getInputPorts().size(), inputPortString, dto.getOutputPorts().size(), outputPortString});
            }
            finally {
                this.writeLock.unlock();
            }
        }
        catch (IOException e) {
            throw new CommunicationsException((Throwable)e);
        }
    }

    public String getNetworkInterface() {
        this.readLock.lock();
        try {
            String string = this.networkInterfaceName;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setNetworkInterface(String interfaceName) {
        block7: {
            this.writeLock.lock();
            try {
                this.networkInterfaceName = interfaceName;
                if (interfaceName == null) {
                    this.localAddress = null;
                    this.nicValidationResult = null;
                    break block7;
                }
                try {
                    Enumeration<InetAddress> inetAddresses = NetworkInterface.getByName(interfaceName).getInetAddresses();
                    if (inetAddresses.hasMoreElements()) {
                        this.localAddress = inetAddresses.nextElement();
                        this.nicValidationResult = null;
                        break block7;
                    }
                    this.localAddress = null;
                    this.nicValidationResult = new ValidationResult.Builder().input(interfaceName).subject("Network Interface Name").valid(false).explanation("No IP Address could be found that is bound to the interface with name " + interfaceName).build();
                }
                catch (Exception e) {
                    this.localAddress = null;
                    this.nicValidationResult = new ValidationResult.Builder().input(interfaceName).subject("Network Interface Name").valid(false).explanation("Could not obtain Network Interface with name " + interfaceName).build();
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public InetAddress getLocalAddress() {
        this.readLock.lock();
        try {
            if (this.nicValidationResult != null && !this.nicValidationResult.isValid()) {
                InetAddress inetAddress = null;
                return inetAddress;
            }
            InetAddress inetAddress = this.localAddress;
            return inetAddress;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private SiteToSiteRestApiClient getSiteToSiteRestApiClient() {
        SiteToSiteRestApiClient apiClient = new SiteToSiteRestApiClient(this.sslContext, new HttpProxy(this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword), this.getEventReporter());
        apiClient.setConnectTimeoutMillis(this.getCommunicationsTimeout(TimeUnit.MILLISECONDS));
        apiClient.setReadTimeoutMillis(this.getCommunicationsTimeout(TimeUnit.MILLISECONDS));
        apiClient.setLocalAddress(this.getLocalAddress());
        apiClient.setCacheExpirationMillis(this.remoteContentsCacheExpiration);
        return apiClient;
    }

    private Set<RemoteProcessGroupPortDescriptor> convertRemotePort(Set<PortDTO> ports) {
        LinkedHashSet<StandardRemoteProcessGroupPortDescriptor> remotePorts = null;
        if (ports != null) {
            remotePorts = new LinkedHashSet<StandardRemoteProcessGroupPortDescriptor>(ports.size());
            for (PortDTO port : ports) {
                StandardRemoteProcessGroupPortDescriptor descriptor = new StandardRemoteProcessGroupPortDescriptor();
                ScheduledState scheduledState = ScheduledState.valueOf((String)port.getState());
                descriptor.setId(this.generatePortId(port.getId()));
                descriptor.setTargetId(port.getId());
                descriptor.setName(port.getName());
                descriptor.setComments(port.getComments());
                descriptor.setTargetRunning(ScheduledState.RUNNING.equals((Object)scheduledState));
                remotePorts.add(descriptor);
            }
        }
        return remotePorts;
    }

    public boolean isTransmitting() {
        return this.transmitting.get();
    }

    public boolean isConfiguredToTransmit() {
        return this.configuredToTransmit.get();
    }

    public void startTransmitting() {
        this.writeLock.lock();
        try {
            this.verifyCanStartTransmitting();
            for (Port port : this.getInputPorts()) {
                if (!port.isValid() || !port.hasIncomingConnection()) continue;
                this.scheduler.startPort(port);
            }
            for (Port port : this.getOutputPorts()) {
                if (!port.isValid() || port.getConnections().isEmpty()) continue;
                this.scheduler.startPort(port);
            }
            this.transmitting.set(true);
            this.configuredToTransmit.set(true);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void startTransmitting(RemoteGroupPort port) {
        this.writeLock.lock();
        try {
            if (!this.inputPorts.containsValue(port) && !this.outputPorts.containsValue(port)) {
                throw new IllegalArgumentException("Port does not belong to this Remote Process Group");
            }
            port.verifyCanStart();
            this.scheduler.startPort((Port)port);
            this.transmitting.set(true);
            this.configuredToTransmit.set(true);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Future<?> stopTransmitting() {
        this.writeLock.lock();
        try {
            this.verifyCanStopTransmitting();
            for (RemoteGroupPort port : this.getInputPorts()) {
                this.scheduler.stopPort((Port)port);
            }
            for (RemoteGroupPort port : this.getOutputPorts()) {
                this.scheduler.stopPort((Port)port);
            }
            this.configuredToTransmit.set(false);
            Future future = this.scheduler.submitFrameworkTask(this::waitForPortShutdown);
            return future;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForPortShutdown() {
        try {
            for (RemoteGroupPort port : this.getInputPorts()) {
                while (port.isRunning()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.transmitting.set(false);
                        return;
                    }
                }
            }
            for (RemoteGroupPort port : this.getOutputPorts()) {
                while (port.isRunning()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.transmitting.set(false);
                        return;
                    }
                }
            }
        }
        finally {
            this.transmitting.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTransmitting(RemoteGroupPort port) {
        this.writeLock.lock();
        try {
            if (!this.inputPorts.containsValue(port) && !this.outputPorts.containsValue(port)) {
                throw new IllegalArgumentException("Port does not belong to this Remote Process Group");
            }
            port.verifyCanStop();
            this.scheduler.stopPort((Port)port);
            while (port.isRunning()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            boolean stillTransmitting = false;
            for (Port port2 : this.getInputPorts()) {
                if (!port2.isRunning()) continue;
                stillTransmitting = true;
                break;
            }
            if (!stillTransmitting) {
                for (Port port3 : this.getOutputPorts()) {
                    if (!port3.isRunning()) continue;
                    stillTransmitting = true;
                    break;
                }
            }
            this.configuredToTransmit.set(stillTransmitting);
            this.transmitting.set(stillTransmitting);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSecure() throws CommunicationsException {
        Boolean secure;
        this.readLock.lock();
        try {
            secure = this.destinationSecure;
            if (secure != null) {
                boolean bl = secure;
                return bl;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.refreshFlowContents();
        this.readLock.lock();
        try {
            secure = this.destinationSecure;
            if (secure == null) {
                throw new CommunicationsException("Unable to determine whether or not site-to-site communications with peer should be secure");
            }
            boolean bl = secure;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Boolean getSecureFlag() {
        this.readLock.lock();
        try {
            Boolean bl = this.destinationSecure;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isSiteToSiteEnabled() {
        this.readLock.lock();
        try {
            boolean bl = this.listeningPort != null || this.listeningHttpPort != null;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public EventReporter getEventReporter() {
        return this.eventReporter;
    }

    public void setYieldDuration(String yieldDuration) {
        if (!FormatUtils.TIME_DURATION_PATTERN.matcher(yieldDuration).matches()) {
            throw new IllegalArgumentException("Improperly formatted Time Period; should be of syntax <number> <unit> where <number> is a positive integer and unit is one of the valid Time Units, such as nanos, millis, sec, min, hour, day");
        }
        this.yieldDuration = yieldDuration;
    }

    public String getYieldDuration() {
        return this.yieldDuration;
    }

    public void verifyCanDelete() {
        this.verifyCanDelete(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyCanDelete(boolean ignoreConnections) {
        this.readLock.lock();
        try {
            if (this.isTransmitting()) {
                throw new IllegalStateException(this.getIdentifier() + " is transmitting");
            }
            for (Port port : this.inputPorts.values()) {
                if (!ignoreConnections && port.hasIncomingConnection()) {
                    throw new IllegalStateException(this.getIdentifier() + " is the destination of another component");
                }
                if (!port.isRunning()) continue;
                throw new IllegalStateException(this.getIdentifier() + " has running Port: " + port.getIdentifier());
            }
            for (Port port : this.outputPorts.values()) {
                if (!ignoreConnections) {
                    for (Connection connection : port.getConnections()) {
                        connection.verifyCanDelete();
                    }
                }
                if (!port.isRunning()) continue;
                throw new IllegalStateException(this.getIdentifier() + " has running Port: " + port.getIdentifier());
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void verifyCanStartTransmitting() {
        this.readLock.lock();
        try {
            if (this.isTransmitting()) {
                throw new IllegalStateException(this.getIdentifier() + " is already transmitting");
            }
            for (StandardRemoteGroupPort port : this.inputPorts.values()) {
                if (port.isRunning()) {
                    throw new IllegalStateException(this.getIdentifier() + " has running Port: " + port.getIdentifier());
                }
                if (port.hasIncomingConnection() && !port.getTargetExists()) {
                    throw new IllegalStateException(this.getIdentifier() + " has a Connection to Port " + port.getIdentifier() + ", but that Port no longer exists on the remote system");
                }
                if (!port.hasIncomingConnection()) continue;
                port.verifyCanStart();
            }
            for (StandardRemoteGroupPort port : this.outputPorts.values()) {
                if (port.isRunning()) {
                    throw new IllegalStateException(this.getIdentifier() + " has running Port: " + port.getIdentifier());
                }
                if (!port.getConnections().isEmpty() && !port.getTargetExists()) {
                    throw new IllegalStateException(this.getIdentifier() + " has a Connection to Port " + port.getIdentifier() + ", but that Port no longer exists on the remote system");
                }
                if (port.getConnections().isEmpty()) continue;
                port.verifyCanStart();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void verifyCanStopTransmitting() {
        if (!this.isTransmitting()) {
            throw new IllegalStateException(this.getIdentifier() + " is not transmitting");
        }
    }

    public void verifyCanUpdate() {
        this.readLock.lock();
        try {
            if (this.isTransmitting()) {
                throw new IllegalStateException(this.getIdentifier() + " is currently transmitting");
            }
            for (Port port : this.inputPorts.values()) {
                if (!port.isRunning()) continue;
                throw new IllegalStateException(this.getIdentifier() + " has running Port: " + port.getIdentifier());
            }
            for (Port port : this.outputPorts.values()) {
                if (!port.isRunning()) continue;
                throw new IllegalStateException(this.getIdentifier() + " has running Port: " + port.getIdentifier());
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Optional<String> getVersionedComponentId() {
        return Optional.ofNullable(this.versionedComponentId.get());
    }

    public void setVersionedComponentId(String versionedComponentId) {
        boolean updated = false;
        while (!updated) {
            String currentId = this.versionedComponentId.get();
            if (currentId == null) {
                updated = this.versionedComponentId.compareAndSet(null, versionedComponentId);
                continue;
            }
            if (currentId.equals(versionedComponentId)) {
                return;
            }
            if (versionedComponentId == null) {
                updated = this.versionedComponentId.compareAndSet(currentId, null);
                continue;
            }
            throw new IllegalStateException(this + " is already under version control");
        }
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    private class InitializationTask
    implements Runnable {
        private InitializationTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block30: {
                if (!StandardRemoteProcessGroup.this.initialized) {
                    return;
                }
                try (SiteToSiteRestApiClient apiClient = StandardRemoteProcessGroup.this.getSiteToSiteRestApiClient();){
                    try {
                        ControllerDTO dto = apiClient.getController(StandardRemoteProcessGroup.this.targetUris);
                        if (dto.getRemoteSiteListeningPort() == null && SiteToSiteTransportProtocol.RAW.equals((Object)StandardRemoteProcessGroup.this.transportProtocol)) {
                            StandardRemoteProcessGroup.this.authorizationIssue = "Remote instance is not configured to allow RAW Site-to-Site communications at this time.";
                        } else if (dto.getRemoteSiteHttpListeningPort() == null && SiteToSiteTransportProtocol.HTTP.equals((Object)StandardRemoteProcessGroup.this.transportProtocol)) {
                            StandardRemoteProcessGroup.this.authorizationIssue = "Remote instance is not configured to allow HTTP Site-to-Site communications at this time.";
                        } else {
                            StandardRemoteProcessGroup.this.authorizationIssue = null;
                        }
                        StandardRemoteProcessGroup.this.writeLock.lock();
                        try {
                            StandardRemoteProcessGroup.this.listeningPort = dto.getRemoteSiteListeningPort();
                            StandardRemoteProcessGroup.this.listeningHttpPort = dto.getRemoteSiteHttpListeningPort();
                            StandardRemoteProcessGroup.this.destinationSecure = dto.isSiteToSiteSecure();
                        }
                        finally {
                            StandardRemoteProcessGroup.this.writeLock.unlock();
                        }
                    }
                    catch (SiteToSiteRestApiClient.HttpGetFailedException e) {
                        if (e.getResponseCode() == UNAUTHORIZED_STATUS_CODE) {
                            block31: {
                                try {
                                    boolean isApiSecure = apiClient.getBaseUrl().toLowerCase().startsWith("https");
                                    RemoteNiFiUtils utils = new RemoteNiFiUtils(isApiSecure ? StandardRemoteProcessGroup.this.sslContext : null);
                                    Response requestAccountResponse = utils.issueRegistrationRequest(apiClient.getBaseUrl());
                                    if (Response.Status.Family.SUCCESSFUL.equals((Object)requestAccountResponse.getStatusInfo().getFamily())) {
                                        logger.info("{} Issued a Request to communicate with remote instance", (Object)this);
                                    } else {
                                        logger.error("{} Failed to request account: got unexpected response code of {}:{}", new Object[]{this, requestAccountResponse.getStatus(), requestAccountResponse.getStatusInfo().getReasonPhrase()});
                                    }
                                }
                                catch (Exception re) {
                                    logger.error("{} Failed to request account due to {}", (Object)this, (Object)re.toString());
                                    if (!logger.isDebugEnabled()) break block31;
                                    logger.error("", (Throwable)re);
                                }
                            }
                            StandardRemoteProcessGroup.this.authorizationIssue = e.getDescription();
                            break block30;
                        }
                        if (e.getResponseCode() == FORBIDDEN_STATUS_CODE) {
                            StandardRemoteProcessGroup.this.authorizationIssue = e.getDescription();
                            break block30;
                        }
                        String message = e.getDescription();
                        logger.warn("{} When communicating with remote instance, got unexpected result. {}", (Object)this, (Object)message);
                        StandardRemoteProcessGroup.this.authorizationIssue = "Unable to determine Site-to-Site availability.";
                    }
                }
                catch (Exception e) {
                    logger.warn(String.format("Unable to connect to %s due to %s", StandardRemoteProcessGroup.this, e));
                    StandardRemoteProcessGroup.this.getEventReporter().reportEvent(Severity.WARNING, "Site to Site", String.format("Unable to connect to %s due to %s", StandardRemoteProcessGroup.this.getTargetUris(), e));
                }
            }
        }
    }
}

