/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BooleanSupplier;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceReference;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceStateTransition {
    private static final Logger logger = LoggerFactory.getLogger(ServiceStateTransition.class);
    private ControllerServiceState state = ControllerServiceState.DISABLED;
    private final List<CompletableFuture<?>> enabledFutures = new ArrayList();
    private final List<CompletableFuture<?>> disabledFutures = new ArrayList();
    private final ControllerServiceNode controllerServiceNode;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Condition stateChangeCondition = this.writeLock.newCondition();

    public ServiceStateTransition(ControllerServiceNode controllerServiceNode) {
        this.controllerServiceNode = controllerServiceNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transitionToEnabling(ControllerServiceState expectedState, CompletableFuture<?> enabledFuture) {
        this.writeLock.lock();
        try {
            if (expectedState != this.state) {
                boolean bl = false;
                return bl;
            }
            this.state = ControllerServiceState.ENABLING;
            logger.debug("{} transitioned to ENABLING", (Object)this.controllerServiceNode);
            this.stateChangeCondition.signalAll();
            this.enabledFutures.add(enabledFuture);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enable(ControllerServiceReference controllerServiceReference) {
        this.writeLock.lock();
        try {
            if (this.state != ControllerServiceState.ENABLING) {
                logger.debug("{} cannot be transitioned to enabled because it's not currently ENABLING but rather {}", (Object)this.controllerServiceNode, (Object)this.state);
                boolean bl = false;
                return bl;
            }
            this.state = ControllerServiceState.ENABLED;
            logger.debug("{} is now fully ENABLED", (Object)this.controllerServiceNode);
            this.enabledFutures.forEach(future -> future.complete(null));
        }
        finally {
            this.writeLock.unlock();
        }
        List referencingComponents = controllerServiceReference.findRecursiveReferences(ComponentNode.class);
        for (ComponentNode component : referencingComponents) {
            component.performValidation();
        }
        this.writeLock.lock();
        try {
            this.stateChangeCondition.signalAll();
        }
        finally {
            this.writeLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transitionToDisabling(ControllerServiceState expectedState, CompletableFuture<?> disabledFuture) {
        this.writeLock.lock();
        try {
            if (expectedState != this.state) {
                logger.debug("{} cannot be transitioned to DISABLING because its state is {}, not the expected {}", new Object[]{this.controllerServiceNode, this.state, expectedState});
                boolean bl = false;
                return bl;
            }
            this.state = ControllerServiceState.DISABLING;
            this.stateChangeCondition.signalAll();
            this.disabledFutures.add(disabledFuture);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void disable() {
        this.writeLock.lock();
        try {
            this.state = ControllerServiceState.DISABLED;
            logger.info("{} is now fully DISABLED", (Object)this.controllerServiceNode);
            this.stateChangeCondition.signalAll();
            this.disabledFutures.forEach(future -> future.complete(null));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ControllerServiceState getState() {
        this.readLock.lock();
        try {
            ControllerServiceState controllerServiceState = this.state;
            return controllerServiceState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitCondition(BooleanSupplier predicate, long timePeriod, TimeUnit timeUnit, String desiredConditionDescription) throws InterruptedException {
        Objects.requireNonNull(timeUnit);
        long timeout = System.currentTimeMillis() + timeUnit.toMillis(timePeriod);
        this.writeLock.lock();
        try {
            while (!predicate.getAsBoolean()) {
                long millisLeft = timeout - System.currentTimeMillis();
                if (millisLeft <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                logger.debug("State of {} is currently {}. Will wait up to {} milliseconds for condition to become {}", new Object[]{this.controllerServiceNode, this.state, millisLeft, desiredConditionDescription});
                this.stateChangeCondition.await(millisLeft, TimeUnit.MILLISECONDS);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean awaitState(ControllerServiceState desiredState, long timePeriod, TimeUnit timeUnit) throws InterruptedException {
        return this.awaitCondition(() -> desiredState == this.state, timePeriod, timeUnit, "service has a state of " + desiredState.name());
    }

    public boolean awaitStateOrInvalid(ControllerServiceState desiredState, long timePeriod, TimeUnit timeUnit) throws InterruptedException {
        BooleanSupplier predicate = () -> desiredState == this.state || this.controllerServiceNode.getValidationStatus() == ValidationStatus.INVALID;
        return this.awaitCondition(predicate, timePeriod, timeUnit, "service has a state of " + desiredState.name());
    }

    public void signalInvalid() {
        this.writeLock.lock();
        try {
            this.stateChangeCondition.signalAll();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

