/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.inheritance;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.AuthorizerCapabilityDetection;
import org.apache.nifi.authorization.ManagedAuthorizer;
import org.apache.nifi.authorization.exception.UninheritableAuthorizationsException;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.inheritance.FlowInheritability;
import org.apache.nifi.controller.inheritance.FlowInheritabilityCheck;

public class AuthorizerCheck
implements FlowInheritabilityCheck {
    @Override
    public FlowInheritability checkInheritability(DataFlow existingFlow, DataFlow proposedFlow, FlowController flowController) {
        byte[] existing = existingFlow.getAuthorizerFingerprint();
        byte[] proposed = proposedFlow.getAuthorizerFingerprint();
        if (existing == null && proposed == null) {
            return FlowInheritability.notInheritable(null);
        }
        if (existing == null && proposed != null) {
            return FlowInheritability.notInheritable("Current Authorizer is an external Authorizer, but proposed Authorizer is an internal Authorizer");
        }
        if (existing != null && proposed == null) {
            return FlowInheritability.notInheritable("Current Authorizer is an internal Authorizer, but proposed Authorizer is an external Authorizer");
        }
        if (!Arrays.equals(existing, proposed)) {
            Authorizer authorizer = flowController.getAuthorizer();
            if (AuthorizerCapabilityDetection.isManagedAuthorizer((Authorizer)authorizer)) {
                ManagedAuthorizer managedAuthorizer = (ManagedAuthorizer)authorizer;
                try {
                    managedAuthorizer.checkInheritability(new String(proposed, StandardCharsets.UTF_8));
                    return FlowInheritability.inheritable();
                }
                catch (UninheritableAuthorizationsException e) {
                    return FlowInheritability.notInheritable("Proposed Authorizations do not match current Authorizations: " + e.getMessage());
                }
            }
            return FlowInheritability.notInheritable("Proposed Authorizations do not match current Authorizations and are not configured with an internal Authorizer");
        }
        return FlowInheritability.notInheritable(null);
    }
}

